/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.factory;

import com.vmware.h5.sdk.plugin.migration.factory.ModelFactory;
import com.vmware.h5.sdk.plugin.migration.factory.ModelFactoryNotFoundException;
import com.vmware.h5.sdk.plugin.migration.factory.impl.DefinitionsModelFactory;
import com.vmware.h5.sdk.plugin.migration.factory.impl.HomeScopeModelFactory;
import com.vmware.h5.sdk.plugin.migration.factory.impl.ObjectScopesModelFactory;
import com.vmware.h5.sdk.plugin.migration.factory.impl.PluginConfigModelFactory;
import com.vmware.h5.sdk.plugin.migration.factory.impl.PluginDataModelFactory;
import com.vmware.h5.sdk.plugin.migration.factory.impl.RequirementsModelFactory;
import com.vmware.h5.sdk.plugin.migration.model.ObjectScopes;
import com.vmware.h5.sdk.plugin.migration.model.Requirements;
import com.vmware.vise.plugin.manifest.model.Definitions;
import com.vmware.vise.plugin.manifest.model.PluginConfig;
import com.vmware.vise.plugin.manifest.model.PluginData;
import com.vmware.vise.plugin.manifest.model.home.HomeScope;
import java.util.HashMap;
import java.util.Map;

public class ModelFactoryProvider {
    private static final Map<Class<?>, Class<?>> registry = new HashMap();

    public static void register(Class<?> clazz, Class<?> factoryClass) {
        registry.put(clazz, factoryClass);
    }

    public static ModelFactory<?> getFactory(Class<?> clazz) throws ModelFactoryNotFoundException {
        return ModelFactoryProvider.getFactoryFromRegistry(clazz);
    }

    private static ModelFactory<?> getFactoryFromRegistry(Class<?> clazz) throws ModelFactoryNotFoundException {
        try {
            if (registry.containsKey(clazz)) {
                Class<?> builderClass = registry.get(clazz);
                ModelFactory modelFactoryInstance = (ModelFactory)builderClass.newInstance();
                return modelFactoryInstance;
            }
            throw new ModelFactoryNotFoundException(String.format("ModelFactory not found for class %s", clazz));
        }
        catch (Exception ex) {
            throw new ModelFactoryNotFoundException(String.format("ModelFactory not found for class %s", clazz), ex);
        }
    }

    static {
        registry.put(PluginData.class, PluginDataModelFactory.class);
        registry.put(PluginConfig.class, PluginConfigModelFactory.class);
        registry.put(HomeScope.class, HomeScopeModelFactory.class);
        registry.put(ObjectScopes.class, ObjectScopesModelFactory.class);
        registry.put(Definitions.class, DefinitionsModelFactory.class);
        registry.put(Requirements.class, RequirementsModelFactory.class);
    }
}

