/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.file;

import com.vmware.h5.sdk.plugin.migration.config.Configuration;
import com.vmware.h5.sdk.plugin.migration.model.Manifest;
import com.vmware.h5.sdk.plugin.migration.model.PluginPackage;
import com.vmware.h5.sdk.plugin.migration.utils.XmlUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PluginConfigFileReader {
    private Path pluginXmlFilePath;
    private Path pluginPkgFilePath;
    private Path manifestFilePath;
    private Configuration configuration;
    private static final List<String> EXCLUDE_FOLDERS_LIST = Arrays.asList("target", "dist", "node_modules");

    public PluginConfigFileReader(Configuration configuration) throws Exception {
        this.configuration = configuration;
        this.initializePaths();
    }

    public File getPluginXmlFile() {
        File pluginXmlFile = this.pluginXmlFilePath.toFile();
        return pluginXmlFile;
    }

    public File getPluginPackageXmlFile() {
        File pluginPkgXmlFile = null;
        if (this.pluginPkgFilePath != null) {
            pluginPkgXmlFile = this.pluginPkgFilePath.toFile();
        }
        return pluginPkgXmlFile;
    }

    public File getManifestFile() {
        File manifestFile = this.manifestFilePath.toFile();
        return manifestFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Manifest getManifest() {
        Manifest manifest;
        block23: {
            BufferedReader bufferedReader = null;
            manifest = new Manifest();
            File manifestFile = this.getManifestFile();
            bufferedReader = new BufferedReader(new FileReader(manifestFile));
            String line = bufferedReader.readLine();
            while (line != null) {
                String[] contents = line.split(":");
                if (contents != null && contents.length > 1) {
                    switch (contents[0]) {
                        case "Manifest-Version": {
                            manifest.setManifestVersion(contents[1].trim());
                            break;
                        }
                        case "Web-ContextPath": {
                            manifest.setWebContextPath(contents[1].trim());
                        }
                    }
                }
                line = bufferedReader.readLine();
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block23;
            }
            catch (IOException ex) {
                System.out.println(String.format("Error closing reader %s", ex.getMessage()));
            }
            break block23;
            catch (IOException ex) {
                try {
                    System.out.println(String.format("Error reading MANIFEST.MF file %s", ex.getMessage()));
                }
                catch (Throwable throwable) {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException ex2) {
                        System.out.println(String.format("Error closing reader %s", ex2.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException ex3) {
                    System.out.println(String.format("Error closing reader %s", ex3.getMessage()));
                }
            }
        }
        return manifest;
    }

    public PluginPackage getPluginPackage() throws Exception {
        PluginPackage pluginPackage = new PluginPackage();
        File pluginPackageFile = this.getPluginPackageXmlFile();
        if (pluginPackageFile != null) {
            Document document = XmlUtils.getDocumentForFile(pluginPackageFile);
            Element rootElement = document.getDocumentElement();
            pluginPackage.setPluginPackageName(XmlUtils.getAttributeValue(rootElement, "name"));
            Element pluginPackageElement = XmlUtils.getLastChildElementNode(rootElement, "dependencies", "pluginPackage");
            if (pluginPackageElement != null) {
                pluginPackage.setVsphereClientVersion(XmlUtils.getAttributeValue(pluginPackageElement, "version"));
            }
        }
        return pluginPackage;
    }

    private void initializePaths() throws IOException {
        Path path = Paths.get(this.configuration.getProjectDir(), new String[0]);
        this.pluginXmlFilePath = this.getPath(path, "plugin.xml");
        this.pluginPkgFilePath = this.getPluginPackageXmlFilePath(path);
        this.manifestFilePath = this.getPath(path, "MANIFEST.MF");
    }

    private Path getPluginPackageXmlFilePath(Path path) {
        Path pluginPackageXmlFilePath = null;
        try {
            pluginPackageXmlFilePath = this.getPath(path, "plugin-package.xml");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pluginPackageXmlFilePath;
    }

    private Path getPath(Path rootPath, final String fileName) throws IOException {
        final ArrayList paths = new ArrayList();
        Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                if (EXCLUDE_FOLDERS_LIST.contains(path.getFileName().toString())) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                String pathFileName = path.getFileName().toString();
                if (fileName.equals(pathFileName)) {
                    paths.add(path);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        if (paths.isEmpty()) {
            throw new FileNotFoundException(String.format("Not able to find file - %s", fileName));
        }
        if (paths.size() > 1) {
            boolean validOption;
            System.out.println(String.format("There are more than one file found with file name %s.", fileName));
            for (int i = 0; i < paths.size(); ++i) {
                System.out.println(String.format("%d. File path - %s", i + 1, ((Path)paths.get(i)).toString()));
            }
            System.out.println("Choose one of the options listed above by pressing either 1 or 2 etc.");
            Scanner scanner = new Scanner(System.in);
            int option = scanner.nextInt();
            boolean bl = validOption = option <= paths.size();
            while (!validOption) {
                option = scanner.nextInt();
                validOption = option <= paths.size();
            }
            Path pathOption = (Path)paths.get(option - 1);
            System.out.println(String.format("Selected file path for the option %d is %s", option, pathOption.toString()));
            return pathOption;
        }
        return (Path)paths.get(0);
    }
}

