/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.parser.impl;

import com.vmware.h5.sdk.plugin.migration.ExtensionType;
import com.vmware.h5.sdk.plugin.migration.UnsupportedExtensionInfo;
import com.vmware.h5.sdk.plugin.migration.config.Configuration;
import com.vmware.h5.sdk.plugin.migration.factory.ModelFactoryNotFoundException;
import com.vmware.h5.sdk.plugin.migration.factory.ModelFactoryProvider;
import com.vmware.h5.sdk.plugin.migration.file.PluginConfigFileReader;
import com.vmware.h5.sdk.plugin.migration.file.PluginConfigFileWriter;
import com.vmware.h5.sdk.plugin.migration.model.Manifest;
import com.vmware.h5.sdk.plugin.migration.model.PluginBuilderConfig;
import com.vmware.h5.sdk.plugin.migration.model.PluginPackage;
import com.vmware.h5.sdk.plugin.migration.model.ResourceDefinition;
import com.vmware.h5.sdk.plugin.migration.parser.Parser;
import com.vmware.h5.sdk.plugin.migration.utils.PluginMigrationUtils;
import com.vmware.h5.sdk.plugin.migration.utils.XmlUtils;
import com.vmware.vise.plugin.manifest.model.PluginData;
import com.vmware.vise.plugin.manifest.model.object.ObjectType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PluginConfigParser
implements Parser {
    private Configuration configuration;
    private PluginConfigFileReader pluginConfigFileReader;
    private PluginConfigFileWriter pluginConfigFileWriter;

    public PluginConfigParser(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void parse() {
        try {
            System.out.println("Starting the migration of plugin xml to json format");
            this.pluginConfigFileReader = new PluginConfigFileReader(this.configuration);
            this.pluginConfigFileWriter = new PluginConfigFileWriter(this.configuration);
            Document document = this.readPluginXmlDocument();
            PluginBuilderConfig pluginBuilderConfig = this.createPluginBuilderConfig(document);
            PluginData pluginData = this.buildPluginData(pluginBuilderConfig);
            this.serializePluginData(pluginData);
            this.logAllUnSupportedExtensions(pluginBuilderConfig);
        }
        catch (ModelFactoryNotFoundException ex) {
            if (this.pluginConfigFileWriter != null) {
                this.pluginConfigFileWriter.logError(ex.getMessage());
            }
            ex.printStackTrace();
        }
        catch (Exception ex) {
            if (this.pluginConfigFileWriter != null) {
                this.pluginConfigFileWriter.logError(ex.getMessage());
            }
            ex.printStackTrace();
        }
    }

    private void logAllUnSupportedExtensions(PluginBuilderConfig pluginBuilderConfig) {
        TreeMap<UnsupportedExtensionInfo, List<Element>> unsupportedMap = new TreeMap<UnsupportedExtensionInfo, List<Element>>();
        unsupportedMap.putAll(pluginBuilderConfig.getUnsupportedExtensionsMap());
        unsupportedMap.putAll(pluginBuilderConfig.getUnsupportedConditionsMap());
        for (Map.Entry entry : unsupportedMap.entrySet()) {
            this.pluginConfigFileWriter.logWarning(((UnsupportedExtensionInfo)entry.getKey()).getMessage());
            ((List)entry.getValue()).stream().forEach(element -> this.pluginConfigFileWriter.logMessage((Element)element));
        }
        System.out.println(String.format("report.txt is generated in the directory %s", this.configuration.getOutputDir()));
    }

    private void serializePluginData(PluginData pluginData) {
        this.pluginConfigFileWriter.serializePluginData(pluginData);
    }

    private Map<String, List<Element>> parseExtensions(Element docElement) {
        Map<String, List<Element>> extensionGroup = XmlUtils.getExtensionPointNameToChildExtensionElementsMap(docElement);
        return extensionGroup;
    }

    private Map<String, List<Element>> parseTemplateInstances(Element docElement) {
        return XmlUtils.getTemplateInstancesGroupedByNamespace(docElement);
    }

    private PluginData buildPluginData(PluginBuilderConfig pluginBuilderConfig) throws Exception {
        PluginData pluginData = (PluginData)ModelFactoryProvider.getFactory(PluginData.class).createModel(pluginBuilderConfig);
        return pluginData;
    }

    private PluginBuilderConfig createPluginBuilderConfig(Document document) throws Exception {
        Element docElement = document.getDocumentElement();
        PluginBuilderConfig pluginBuilderConfig = new PluginBuilderConfig();
        pluginBuilderConfig.setUnsupportedExtensionsMap(new HashMap<UnsupportedExtensionInfo, List<Element>>());
        pluginBuilderConfig.setUnsupportedConditionsMap(new HashMap<UnsupportedExtensionInfo, List<Element>>());
        Map<String, List<Element>> extensionsMap = this.parseExtensions(docElement);
        Map<String, List<Element>> templateInstancesMap = this.parseTemplateInstances(docElement);
        Manifest manifest = this.pluginConfigFileReader.getManifest();
        PluginPackage pluginPackage = this.pluginConfigFileReader.getPluginPackage();
        pluginBuilderConfig.setGlobalViewExtensionsMap(this.getGlobalViewExtensionsMap(extensionsMap));
        Map<ObjectType, List<Element>> objectTypeExtensionsMap = PluginMigrationUtils.createObjectTypeExtensionsMap(extensionsMap, templateInstancesMap, pluginBuilderConfig);
        pluginBuilderConfig.setObjectTypeExtensionsMap(objectTypeExtensionsMap);
        pluginBuilderConfig.setManifest(manifest);
        pluginBuilderConfig.setPluginPackage(pluginPackage);
        pluginBuilderConfig.setConfiguration(this.configuration);
        pluginBuilderConfig.setResourceDefinition(this.getResourceDefinition(docElement));
        pluginBuilderConfig.setPluginId(this.getPluginId(docElement));
        pluginBuilderConfig.setPluginDefaultBundleName(this.getPluginDefaultBundle(docElement));
        return pluginBuilderConfig;
    }

    private String getPluginId(Element docElement) {
        return XmlUtils.getAttributeValue(docElement, "id").replaceAll("\\.", "_");
    }

    private String getPluginDefaultBundle(Element docElement) {
        return XmlUtils.getAttributeValue(docElement, "defaultBundle");
    }

    private ResourceDefinition getResourceDefinition(Element docElement) {
        Element resourceElement = XmlUtils.getChildElement(docElement, "resources");
        String resourceFolderName = XmlUtils.getAttributeValue(resourceElement, "baseUrl");
        String baseResourceFileName = XmlUtils.getChildElementNodeValue(resourceElement, "resource");
        Element cssDependencyElement = XmlUtils.getLastChildElementNode(docElement, "dependencies", "dependency");
        String cssFilePath = null;
        if (cssDependencyElement != null) {
            cssFilePath = XmlUtils.getAttributeValue(cssDependencyElement, "uri");
        }
        ResourceDefinition resourceDefinition = new ResourceDefinition();
        resourceDefinition.setLocaleResourceFolderName(resourceFolderName);
        resourceDefinition.setBaseLocaleResourceFileName(baseResourceFileName);
        resourceDefinition.setPluginCssResourceName(cssFilePath);
        return resourceDefinition;
    }

    private Map<String, List<Element>> getGlobalViewExtensionsMap(Map<String, List<Element>> extensionsMap) {
        LinkedHashMap<String, List<Element>> globalViewsExtensionsMap = new LinkedHashMap<String, List<Element>>();
        Set<Map.Entry<String, List<Element>>> entries = extensionsMap.entrySet();
        for (Map.Entry<String, List<Element>> entry : entries) {
            if (ExtensionType.NAVIGATOR.toString().equals(entry.getKey()) || ExtensionType.SHORTCUTS.toString().equals(entry.getKey())) {
                this.populateGlobalViewsExtensionMap(globalViewsExtensionsMap, entry.getValue(), element -> XmlUtils.getLastChildElementNodeValue(element, "object", "navigationTargetUid"));
                continue;
            }
            if (!ExtensionType.GLOBAL_VIEWS.toString().equals(entry.getKey())) continue;
            this.populateGlobalViewsExtensionMap(globalViewsExtensionsMap, entry.getValue(), element -> XmlUtils.getAttributeValue(element, "id"));
        }
        return globalViewsExtensionsMap;
    }

    private void populateGlobalViewsExtensionMap(Map<String, List<Element>> globalViewsExtensionsMap, List<Element> elements, Function<Element, String> function) {
        for (Element element : elements) {
            String id = function.apply(element);
            globalViewsExtensionsMap.computeIfAbsent(id, o -> new ArrayList()).add(element);
        }
    }

    private Document readPluginXmlDocument() {
        Document document = null;
        try {
            File pluginXmlFile = this.pluginConfigFileReader.getPluginXmlFile();
            document = XmlUtils.getDocumentForFile(pluginXmlFile);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            ex.printStackTrace();
            this.pluginConfigFileWriter.logError(String.format("Unable to parse xml file %s", ex.getMessage()));
        }
        return document;
    }
}

