/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.serialize;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.vmware.h5.sdk.plugin.migration.config.Configuration;
import com.vmware.vise.plugin.manifest.model.PluginData;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PluginDataSerializer {
    private Configuration configuration;

    public PluginDataSerializer(Configuration configuration) {
        this.configuration = configuration;
    }

    public void serialize(PluginData pluginData) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            DefaultIndenter indenter = new DefaultIndenter("   ", DefaultIndenter.SYS_LF);
            DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
            printer.indentObjectsWith(indenter);
            printer.indentArraysWith(indenter);
            mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            Path pluginJsonFilePath = Paths.get(this.configuration.getOutputDir(), "plugin.json");
            File jsonFile = pluginJsonFilePath.toFile();
            mapper.writer(printer).writeValue(jsonFile, (Object)pluginData);
            System.out.println(String.format("plugin.json is generated in the directory %s", this.configuration.getOutputDir()));
        }
        catch (IOException ioe) {
            String err = String.format("Unable to serialize plugin data to JSON to the output directory <%s>. Reason: %s", this.configuration.getOutputDir(), ioe.getMessage());
            throw new RuntimeException(err, ioe);
        }
    }
}

