/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.common;

import com.vmware.vise.data.common.PathParam;
import com.vmware.vise.data.common.PathTemplate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;

public class MappingUtil {
    public static boolean matchesMapping(String mappingType, String mappingProperty, String type2, String property, Map<String, Object> disoveredArgByName) {
        PathTemplate propTemplate;
        if (PathTemplate.matches(mappingType, type2) && (propTemplate = new PathTemplate(mappingProperty)).matches(property)) {
            MappingUtil.addDiscoveredArgs(mappingProperty, property, disoveredArgByName);
            return true;
        }
        return false;
    }

    public static void addDiscoveredArgs(String mappingProperty, String templateParam, Map<String, Object> disoveredArgByName) {
        PathTemplate propTemplate = new PathTemplate(mappingProperty);
        Map<String, String> pathArgs = propTemplate.match(templateParam);
        disoveredArgByName.putAll(pathArgs);
    }

    public static Object[] resolveArgs(Method method, Object[] args, Map<String, Object> disoveredArgByName) {
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        Object[] resolvedArgs = new Object[paramAnnotations.length];
        for (int i = 0; i < paramAnnotations.length; ++i) {
            if (i < args.length) {
                resolvedArgs[i] = args[i];
            }
            for (Annotation annotation : paramAnnotations[i]) {
                if (!(annotation instanceof PathParam)) continue;
                if (disoveredArgByName == null) {
                    throw new IllegalArgumentException("No matched URI variables passed.");
                }
                String argName = ((PathParam)annotation).value();
                resolvedArgs[i] = disoveredArgByName.get(argName);
            }
        }
        return resolvedArgs;
    }
}

