/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.ResourceObjectReferenceAdapter;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryUtil {
    private static final Log _logger = LogFactory.getLog(QueryUtil.class);
    public static final Constraint[] EMPTY_CONSTRAINTS = new Constraint[0];
    public static final QuerySpec[] EMPTY_QUERY_SPEC_ARRAY = new QuerySpec[0];
    public static final ResultSet[] EMPTYSET = new ResultSet[0];
    public static final ResultItem[] EMPTY_RESULT_ITEM_ARRAY = new ResultItem[0];
    public static final PropertyValue[] EMPTY_PROPERTY_VALUE_ARRAY = new PropertyValue[0];
    public static final ResultSet EMPTY_RESULT_SET = new ResultSet();
    public static final FacetInfo[] EMPTY_FACET_INFO_ARRAY = new FacetInfo[0];
    public static final TypeInfo[] EMPTY_TYPE_INFO = new TypeInfo[0];
    private static volatile DataServiceExtensionRegistryInternal _dataAdapterRegistry;

    public static void setDataServiceExtensionRegistry(DataServiceExtensionRegistry dataAdapterRegistry) {
        if (dataAdapterRegistry != null && !(dataAdapterRegistry instanceof DataServiceExtensionRegistryInternal)) {
            throw new IllegalArgumentException("dataAdapterRegistry should be an instance of DataServiceExtensionRegistryInternal");
        }
        _dataAdapterRegistry = (DataServiceExtensionRegistryInternal)dataAdapterRegistry;
    }

    @Deprecated
    public static String getReferenceType(Object reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Invalid argument to lookup reference type.");
        }
        ResourceObjectReferenceAdapter adapter = _dataAdapterRegistry.getObjectRefTypeAdapter(reference.getClass());
        if (adapter == null) {
            return null;
        }
        String type2 = adapter.getResourceType(reference);
        return type2;
    }

    @Deprecated
    public static String getReferenceServerGuid(Object reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Invalid argument to lookup reference serverGuid.");
        }
        ResourceObjectReferenceAdapter adapter = _dataAdapterRegistry.getObjectRefTypeAdapter(reference.getClass());
        if (adapter == null) {
            return null;
        }
        String uid = adapter.getServerGuid(reference);
        return uid;
    }

    @Deprecated
    public static String getReferenceUid(Object reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Invalid argument to lookup reference uid.");
        }
        ResourceObjectReferenceAdapter adapter = _dataAdapterRegistry.getObjectRefTypeAdapter(reference.getClass());
        if (adapter == null) {
            return null;
        }
        String uid = adapter.getUid(reference);
        return uid;
    }

    @Deprecated
    public static Object getReference(String uid) {
        if (uid == null) {
            throw new IllegalArgumentException("Invalid argument to lookup reference.");
        }
        ResourceObjectReferenceAdapter adapter = _dataAdapterRegistry.getObjectRefTypeAdapter(uid);
        if (adapter == null) {
            return null;
        }
        Object entityRef = adapter.getReference(uid);
        return entityRef;
    }

    @Deprecated
    public static <T> T getProperty(DataService dataService, Object obj, String prop) throws Exception {
        PropertyValue[] properties;
        if (obj == null || StringUtil.isNullOrEmpty((String)prop)) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        for (PropertyValue property : properties = QueryUtil.getProperties(dataService, obj, new String[]{prop})) {
            if (property == null || property.propertyName == null || !property.propertyName.equals(prop)) continue;
            return (T)property.value;
        }
        return null;
    }

    @Deprecated
    public static PropertyValue[] getProperty(DataService dataService, Object[] objs, String prop) throws Exception {
        return QueryUtil.getProperties(dataService, objs, new String[]{prop});
    }

    @Deprecated
    public static PropertyValue[] getProperties(DataService dataService, Object obj, String[] properties) throws Exception {
        return QueryUtil.getProperties(dataService, obj, properties, null);
    }

    public static PropertyValue[] getProperties(DataService dataService, Object obj, String[] properties, Map<String, List<ParameterSpec>> paramSpecsByProperty) throws Exception {
        return QueryUtil.getProperties(dataService, new Object[]{obj}, properties, paramSpecsByProperty);
    }

    @Deprecated
    public static PropertyValue[] getProperties(DataService dataService, Object[] objs, String[] properties) throws Exception {
        return QueryUtil.getProperties(dataService, objs, properties, null);
    }

    public static PropertyValue[] getProperties(DataService dataService, Object[] objs, String[] properties, Map<String, List<ParameterSpec>> paramSpecsByProperty) throws Exception {
        ResultItem[] items;
        if (objs == null || objs.length == 0 || properties == null || properties.length == 0) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        Object obj = objs[0];
        QuerySpec query = QueryUtil.buildQuerySpec(objs, properties, paramSpecsByProperty);
        query.name = QueryUtil.getReferenceUid(obj) + ".properties";
        ResultSet resultSet = QueryUtil.getData(dataService, query);
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (resultSet != null && (items = resultSet.items) != null && items.length > 0 && items[0] != null) {
            for (ResultItem item : items) {
                for (PropertyValue v : item.properties) {
                    v.resourceObject = item.resourceObject;
                    result.add(v);
                }
            }
        }
        if (result.isEmpty() && resultSet.error != null) {
            throw resultSet.error;
        }
        return (PropertyValue[])ArrayUtil.toArray(result, PropertyValue.class);
    }

    @Deprecated
    public static PropertyValue[] getPropertyForRelatedObjects(DataService dataService, Object object, String relationship, String targetType, String property) throws Exception {
        return QueryUtil.getPropertiesForRelatedObjects(dataService, object, relationship, targetType, new String[]{property});
    }

    @Deprecated
    public static PropertyValue[] getPropertiesForRelatedObjects(DataService dataService, Object obj, String relationship, String targetType, String[] properties) throws Exception {
        if (obj == null || properties == null || properties.length == 0) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        if (StringUtil.isNullOrEmpty((String)relationship)) {
            return QueryUtil.getProperties(dataService, obj, properties);
        }
        ObjectIdentityConstraint objectConstraint = QueryUtil.createObjectIdentityConstraint(obj);
        RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint(relationship, objectConstraint, true, targetType);
        QuerySpec query = QueryUtil.buildQuerySpec(relationalConstraint, properties);
        query.name = QueryUtil.getReferenceUid(obj) + "." + relationship + ".properties";
        ResultSet resultSet = QueryUtil.getData(dataService, query);
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (resultSet != null && resultSet.items != null) {
            for (ResultItem item : resultSet.items) {
                if (item == null || item.properties == null) continue;
                for (PropertyValue propValue : item.properties) {
                    if (propValue == null) continue;
                    result.add(propValue);
                }
            }
        }
        if (result.isEmpty() && resultSet.error != null) {
            throw resultSet.error;
        }
        return (PropertyValue[])ArrayUtil.toArray(result, PropertyValue.class);
    }

    @Deprecated
    public static ResultSet getData(DataService dataService, QuerySpec query) throws Exception {
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{query};
        Response response = new Response();
        response = dataService.getData(requestSpec);
        ResultSet[] retVal = response.resultSet;
        if (retVal == null || retVal.length == 0 || retVal[0] == null) {
            throw new Exception(Utils.getLocalizedString("error.emptyResult"));
        }
        return retVal[0];
    }

    @Deprecated
    public static QuerySpec buildQuerySpec(Object entity, String[] properties) {
        return QueryUtil.buildQuerySpec(entity, properties, null);
    }

    public static QuerySpec buildQuerySpec(Object entity, String[] properties, Map<String, List<ParameterSpec>> paramSpecsByProperty) {
        ObjectIdentityConstraint oc = new ObjectIdentityConstraint();
        oc.target = entity;
        String targetType = QueryUtil.getReferenceType(entity);
        HashSet<String> targetTypes = new HashSet<String>();
        targetTypes.add(targetType);
        QuerySpec query = QueryUtil.buildQuerySpec(oc, properties, targetTypes, paramSpecsByProperty);
        return query;
    }

    @Deprecated
    public static QuerySpec buildQuerySpec(Object[] entities, String[] properties) {
        return QueryUtil.buildQuerySpec(entities, properties, null);
    }

    public static QuerySpec buildQuerySpec(Object[] entities, String[] properties, Map<String, List<ParameterSpec>> paramSpecsByProperty) {
        if (entities.length == 1) {
            return QueryUtil.buildQuerySpec(entities[0], properties, paramSpecsByProperty);
        }
        CompositeConstraint cc = new CompositeConstraint();
        cc.conjoiner = Conjoiner.OR;
        Constraint[] nestedConstraints = new Constraint[entities.length];
        HashSet<String> targetTypes = new HashSet<String>();
        String targetType = null;
        for (int index = 0; index < entities.length; ++index) {
            ObjectIdentityConstraint oc = new ObjectIdentityConstraint();
            oc.target = entities[index];
            nestedConstraints[index] = oc;
            targetType = QueryUtil.getReferenceType(oc.target);
            targetTypes.add(targetType);
        }
        cc.nestedConstraints = nestedConstraints;
        QuerySpec query = QueryUtil.buildQuerySpec(cc, properties, targetTypes, paramSpecsByProperty);
        return query;
    }

    @Deprecated
    public static QuerySpec buildQuerySpec(Constraint constraint, String[] properties) {
        QuerySpec query = QueryUtil.buildQuerySpec(constraint, properties, (Set<String>)null);
        return query;
    }

    @Deprecated
    public static QuerySpec buildQuerySpec(Constraint constraint, String[] properties, Set<String> targetTypes) {
        return QueryUtil.buildQuerySpec(constraint, properties, targetTypes, null);
    }

    public static QuerySpec buildQuerySpec(Constraint constraint, String[] properties, Set<String> targetTypes, Map<String, List<ParameterSpec>> paramSpecsByProperty) {
        QuerySpec query = new QuerySpec();
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        ArrayList<PropertySpec> pSpecs = new ArrayList<PropertySpec>();
        if (targetTypes != null) {
            for (String targetType : targetTypes) {
                PropertySpec propSpec = QueryUtil.createPropertySpec(properties, targetType, paramSpecsByProperty);
                pSpecs.add(propSpec);
            }
        } else {
            PropertySpec propSpec = QueryUtil.createPropertySpec(properties, null, paramSpecsByProperty);
            pSpecs.add(propSpec);
        }
        resourceSpec.propertySpecs = pSpecs.toArray(new PropertySpec[0]);
        query.resourceSpec = resourceSpec;
        return query;
    }

    private static PropertySpec createPropertySpec(String[] properties, String targetType, Map<String, List<ParameterSpec>> parameterSpecsByProperty) {
        PropertySpec propSpec = new PropertySpec();
        propSpec.type = targetType;
        propSpec.propertyNames = properties;
        if (parameterSpecsByProperty != null && !parameterSpecsByProperty.isEmpty() && !ArrayUtil.isNullOrEmpty((Object[])properties)) {
            ArrayList parameterSpecs = new ArrayList();
            for (String property : properties) {
                if (parameterSpecsByProperty.get(property) == null) continue;
                parameterSpecs.addAll(parameterSpecsByProperty.get(property));
            }
            propSpec.parameters = parameterSpecs.toArray(new ParameterSpec[0]);
        }
        return propSpec;
    }

    @Deprecated
    public static <T> T findPropertyValueIn(String prop, List<ResultItem> resultItems) {
        if (resultItems == null || resultItems.isEmpty()) {
            return null;
        }
        for (ResultItem resultItem : resultItems) {
            PropertyValue[] propValues = resultItem.properties;
            if (propValues == null || propValues.length == 0) continue;
            for (PropertyValue propValue : propValues) {
                if (!propValue.propertyName.equals(prop)) continue;
                return (T)propValue.value;
            }
        }
        return null;
    }

    public static boolean validateQueryConstraint(Constraint constraint) {
        if (constraint == null) {
            _logger.warn((Object)"Invalid constraint: constraint is null");
            return false;
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            boolean isValid;
            ObjectIdentityConstraint oic = (ObjectIdentityConstraint)constraint;
            boolean bl = isValid = oic.target != null;
            if (!isValid) {
                _logger.warn((Object)"Invalid constraint: constraint target is null");
            }
            return isValid;
        }
        if (constraint instanceof RelationalConstraint) {
            RelationalConstraint rc = (RelationalConstraint)constraint;
            if (StringUtil.isNullOrEmpty((String)rc.relation)) {
                _logger.warn((Object)"Invalid constraint: relational constraint's relation is null");
                return false;
            }
            return QueryUtil.validateQueryConstraint(rc.constraintOnRelatedObject);
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint cc = (CompositeConstraint)constraint;
            if (cc.nestedConstraints == null) {
                _logger.warn((Object)"Invalid composite constraint: nested constraints are null");
                return false;
            }
            if (cc.nestedConstraints.length == 0) {
                _logger.warn((Object)"Invalid composite constraint: nested constraints are empty");
                return false;
            }
            if (cc.conjoiner == null) {
                _logger.warn((Object)"Invalid composite constraint: conjoiner is null");
                return false;
            }
            for (Constraint c : cc.nestedConstraints) {
                if (QueryUtil.validateQueryConstraint(c)) continue;
                return false;
            }
        } else if (constraint instanceof PropertyConstraint) {
            boolean isValid;
            PropertyConstraint pc = (PropertyConstraint)constraint;
            boolean bl = isValid = pc.comparator != null;
            if (!isValid) {
                _logger.warn((Object)"Invalid constraint: property constraint comparator is null");
            }
            return isValid;
        }
        return true;
    }

    @Deprecated
    public static Boolean waitUntilSearchable(DataService dataService, Object object, String[] requiredProperties) {
        return QueryUtil.waitUntilStatusChange(dataService, object, requiredProperties, true);
    }

    @Deprecated
    public static Boolean waitUntilSearchable(DataService dataService, Object object) {
        return QueryUtil.waitUntilSearchable(dataService, object, new String[]{"name"});
    }

    @Deprecated
    public static Boolean waitUntilNotSearchable(DataService dataService, Object object, String[] requiredProperties) {
        return QueryUtil.waitUntilStatusChange(dataService, object, requiredProperties, false);
    }

    @Deprecated
    public static Boolean waitUntilNotSearchable(DataService dataService, Object object) {
        return QueryUtil.waitUntilNotSearchable(dataService, object, new String[]{"name"});
    }

    @Deprecated
    private static Boolean waitUntilStatusChange(DataService dataService, Object object, String[] requiredProperties, boolean waitUntilObjectFound) {
        int numberOfAttempts = 30;
        PropertyValue[] properties = null;
        boolean syncSuccesfully = false;
        for (int count = 0; count < 30; ++count) {
            try {
                properties = QueryUtil.getProperties(dataService, object, requiredProperties);
                boolean hasProperties = QueryUtil.checkProperties(properties, requiredProperties);
                if (waitUntilObjectFound && hasProperties) {
                    syncSuccesfully = true;
                    break;
                }
                if (!waitUntilObjectFound && !hasProperties) {
                    syncSuccesfully = true;
                    break;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                _logger.error((Object)e);
            }
        }
        return syncSuccesfully;
    }

    @Deprecated
    public static Boolean waitUntilPropertyChanged(DataService dataService, Object object, PropertyChangeInfo propInfo) throws Exception {
        String property = propInfo.getPropertyName();
        int numberOfAttempts = 30;
        boolean objectChanged = false;
        _logger.debug((Object)("Start waiting for change in property '" + property + "' on object " + QueryUtil.getReferenceUid(object)));
        for (int count = 0; count < 30; ++count) {
            Object propValue = QueryUtil.getProperty(dataService, object, property);
            objectChanged = propInfo.isChanged(propValue);
            if (objectChanged) {
                _logger.debug((Object)("Property '" + property + "' on object " + QueryUtil.getReferenceUid(object) + " has changed!"));
                break;
            }
            _logger.debug((Object)("No change detected for property '" + property + "' on object " + QueryUtil.getReferenceUid(object)));
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                _logger.error((Object)e);
            }
        }
        return objectChanged;
    }

    public static RelationalConstraint createRelationalConstraint(String relationship, Constraint constraintOnRelatedObject, Boolean hasInverseRelation, String targetType) {
        RelationalConstraint rc = new RelationalConstraint();
        rc.relation = relationship;
        rc.hasInverseRelation = hasInverseRelation;
        rc.constraintOnRelatedObject = constraintOnRelatedObject;
        rc.targetType = targetType;
        return rc;
    }

    public static Constraint createConstraintForRelationship(Object object, String relationship, String targetType) {
        ObjectIdentityConstraint objectConstraint = QueryUtil.createObjectIdentityConstraint(object);
        RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint(relationship, objectConstraint, true, targetType);
        return relationalConstraint;
    }

    public static PropertyConstraint createPropertyConstraint(String objectType, String propertyName, Comparator comparator, Object comparableValue) {
        PropertyConstraint constraint = new PropertyConstraint();
        constraint.targetType = objectType;
        constraint.propertyName = propertyName;
        constraint.comparator = comparator;
        constraint.comparableValue = comparableValue;
        return constraint;
    }

    public static Constraint combineIntoSingleConstraint(Constraint[] constraints, Conjoiner conjoiner) {
        if (constraints == null || constraints.length == 0) {
            return null;
        }
        if (constraints.length == 1) {
            return constraints[0];
        }
        return QueryUtil.createCompositeConstraint(constraints, conjoiner);
    }

    public static Constraint combineIntoSingleConstraint(Object[] entities, Conjoiner conjoiner) {
        if (entities == null || entities.length == 0) {
            return null;
        }
        Constraint[] nestedConstraints = new Constraint[entities.length];
        for (int index = 0; index < entities.length; ++index) {
            ObjectIdentityConstraint oc = QueryUtil.createObjectIdentityConstraint(entities[index]);
            nestedConstraints[index] = oc;
        }
        if (entities.length == 1) {
            return nestedConstraints[0];
        }
        return QueryUtil.createCompositeConstraint(nestedConstraints, conjoiner);
    }

    public static CompositeConstraint createCompositeConstraint(Constraint[] nestedConstraints, Conjoiner conjoiner) {
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.nestedConstraints = nestedConstraints;
        compositeConstraint.conjoiner = conjoiner;
        return compositeConstraint;
    }

    public static ObjectIdentityConstraint createObjectIdentityConstraint(Object entity) {
        ObjectIdentityConstraint oc = new ObjectIdentityConstraint();
        oc.target = entity;
        return oc;
    }

    public static ResourceSpec createEmptyResourceSpec() {
        PropertySpec propSpec = new PropertySpec();
        propSpec.propertyNames = new String[0];
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.propertySpecs = new PropertySpec[]{propSpec};
        return resourceSpec;
    }

    public static Object[] findMoRefsIn(ResultSet result) {
        ResultItem[] resultItems;
        Object[] refs = null;
        if (result != null && (resultItems = result.items) != null && resultItems.length > 0) {
            refs = (Object[])Array.newInstance(resultItems[0].resourceObject.getClass(), resultItems.length);
            for (int i = 0; i < resultItems.length; ++i) {
                refs[i] = resultItems[i].resourceObject;
            }
        }
        return refs;
    }

    private static boolean checkProperties(PropertyValue[] properties, String[] propertyNames) {
        if (properties == null || propertyNames == null || properties.length < propertyNames.length) {
            return false;
        }
        HashSet<String> propertyNameSet = new HashSet<String>();
        for (PropertyValue property : properties) {
            if (property == null || property.value == null) {
                return false;
            }
            propertyNameSet.add(property.propertyName);
        }
        for (String propertyName : propertyNames) {
            if (propertyName == null || propertyNameSet.contains(propertyName)) continue;
            return false;
        }
        return true;
    }

    public static String getLocalizedString(String key) {
        return Utils.getLocalizedString(key);
    }

    public static boolean areEquivalent(QuerySpec a, QuerySpec b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return ObjectUtil.objectsEqual((Object)a.resourceSpec, (Object)b.resourceSpec) && ObjectUtil.objectsEqual((Object)a.resultSpec, (Object)b.resultSpec) && ObjectUtil.objectsEqual(a.options, b.options);
    }

    public static boolean objectExists(Object reference, DataService dataService) {
        if (reference == null || dataService == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        try {
            QuerySpec query = QueryUtil.buildQuerySpec(reference, new String[0]);
            ResultSet resultSet = QueryUtil.getData(dataService, query);
            return resultSet.items.length != 0;
        }
        catch (Exception e) {
            _logger.error((Object)("isValidObjectRef: Error in querying from data service, object reference = " + reference), (Throwable)e);
            return false;
        }
    }

    static {
        QueryUtil.EMPTY_RESULT_SET.items = EMPTY_RESULT_ITEM_ARRAY;
        QueryUtil.EMPTY_RESULT_SET.facets = EMPTY_FACET_INFO_ARRAY;
        _dataAdapterRegistry = null;
    }

    @Deprecated
    public static class PropertyValueMap {
        public Map<String, PropertyValue> data = new HashMap<String, PropertyValue>();

        public PropertyValueMap() {
        }

        public PropertyValueMap(PropertyValue[] pvs) {
            this.putProperties(pvs);
        }

        public void putProperty(PropertyValue value) {
            String key = QueryUtil.getReferenceUid(value.resourceObject) + "|" + value.propertyName;
            this.data.put(key, value);
        }

        public void putProperties(PropertyValue[] values) {
            for (PropertyValue pv : values) {
                this.putProperty(pv);
            }
        }

        public PropertyValue getProperty(Object entity, String propertyName) {
            if (entity == null || propertyName == null) {
                return null;
            }
            String key = QueryUtil.getReferenceUid(entity) + "|" + propertyName;
            PropertyValue result = this.data.get(key);
            return result;
        }
    }

    public static interface PropertyChangeInfo {
        public String getPropertyName();

        public boolean isChanged(Object var1);
    }
}

