/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

import com.vmware.vise.data.query.commands.DataFetchCommandFactory;
import com.vmware.vise.data.query.commands.impl.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StringTransformer
implements Transformer {
    private static Log _logger = LogFactory.getLog(DataFetchCommandFactory.class);

    StringTransformer() {
    }

    @Override
    public Object value(String propertyName, Object propertyValue, boolean useDefaultWhenNull, boolean useDefaultWhenTypeMismatch) {
        if (propertyValue instanceof String) {
            return propertyValue;
        }
        if (propertyValue == null) {
            _logger.warn((Object)(propertyName + ":Null value is returned from data service. "));
            return null;
        }
        try {
            return String.valueOf(propertyValue);
        }
        catch (Exception ex) {
            if (useDefaultWhenTypeMismatch) {
                return null;
            }
            _logger.warn((Object)(propertyName + ":" + propertyValue + " can not be converted to a string. "));
            throw new RuntimeException(ex);
        }
    }
}

