/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.ComponentProperties;
import com.vmware.vise.data.query.ComputedPropertyInfo;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.PropertyProviderInfo;
import com.vmware.vise.data.query.impl.ServicePropertyProviderAdapter;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.util.IdentityHashSet;
import com.vmware.vise.util.StringUtil;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ComponentPropertyRetriever {
    private static final Set<String> EMPTY_PROPERTIES = new HashSet<String>(0);
    private final DataServiceExtensionRegistryInternal _dataAdapterRegistry;

    public ComponentPropertyRetriever(DataServiceExtensionRegistryInternal dataAdapterRegistry) {
        this._dataAdapterRegistry = dataAdapterRegistry;
    }

    public Set<String> getComponentProperties(String type2, Set<String> properties) {
        if (properties == null) {
            return EMPTY_PROPERTIES;
        }
        if (StringUtil.isNullOrEmpty((String)type2) || properties.isEmpty()) {
            return properties;
        }
        Collection<PropertyProviderInfo> propertyProviders = this._dataAdapterRegistry.getPropertyProviders(type2, properties);
        if (propertyProviders.isEmpty()) {
            return properties;
        }
        IdentityHashSet propProviderAdapters = new IdentityHashSet();
        IdentityHashSet propProviderBeans = new IdentityHashSet();
        for (PropertyProviderInfo providerInfo : propertyProviders) {
            if (providerInfo.propertyProvider instanceof ServicePropertyProviderAdapter) {
                ServicePropertyProviderAdapter servicePropertyProvider = (ServicePropertyProviderAdapter)providerInfo.propertyProvider;
                propProviderBeans.add(servicePropertyProvider.getPropertyProvider());
                continue;
            }
            propProviderAdapters.add(providerInfo.propertyProvider);
        }
        HashMap<String, Set<String>> componentProperties = new HashMap<String, Set<String>>();
        Map<String, Set<String>> componentPropertiesFromPropBeans = ComponentPropertyRetriever.getComponentPropertiesFromPropertyBeans(properties, (Set<PropertyProviderBean>)propProviderBeans);
        componentProperties.putAll(componentPropertiesFromPropBeans);
        Map<String, Set<String>> componentPropertiesFromPropAdapters = this.getComponentPropertiesFromPropertyAdapters(properties, (Set<PropertyProviderAdapter>)propProviderAdapters);
        componentProperties.putAll(componentPropertiesFromPropAdapters);
        if (componentProperties.isEmpty()) {
            return properties;
        }
        Set<String> componentEquivalentProperties = this.mergeComponentProperties(properties, componentProperties);
        return this.getComponentProperties(type2, componentEquivalentProperties);
    }

    private static Map<String, Set<String>> getComponentPropertiesFromPropertyBeans(Set<String> properties, Set<PropertyProviderBean> propProviderBeans) {
        HashMap<String, Set<String>> componentProperties = new HashMap<String, Set<String>>(properties.size());
        for (PropertyProviderBean propProviderBean : propProviderBeans) {
            Method[] propertyMethods;
            for (Method method : propertyMethods = propProviderBean.getClass().getMethods()) {
                ComponentProperties componentPropertiesAnnotation;
                String propertyName = Utils.getPropertyName(method);
                if (StringUtil.isNullOrEmpty((String)propertyName) || !properties.contains(propertyName) || (componentPropertiesAnnotation = method.getAnnotation(ComponentProperties.class)) == null) continue;
                HashSet<String> equivalentProperties = new HashSet<String>(componentPropertiesAnnotation.value().length);
                for (String simpleProp : componentPropertiesAnnotation.value()) {
                    equivalentProperties.add(simpleProp);
                }
                componentProperties.put(propertyName, equivalentProperties);
            }
        }
        return componentProperties;
    }

    private Map<String, Set<String>> getComponentPropertiesFromPropertyAdapters(Set<String> properties, Set<PropertyProviderAdapter> propProviderAdapters) {
        HashMap<String, Set<String>> componentProperties = new HashMap<String, Set<String>>(properties.size());
        if (propProviderAdapters == null || propProviderAdapters.isEmpty()) {
            return componentProperties;
        }
        for (PropertyProviderAdapter propProviderAdapter : propProviderAdapters) {
            TypeInfo[] registeredTypes = this._dataAdapterRegistry.getProvidedTypeInfos(propProviderAdapter);
            if (registeredTypes == null || registeredTypes.length == 0) continue;
            for (TypeInfo typeInfo : registeredTypes) {
                if (typeInfo.computedProperties == null) continue;
                for (ComputedPropertyInfo computedPropInfo : typeInfo.computedProperties) {
                    if (!properties.contains(computedPropInfo.propertyName)) continue;
                    HashSet<String> equivalentProperties = new HashSet<String>(computedPropInfo.componentProperties.length);
                    for (String equivalentProperty : computedPropInfo.componentProperties) {
                        equivalentProperties.add(equivalentProperty);
                    }
                    componentProperties.put(computedPropInfo.propertyName, equivalentProperties);
                }
            }
        }
        return componentProperties;
    }

    private Set<String> mergeComponentProperties(Set<String> properties, Map<String, Set<String>> componentProperties) {
        HashSet<String> componentEquivalentProperties = new HashSet<String>();
        for (String property : properties) {
            Set<String> equivalentProps = componentProperties.get(property);
            if (equivalentProps == null) {
                componentEquivalentProperties.add(property);
                continue;
            }
            componentEquivalentProperties.addAll(equivalentProps);
        }
        return componentEquivalentProperties;
    }
}

