/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.collection.DepthFirstTreeIterator;
import com.vmware.vise.util.collection.Node;
import com.vmware.vise.util.collection.Tree;
import com.vmware.vise.util.collection.TreeIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ConstraintTree
implements Tree<Constraint>,
Cloneable {
    private Node<Constraint> _root;

    public ConstraintTree(Constraint constraint) {
        ConstraintNode rootNode;
        this._root = rootNode = new ConstraintNode(constraint);
    }

    private ConstraintTree(Node<Constraint> root) {
        this._root = root;
    }

    public Node<Constraint> getRoot() {
        return this._root;
    }

    public void setRoot(Node<Constraint> root) {
        this._root = root;
    }

    public TreeIterator<Constraint> iterator() {
        return new DepthFirstTreeIterator((Tree)this);
    }

    public ConstraintTree clone() {
        Node<Constraint> copiedRoot = this.copy(this._root);
        return new ConstraintTree(copiedRoot);
    }

    private Node<Constraint> copy(Node<Constraint> node) {
        List children = node.getChildren();
        ArrayList<Node<Constraint>> newChildNodes = new ArrayList<Node<Constraint>>(children.size());
        for (Node childNode : children) {
            Node<Constraint> newChildNode = this.copy((Node<Constraint>)childNode);
            newChildNodes.add(newChildNode);
        }
        Node<Constraint> newNode = this.newNode(node, newChildNodes);
        return newNode;
    }

    private Node<Constraint> newNode(Node<Constraint> node, Collection<Node<Constraint>> children) {
        Constraint constraint = (Constraint)node.getData();
        Constraint newConstr = (Constraint)ObjectUtil.shallowCopy((Object)constraint, constraint.getClass());
        ConstraintNode newNode = new ConstraintNode(newConstr);
        newNode.clearChildren();
        for (Node<Constraint> childNode : children) {
            newNode.appendChild(childNode);
        }
        return newNode;
    }

    public static class ConstraintNode
    implements Node<Constraint> {
        private final Constraint _constraint;
        private Node<Constraint> _parent;

        public ConstraintNode(Constraint constraint) {
            this._constraint = constraint;
        }

        public Constraint getData() {
            return this._constraint;
        }

        public Node<Constraint> getParent() {
            return this._parent;
        }

        public void setParent(Node<Constraint> parent) {
            this._parent = parent;
        }

        public void appendChild(Node<Constraint> child) {
            ConstraintNode.addChild(this.getData(), (Constraint)child.getData());
            child.setParent((Node)this);
        }

        public void removeChild(Node<Constraint> child) {
            ConstraintNode.removeChild(this.getData(), (Constraint)child.getData());
            child.setParent(null);
        }

        public void clearChildren() {
            List<Node<Constraint>> children = this.getChildren();
            ConstraintNode.clearChildren(this.getData());
            ConstraintNode.unregisterParent(children);
        }

        public Node<Constraint> getChild(int index) {
            List<Node<Constraint>> childrenNodes = this.getChildren();
            return childrenNodes.get(index);
        }

        public void setChild(int index, Node<Constraint> child) {
            ConstraintNode.setChild(this.getData(), index, (Constraint)child.getData());
            child.setParent((Node)this);
        }

        public List<Node<Constraint>> getChildren() {
            Constraint[] children = ConstraintNode.getChildren(this._constraint);
            List<Node<Constraint>> childNodes = ConstraintNode.toConstraintNodes(children);
            ConstraintNode.registerParent(childNodes, this);
            return Collections.unmodifiableList(childNodes);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ConstraintNode)) {
                return false;
            }
            Constraint constraint = ((ConstraintNode)object).getData();
            return this._constraint.equals(constraint);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this._constraint.hashCode();
            return result;
        }

        private static List<Node<Constraint>> toConstraintNodes(Constraint[] children) {
            ArrayList<Node<Constraint>> nodes = new ArrayList<Node<Constraint>>(children.length);
            for (Constraint constr : children) {
                nodes.add(new ConstraintNode(constr));
            }
            return nodes;
        }

        private static void registerParent(Collection<Node<Constraint>> children, Node<Constraint> parentNode) {
            for (Node<Constraint> cnstrNode : children) {
                cnstrNode.setParent(parentNode);
            }
        }

        private static void unregisterParent(Collection<Node<Constraint>> children) {
            for (Node<Constraint> cnstrNode : children) {
                cnstrNode.setParent(null);
            }
        }

        private static Constraint[] getChildren(Constraint constraint) {
            if (constraint instanceof CompositeConstraint) {
                CompositeConstraint cc = (CompositeConstraint)constraint;
                return cc.nestedConstraints;
            }
            if (constraint instanceof RelationalConstraint) {
                RelationalConstraint rc = (RelationalConstraint)constraint;
                return new Constraint[]{rc.constraintOnRelatedObject};
            }
            return new Constraint[0];
        }

        private static void addChild(Constraint parent, Constraint constraintToAdd) {
            if (parent instanceof CompositeConstraint) {
                CompositeConstraint cc = (CompositeConstraint)parent;
                Constraint[] newChildren = Arrays.copyOf(cc.nestedConstraints, cc.nestedConstraints.length + 1);
                newChildren[newChildren.length - 1] = constraintToAdd;
                cc.nestedConstraints = newChildren;
            } else if (parent instanceof RelationalConstraint) {
                RelationalConstraint rc = (RelationalConstraint)parent;
                rc.constraintOnRelatedObject = constraintToAdd;
            } else {
                throw new UnsupportedOperationException("Cannot perform this operation on leaf constraint.");
            }
        }

        private static void removeChild(Constraint parent, Constraint constraintToRemove) {
            if (parent instanceof CompositeConstraint) {
                CompositeConstraint cc = (CompositeConstraint)parent;
                Constraint[] newChildren = new Constraint[cc.nestedConstraints.length - 1];
                int index = 0;
                for (Constraint constr : cc.nestedConstraints) {
                    if (constr.equals(constraintToRemove)) continue;
                    newChildren[index++] = constr;
                }
                cc.nestedConstraints = newChildren;
            } else if (parent instanceof RelationalConstraint) {
                RelationalConstraint rc = (RelationalConstraint)parent;
                if (rc.constraintOnRelatedObject.equals(constraintToRemove)) {
                    rc.constraintOnRelatedObject = null;
                }
            } else {
                throw new UnsupportedOperationException("Cannot perform this operation on leaf constraint.");
            }
        }

        private static void setChild(Constraint parent, int index, Constraint constraintToSet) {
            if (parent instanceof CompositeConstraint) {
                CompositeConstraint cc = (CompositeConstraint)parent;
                if (index < 0 || index >= cc.nestedConstraints.length) {
                    throw new IllegalArgumentException("Invalid is out of range.");
                }
                cc.nestedConstraints[index] = constraintToSet;
            } else if (parent instanceof RelationalConstraint) {
                RelationalConstraint rc = (RelationalConstraint)parent;
                if (index != 0) {
                    throw new IllegalArgumentException("Invalid is out of range.");
                }
                rc.constraintOnRelatedObject = constraintToSet;
            } else {
                throw new UnsupportedOperationException("Cannot perform this operation on leaf constraint.");
            }
        }

        private static void clearChildren(Constraint parent) {
            if (parent instanceof CompositeConstraint) {
                CompositeConstraint cc = (CompositeConstraint)parent;
                cc.nestedConstraints = new Constraint[0];
            } else if (parent instanceof RelationalConstraint) {
                RelationalConstraint rc = (RelationalConstraint)parent;
                rc.constraintOnRelatedObject = null;
            }
        }
    }
}

