/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.impl.DataAdapterExecutionDetails;
import com.vmware.vise.data.query.impl.DataAdapterInfo;
import com.vmware.vise.data.query.impl.DataAdapterUtil;
import com.vmware.vise.data.query.impl.DataAdaptersExecutionResult;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.ProfiledTaskExecutor;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

final class DataAdapterRetriever {
    private final DataServiceExtensionRegistryInternal _dataAdapterRegistryInternal;
    private final ProfiledTaskExecutor _taskExecutor;
    private final Map<QuerySpec, QuerySpec> _internalQueryTransformationMap = new IdentityHashMap<QuerySpec, QuerySpec>();
    private final Map<DataAdapterInfo, List<QuerySpec>> _queriesByAdapter = new IdentityHashMap<DataAdapterInfo, List<QuerySpec>>();
    private final Map<QuerySpec, QuerySpec> _queryBySingleItemQuery = new IdentityHashMap<QuerySpec, QuerySpec>();
    private final Map<QuerySpec, List<ResultSetInfo>> _combinedResultsByQuery = new IdentityHashMap<QuerySpec, List<ResultSetInfo>>();
    private final List<DataAdapterExecutionDetails> _executionDetails = new ArrayList<DataAdapterExecutionDetails>();

    DataAdapterRetriever(DataServiceExtensionRegistryInternal dataAdapterRegistry, ProfiledTaskExecutor taskExecutor) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataAdapterRegistry, taskExecutor});
        this._dataAdapterRegistryInternal = dataAdapterRegistry;
        this._taskExecutor = taskExecutor;
    }

    AdapterInvocationResults getResultsFromDataAdapters() throws InterruptedException {
        AdapterInvocationResults invocationResults = this.invokeDataAdapters(this._queriesByAdapter);
        this._executionDetails.addAll(invocationResults.executionDetails);
        Map<QuerySpec, List<ResultSetInfo>> resultsByQuery = invocationResults.adapterResultsByQuery;
        Map<QuerySpec, List<ResultSetInfo>> singleItemResultsByQuery = this.extractSingleItemResults(resultsByQuery);
        Set<QuerySpec> multiAdapterMergeSpecs = this.extractMultiAdapterQueries(singleItemResultsByQuery, resultsByQuery);
        for (QuerySpec transformedQuery : resultsByQuery.keySet()) {
            QuerySpec inputQuery = this._internalQueryTransformationMap.get(transformedQuery);
            List<ResultSetInfo> adapterResults = resultsByQuery.get(transformedQuery);
            List<ResultSetInfo> combinedResults = this._combinedResultsByQuery.get(inputQuery);
            if (combinedResults == null) {
                combinedResults = new ArrayList<ResultSetInfo>();
                this._combinedResultsByQuery.put(inputQuery, combinedResults);
            }
            combinedResults.addAll(adapterResults);
        }
        Map<DataAdapterInfo, List<QuerySpec>> multiAdapterQueries = this.getMultiAdapterQueriesByAdapter(multiAdapterMergeSpecs);
        AdapterInvocationResults multiAdapterInvocationResults = this.invokeDataAdapters(multiAdapterQueries);
        resultsByQuery = multiAdapterInvocationResults.adapterResultsByQuery;
        DataAdapterRetriever.markResultsAsUnpaged(resultsByQuery);
        for (QuerySpec transformedQuery : resultsByQuery.keySet()) {
            QuerySpec inputQuery = this._internalQueryTransformationMap.get(transformedQuery);
            List<ResultSetInfo> adapterResults = resultsByQuery.get(transformedQuery);
            List<ResultSetInfo> combinedResults = this._combinedResultsByQuery.get(inputQuery);
            if (combinedResults == null) {
                combinedResults = new ArrayList<ResultSetInfo>();
                this._combinedResultsByQuery.put(inputQuery, combinedResults);
            }
            combinedResults.addAll(adapterResults);
        }
        this._executionDetails.addAll(multiAdapterInvocationResults.executionDetails);
        invocationResults = new AdapterInvocationResults();
        invocationResults.adapterResultsByQuery = this._combinedResultsByQuery;
        invocationResults.executionDetails = this._executionDetails;
        return invocationResults;
    }

    void addQuerySpecs(Set<QuerySpec> querySpecs) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{querySpecs});
        for (QuerySpec querySpec : querySpecs) {
            this.addQuerySpec(querySpec);
        }
    }

    private void addQuerySpec(QuerySpec querySpec) {
        this._internalQueryTransformationMap.put(querySpec, querySpec);
        Collection<DataAdapterInfo> queryAdapters = this._dataAdapterRegistryInternal.getDataAdapters(querySpec);
        if (queryAdapters.isEmpty()) {
            Exception error = new Exception(String.format(Utils.getLocalizedString("error.noAdapterFoundForQuery"), querySpec.name));
            ResultSetInfo result = ResultSetInfo.createErrorResult(error);
            DataAdapterRetriever.addResult(this._combinedResultsByQuery, querySpec, result);
            return;
        }
        this.addQueriesToAdapters(querySpec, queryAdapters);
    }

    private void addQueriesToAdapters(QuerySpec query, Collection<DataAdapterInfo> queryAdapters) {
        assert (query != null);
        assert (queryAdapters != null);
        Integer offset = query.resultSpec.offset;
        QuerySpec singleItemQuery = null;
        if (queryAdapters.size() > 1 && offset != null && offset > 0) {
            singleItemQuery = DataAdapterRetriever.getSingleItemQuery(query);
            this._queryBySingleItemQuery.put(singleItemQuery, query);
        }
        for (DataAdapterInfo daInfo : queryAdapters) {
            List<QuerySpec> daQueries = this._queriesByAdapter.get(daInfo);
            if (daQueries == null) {
                daQueries = new ArrayList<QuerySpec>();
                this._queriesByAdapter.put(daInfo, daQueries);
            }
            daQueries.add(query);
            if (singleItemQuery == null) continue;
            daQueries.add(singleItemQuery);
        }
    }

    private static QuerySpec getSingleItemQuery(QuerySpec querySpec) {
        ResultSpec adjustedResultSpec;
        assert (querySpec != null);
        assert (querySpec.resultSpec != null);
        QuerySpec singleItemSpec = new QuerySpec(querySpec);
        singleItemSpec.resultSpec = adjustedResultSpec = (ResultSpec)ObjectUtil.shallowCopy((Object)querySpec.resultSpec, ResultSpec.class);
        adjustedResultSpec.maxResultCount = 1;
        adjustedResultSpec.offset = 0;
        return singleItemSpec;
    }

    private Map<QuerySpec, List<ResultSetInfo>> extractSingleItemResults(Map<QuerySpec, List<ResultSetInfo>> resultsByQuery) {
        assert (resultsByQuery != null);
        IdentityHashMap<QuerySpec, List<ResultSetInfo>> singleItemResultsByQuerySpec = new IdentityHashMap<QuerySpec, List<ResultSetInfo>>();
        for (QuerySpec querySpec : this._queryBySingleItemQuery.keySet()) {
            List<ResultSetInfo> singleItemResults = resultsByQuery.remove(querySpec);
            singleItemResultsByQuerySpec.put(querySpec, singleItemResults);
        }
        return singleItemResultsByQuerySpec;
    }

    private Set<QuerySpec> extractMultiAdapterQueries(Map<QuerySpec, List<ResultSetInfo>> singleItemResultsByQuery, Map<QuerySpec, List<ResultSetInfo>> adapterResultsByQuery) {
        assert (singleItemResultsByQuery != null);
        assert (adapterResultsByQuery != null);
        HashSet<QuerySpec> multiAdapterMergeQueries = new HashSet<QuerySpec>();
        for (QuerySpec querySpec : singleItemResultsByQuery.keySet()) {
            List<ResultSetInfo> results = singleItemResultsByQuery.get(querySpec);
            if (!DataAdapterRetriever.hasMultiAdapterResults(results)) continue;
            QuerySpec executedQuery = this._queryBySingleItemQuery.get(querySpec);
            adapterResultsByQuery.remove(executedQuery);
            QuerySpec transformedQuerySpec = DataAdapterRetriever.getMultiAdapterQuerySpec(executedQuery);
            QuerySpec originalQuery = this._internalQueryTransformationMap.get(executedQuery);
            this._internalQueryTransformationMap.put(transformedQuerySpec, originalQuery);
            multiAdapterMergeQueries.add(transformedQuerySpec);
        }
        return multiAdapterMergeQueries;
    }

    private Map<DataAdapterInfo, List<QuerySpec>> getMultiAdapterQueriesByAdapter(Set<QuerySpec> multiAdapterQueries) {
        IdentityHashMap<DataAdapterInfo, List<QuerySpec>> multiAdapterQueriesByAdapter = new IdentityHashMap<DataAdapterInfo, List<QuerySpec>>();
        for (DataAdapterInfo adapter : this._queriesByAdapter.keySet()) {
            List<QuerySpec> transformedSpecs = this.getMultiAdapterQuerySpecs(adapter, multiAdapterQueries);
            if (transformedSpecs.isEmpty()) continue;
            multiAdapterQueriesByAdapter.put(adapter, transformedSpecs);
        }
        return multiAdapterQueriesByAdapter;
    }

    private List<QuerySpec> getMultiAdapterQuerySpecs(DataAdapterInfo adapter, Set<QuerySpec> multiAdapterQueries) {
        assert (adapter != null);
        assert (multiAdapterQueries != null);
        HashSet adapterSpecs = new HashSet(this._queriesByAdapter.get(adapter));
        ArrayList<QuerySpec> transformedSpecs = new ArrayList<QuerySpec>();
        for (QuerySpec multiAdapterQuery : multiAdapterQueries) {
            QuerySpec inputQuery = this._internalQueryTransformationMap.get(multiAdapterQuery);
            if (!adapterSpecs.contains(inputQuery)) continue;
            transformedSpecs.add(multiAdapterQuery);
        }
        return transformedSpecs;
    }

    private AdapterInvocationResults invokeDataAdapters(Map<DataAdapterInfo, List<QuerySpec>> queriesByAdapter) throws InterruptedException {
        assert (queriesByAdapter != null);
        List<DataAdaptersExecutionResult> adapterResults = this.runDataTasks(queriesByAdapter);
        HashMap<QuerySpec, List<ResultSetInfo>> adapterResultsByQuery = new HashMap<QuerySpec, List<ResultSetInfo>>();
        ArrayList<DataAdapterExecutionDetails> nonSyncedExecDetails = new ArrayList<DataAdapterExecutionDetails>(adapterResults.size());
        for (DataAdaptersExecutionResult execResult : adapterResults) {
            List<DataAdapterExecutionDetails> execDetails;
            Map<QuerySpec, ResultSetInfo> resultFromAdapter = execResult.getResultsPerQuery();
            if (resultFromAdapter != null) {
                DataAdapterRetriever.addResults(adapterResultsByQuery, resultFromAdapter);
            }
            if ((execDetails = execResult.getAdaptersExecutionDetails()) == null || execDetails.size() <= 0) continue;
            nonSyncedExecDetails.addAll(execDetails);
        }
        AdapterInvocationResults result = new AdapterInvocationResults();
        result.adapterResultsByQuery = adapterResultsByQuery;
        result.executionDetails = nonSyncedExecDetails;
        return result;
    }

    private List<DataAdaptersExecutionResult> runDataTasks(Map<DataAdapterInfo, List<QuerySpec>> querySpecsByAdapter) throws InterruptedException {
        assert (querySpecsByAdapter != null);
        int numAdapters = querySpecsByAdapter.size();
        if (numAdapters > 0) {
            ArrayList<Callable<DataAdaptersExecutionResult>> tasks = new ArrayList<Callable<DataAdaptersExecutionResult>>(numAdapters);
            ArrayList<DataAdapterUtil.DataAdapterQueryBatch> queryBatches = new ArrayList<DataAdapterUtil.DataAdapterQueryBatch>(numAdapters);
            for (DataAdapterInfo daInfo : querySpecsByAdapter.keySet()) {
                List<QuerySpec> queriesForAdapter = querySpecsByAdapter.get(daInfo);
                QuerySpec[] queryBatchForAdapter = queriesForAdapter.toArray(new QuerySpec[queriesForAdapter.size()]);
                queryBatches.add(new DataAdapterUtil.DataAdapterQueryBatch(daInfo, queryBatchForAdapter));
                Callable<DataAdaptersExecutionResult> task = DataAdapterUtil.createAdapterTask(daInfo, queryBatchForAdapter, "Adapter");
                tasks.add(task);
            }
            List<DataAdaptersExecutionResult> results = DataAdapterUtil.executeAdapterTasks(this._taskExecutor, queryBatches, tasks);
            return results;
        }
        return Collections.emptyList();
    }

    private static QuerySpec getMultiAdapterQuerySpec(QuerySpec querySpec) {
        assert (querySpec != null);
        assert (querySpec.resultSpec != null);
        ResultSpec resultSpec = querySpec.resultSpec;
        if (resultSpec.maxResultCount != null && resultSpec.maxResultCount == 0 || resultSpec.offset == null || resultSpec.offset == 0) {
            return querySpec;
        }
        QuerySpec newQuerySpec = new QuerySpec(querySpec);
        ResultSpec adjustedResultSpec = (ResultSpec)ObjectUtil.shallowCopy((Object)resultSpec, ResultSpec.class);
        if (resultSpec.maxResultCount != null && resultSpec.maxResultCount > 0) {
            adjustedResultSpec.maxResultCount = resultSpec.maxResultCount + resultSpec.offset;
        }
        adjustedResultSpec.offset = 0;
        newQuerySpec.resultSpec = adjustedResultSpec;
        return newQuerySpec;
    }

    private static void markResultsAsUnpaged(Map<QuerySpec, List<ResultSetInfo>> adapterResultsByQuery) {
        assert (adapterResultsByQuery != null);
        for (QuerySpec query : adapterResultsByQuery.keySet()) {
            List<ResultSetInfo> adapterResults = adapterResultsByQuery.get(query);
            ArrayList<ResultSetInfo> tranformedResults = new ArrayList<ResultSetInfo>();
            for (ResultSetInfo resultSetInfo : adapterResults) {
                ResultSetInfo unpagedResult = ResultSetInfo.getResultSetInfo(resultSetInfo.getResultSet(), resultSetInfo.isSorted(), false);
                tranformedResults.add(unpagedResult);
            }
            adapterResults.clear();
            adapterResults.addAll(tranformedResults);
        }
    }

    private static boolean hasMultiAdapterResults(List<ResultSetInfo> adapterResults) {
        int numberOfDataSources = 0;
        for (ResultSetInfo resultSetInfo : adapterResults) {
            if (resultSetInfo == null || resultSetInfo.getItemCount() <= 0) continue;
            ++numberOfDataSources;
        }
        boolean hasMultiAdapters = numberOfDataSources > 1;
        return hasMultiAdapters;
    }

    private static void addResults(Map<QuerySpec, List<ResultSetInfo>> existingResultsByQuery, Map<QuerySpec, ResultSetInfo> newResultsByQuery) {
        assert (existingResultsByQuery != null);
        assert (newResultsByQuery != null);
        for (QuerySpec query : newResultsByQuery.keySet()) {
            ResultSetInfo resultFromAdapter = newResultsByQuery.get(query);
            DataAdapterRetriever.addResult(existingResultsByQuery, query, resultFromAdapter);
        }
    }

    private static void addResult(Map<QuerySpec, List<ResultSetInfo>> resultsByQuery, QuerySpec query, ResultSetInfo result) {
        assert (resultsByQuery != null);
        List<ResultSetInfo> results = resultsByQuery.get(query);
        if (results == null) {
            results = new ArrayList<ResultSetInfo>();
            resultsByQuery.put(query, results);
        }
        results.add(result);
    }

    static class AdapterInvocationResults {
        Map<QuerySpec, List<ResultSetInfo>> adapterResultsByQuery;
        List<DataAdapterExecutionDetails> executionDetails;

        AdapterInvocationResults() {
        }
    }
}

