/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.common.XSFacet;
import com.vmware.vise.data.common.XSFacetType;
import com.vmware.vise.metadata.QuantityTypes;
import com.vmware.vise.metadata.Units;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.ValidationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DataFormatUtil {
    private static Log _log = LogFactory.getLog(DataFormatUtil.class);
    private static final int PRECISION = 2;
    private static final boolean IS_UNIT_LABEL_INCLUDED = true;

    public static String formatValueWithUnit(Object propertyValue, Units valueUnit, Units displayForm) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyValue, valueUnit, displayForm});
        QuantityTypes valueUnitType = valueUnit.getType();
        QuantityTypes displayUnitType = displayForm.getType();
        if (valueUnitType != displayUnitType && !QuantityTypes.ANY.equals((Object)displayUnitType)) {
            return propertyValue.toString();
        }
        try {
            String formattedValue = DataFormatUtil.formatValueByUnitType(propertyValue, valueUnit, displayForm);
            return formattedValue;
        }
        catch (Exception e) {
            _log.error((Object)"Data formatting operation failed", (Throwable)e);
            return propertyValue.toString();
        }
    }

    public static String formatValueWithStaticValueSpace(Object propertyValue, XSFacet[] staticValueSpace) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyValue, staticValueSpace});
        if (staticValueSpace.length == 0) {
            return propertyValue.toString();
        }
        for (XSFacet staticValue : staticValueSpace) {
            if (!XSFacetType.ENUMERATION.equals((Object)staticValue.type)) continue;
            NameValuePair nameValuePair = (NameValuePair)staticValue.value;
            if (!propertyValue.toString().equalsIgnoreCase(nameValuePair.value.toString())) continue;
            String formattedValue = nameValuePair.name.toString();
            return formattedValue;
        }
        return propertyValue.toString();
    }

    private static String formatValueByUnitType(Object value, Units valueUnit, Units displayForm) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{value, valueUnit, displayForm});
        long valueUnitAmount = valueUnit.getBaseMultiplier();
        long displayUnitAmount = displayForm.getBaseMultiplier();
        String formattedValue = null;
        switch (valueUnit.getType()) {
            case DATE: {
                if (Units.DATE.equals((Object)displayForm)) {
                    formattedValue = FormatUtil.getDateFormatted((Object)value);
                    break;
                }
                if (Units.TIME.equals((Object)displayForm)) {
                    formattedValue = FormatUtil.getTimeFormatted((Object)value);
                    break;
                }
                formattedValue = FormatUtil.getDateTimeFormatted((Object)value);
                break;
            }
            case TIME_SPAN: {
                if (Units.AUTO.equals((Object)displayForm)) {
                    formattedValue = FormatUtil.getTimeSpanFormattedToClosestUnit((Number)((Number)value), (long)valueUnitAmount);
                    break;
                }
                formattedValue = value.toString();
                break;
            }
            case DATA_SIZE: {
                formattedValue = FormatUtil.getDataSizeFormatted((Number)((Number)value), (int)2, (long)valueUnitAmount, (long)displayUnitAmount, (boolean)true);
                break;
            }
            case FREQUENCY: {
                formattedValue = FormatUtil.getFrequencyFormatted((Number)((Number)value), (int)2, (long)valueUnitAmount, (long)displayUnitAmount, (boolean)true);
                break;
            }
            case BIT_RATE: {
                formattedValue = FormatUtil.getBitRateFormatted((Number)((Number)value), (int)2, (long)valueUnitAmount, (long)displayUnitAmount, (boolean)true);
                break;
            }
            default: {
                formattedValue = value.toString();
            }
        }
        return formattedValue;
    }
}

