/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataServiceException;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyDataInternal;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.impl.DataAdapterExecutionDetails;
import com.vmware.vise.data.query.impl.DataAdapterInfo;
import com.vmware.vise.data.query.impl.DataAdapterRetriever;
import com.vmware.vise.data.query.impl.DataAdapterUtil;
import com.vmware.vise.data.query.impl.DataAdaptersExecutionResult;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.DerivedPropertyManager;
import com.vmware.vise.data.query.impl.DerivedPropertyProviderExecutionDetails;
import com.vmware.vise.data.query.impl.ProfiledTaskExecutor;
import com.vmware.vise.data.query.impl.PropertyProviderExecutionDetails;
import com.vmware.vise.data.query.impl.PropertyProviderInfo;
import com.vmware.vise.data.query.impl.PropertyProvidersExecutionResult;
import com.vmware.vise.data.query.impl.ResultDirectory;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.data.query.impl.ResultsManager;
import com.vmware.vise.data.query.impl.ResultsMerger;
import com.vmware.vise.data.query.impl.SubTypeResolver;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.internal.profiling.ViseDsLogConfigurator;
import com.vmware.vise.data.query.transform.DataTransformer;
import com.vmware.vise.data.query.transform.Transformer;
import com.vmware.vise.data.query.transform.impl.DataTransformerImpl;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.metadata.ObjectModelProviderRegistryInternal;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.Predicate;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.profiling.ExecutionProfiler;
import com.vmware.vise.util.session.SessionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataManager {
    private static final Logger _logger = LoggerFactory.getLogger(DataManager.class);
    private final DataServiceExtensionRegistryInternal _dataAdapterRegistry;
    private final MetadataServiceRegistryInternal _metadataRegistry;
    private final ResultsMerger _resultsMerger;
    private final DataTransformer _dataTransformer;
    private final DerivedPropertyManager _derivedPropertyManager;
    private final ProfiledTaskExecutor _taskExecutor;
    private static final Object[] EMPTY_OBJECTS = new Object[0];
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final Constraint[] EMPTY_CONSTRAINTS = new Constraint[0];
    private static final PropertySpec[] EMPTY_PROP_SPECS = new PropertySpec[0];
    private static final ParameterSpec[] EMPTY_PARAMETER_SPECS = new ParameterSpec[0];
    private static final QuerySpec[] EMPTY_QUERY_SPECS = new QuerySpec[0];
    private static final String DATA_MANAGER_PREFIX = "dataManager.";
    private static final String TRANSFORM_QUERY_SPECS_TIME_LABEL = "dataManager.transformQuerySpecs";
    private static final String DATA_RETRIEVE_TIME_LABEL = "dataManager.retrieveData";
    private static final String ORDERING_PROPERTY_TIME_LABEL = "dataManager.orderingProperties";
    private static final String PAGE_SORT_TIME_LABEL = "dataManager.pageSort";
    private static final String REMAINING_PROPERTY_TIME_LABEL = "dataManager.remainingProperties";

    DataManager(DataServiceExtensionRegistryInternal dataAdapterRegistry, MetadataServiceRegistryInternal metadataRegistry, ObjectModelProviderRegistryInternal objectModelProviderRegistry, ObjectReferenceService objectReferenceService, QuerySpecBuilder querySpecBuilder, SubTypeResolver subTypeResolver, long dataRetrievalTimeoutInMillis) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataAdapterRegistry, metadataRegistry, querySpecBuilder});
        this._metadataRegistry = metadataRegistry;
        this._resultsMerger = new ResultsMerger(metadataRegistry, objectReferenceService);
        this._dataAdapterRegistry = dataAdapterRegistry;
        this._dataTransformer = new DataTransformerImpl(dataAdapterRegistry, metadataRegistry, objectModelProviderRegistry);
        this._derivedPropertyManager = new DerivedPropertyManager(dataAdapterRegistry, querySpecBuilder, objectReferenceService, subTypeResolver);
        this._taskExecutor = new ProfiledTaskExecutor(dataRetrievalTimeoutInMillis);
    }

    DataAdaptersExecutionResult getResultsFromDataAdapters(QuerySpec[] queries, ExecutionProfiler profiler) throws InterruptedException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{queries});
        Object timerKey = null;
        timerKey = profiler.startTimer(TRANSFORM_QUERY_SPECS_TIME_LABEL);
        Map<QuerySpec, QuerySpec> transformedQueries = this.transformQueries(queries);
        profiler.stopTimer(timerKey);
        timerKey = profiler.startTimer(DATA_RETRIEVE_TIME_LABEL);
        DataAdapterRetriever dataAdapterRetriever = new DataAdapterRetriever(this._dataAdapterRegistry, this._taskExecutor);
        if (transformedQueries.size() > 0) {
            dataAdapterRetriever.addQuerySpecs(transformedQueries.keySet());
        }
        DataAdapterRetriever.AdapterInvocationResults adapterResults = dataAdapterRetriever.getResultsFromDataAdapters();
        Map<QuerySpec, List<ResultSetInfo>> remappedResults = this.remapResultsForTransformedByInputQuery(adapterResults.adapterResultsByQuery, transformedQueries);
        if (remappedResults != null && remappedResults.size() > 0) {
            adapterResults.adapterResultsByQuery = remappedResults;
        }
        profiler.stopTimer(timerKey);
        Map<QuerySpec, Set<Object>> dynamicAdapterObjectsPerQuerySpec = this.markDynamicAdapterObjects(adapterResults.adapterResultsByQuery);
        Map<QuerySpec, ResultSetInfo> mergedResultsPerQuery = this._resultsMerger.mergeResultsPerQuery(adapterResults.adapterResultsByQuery);
        DataAdaptersExecutionResult result = new DataAdaptersExecutionResult(mergedResultsPerQuery, adapterResults.executionDetails, dynamicAdapterObjectsPerQuerySpec);
        return result;
    }

    DataAdaptersExecutionResult remapAndCollectResultsForEnrichedQueries(DataAdaptersExecutionResult daExecResult, Map<QuerySpec, Pair<QuerySpec, DerivedPropertyDataInternal>> enrichedQueryDataMap) {
        if (enrichedQueryDataMap == null || enrichedQueryDataMap.isEmpty()) {
            return daExecResult;
        }
        HashMap<QuerySpec, QuerySpec> enrichedQueryMap = new HashMap<QuerySpec, QuerySpec>();
        HashMap<QuerySpec, DerivedPropertyDataInternal> derivedPropertyData = new HashMap<QuerySpec, DerivedPropertyDataInternal>();
        for (QuerySpec enrichedQuery : enrichedQueryDataMap.keySet()) {
            Pair<QuerySpec, DerivedPropertyDataInternal> enrichedQueryData = enrichedQueryDataMap.get(enrichedQuery);
            if (enrichedQueryData != null && enrichedQueryData.first != null) {
                enrichedQueryMap.put(enrichedQuery, (QuerySpec)enrichedQueryData.first);
            } else {
                enrichedQueryMap.put(enrichedQuery, enrichedQuery);
            }
            derivedPropertyData.put(enrichedQuery, (DerivedPropertyDataInternal)enrichedQueryData.second);
        }
        this._derivedPropertyManager.collectDerivedPropertyData(daExecResult.getResultsPerQuery(), derivedPropertyData);
        Map<QuerySpec, ResultSetInfo> remappedResultsPerQuerySpec = this.remapEnrichedQueryResults(daExecResult.getResultsPerQuery(), enrichedQueryMap);
        List<DataAdapterExecutionDetails> remappedAdapterExecDetails = this.remapEnrichedAdapterExecDetails(daExecResult.getAdaptersExecutionDetails(), enrichedQueryMap);
        DataAdaptersExecutionResult result = new DataAdaptersExecutionResult(remappedResultsPerQuerySpec, remappedAdapterExecDetails, daExecResult.getDynamicAdapterObjectsPerQuerySpec());
        return result;
    }

    private Map<QuerySpec, List<ResultSetInfo>> remapResultsForTransformedByInputQuery(Map<QuerySpec, List<ResultSetInfo>> transformedQueryResults, Map<QuerySpec, QuerySpec> transformedQueryMap) {
        if (transformedQueryResults == null || transformedQueryResults.size() == 0) {
            return new IdentityHashMap<QuerySpec, List<ResultSetInfo>>();
        }
        if (transformedQueryMap == null || transformedQueryMap.size() == 0) {
            return transformedQueryResults;
        }
        IdentityHashMap<QuerySpec, List<ResultSetInfo>> inputQueryResults = new IdentityHashMap<QuerySpec, List<ResultSetInfo>>();
        for (QuerySpec transformedQuery : transformedQueryResults.keySet()) {
            QuerySpec inputQuery = transformedQueryMap.get(transformedQuery);
            if (inputQuery != null) {
                List<ResultSetInfo> transformedResults = transformedQueryResults.get(transformedQuery);
                ArrayList<ResultSetInfo> inputResults = (ArrayList<ResultSetInfo>)inputQueryResults.get(inputQuery);
                if (inputResults == null) {
                    inputResults = new ArrayList<ResultSetInfo>();
                    inputQueryResults.put(inputQuery, inputResults);
                }
                inputResults.addAll(transformedResults);
                continue;
            }
            inputQueryResults.put(transformedQuery, transformedQueryResults.get(transformedQuery));
        }
        return inputQueryResults;
    }

    private Map<QuerySpec, QuerySpec> transformQueries(QuerySpec[] querySpecs) {
        HashMap<QuerySpec, QuerySpec> transformedQueries = new HashMap<QuerySpec, QuerySpec>();
        Map<QuerySpec, Transformer.Result<QuerySpec>> transformedQueriesResult = this._dataTransformer.transformQueries(new ArrayList<QuerySpec>(Arrays.asList(querySpecs)));
        for (QuerySpec inputQuery : transformedQueriesResult.keySet()) {
            Transformer.Result<QuerySpec> transformedQueryResult = transformedQueriesResult.get(inputQuery);
            if (transformedQueryResult.isTransformed()) {
                QuerySpec transformedQuery = transformedQueryResult.getData();
                transformedQueries.put(transformedQuery, inputQuery);
                continue;
            }
            transformedQueries.put(inputQuery, inputQuery);
        }
        return transformedQueries;
    }

    Map<QuerySpec, Pair<QuerySpec, DerivedPropertyDataInternal>> enrichQueriesForDerivedProperties(QuerySpec[] inputQueries) {
        return this._derivedPropertyManager.replaceDerivedWithSourcePropsInQueries(inputQueries);
    }

    private Map<QuerySpec, ResultSetInfo> remapEnrichedQueryResults(Map<QuerySpec, ResultSetInfo> enrichedQueryResults, Map<QuerySpec, QuerySpec> enrichedQuerySpecsMap) {
        if (enrichedQueryResults == null || enrichedQueryResults.isEmpty()) {
            return new IdentityHashMap<QuerySpec, ResultSetInfo>();
        }
        IdentityHashMap<QuerySpec, ResultSetInfo> inputQueryResults = new IdentityHashMap<QuerySpec, ResultSetInfo>();
        for (QuerySpec enrichedQuery : enrichedQueryResults.keySet()) {
            QuerySpec inputQuery = enrichedQuerySpecsMap.get(enrichedQuery);
            ResultSetInfo enrichedResults = enrichedQueryResults.get(enrichedQuery);
            if (inputQuery != null && !inputQuery.equals(enrichedQuery)) {
                ResultSetInfo cleanedResults = this._resultsMerger.mergeResults(inputQuery, new ArrayList<ResultSetInfo>(Arrays.asList(enrichedResults)));
                inputQueryResults.put(inputQuery, cleanedResults);
                continue;
            }
            inputQueryResults.put(enrichedQuery, enrichedResults);
        }
        return inputQueryResults;
    }

    private List<DataAdapterExecutionDetails> remapEnrichedAdapterExecDetails(List<DataAdapterExecutionDetails> enrichedAdapterExecDetails, Map<QuerySpec, QuerySpec> enrichedQuerySpecsMap) {
        if (ArrayUtil.isNullOrEmpty(enrichedAdapterExecDetails)) {
            return new ArrayList<DataAdapterExecutionDetails>();
        }
        ArrayList<DataAdapterExecutionDetails> remappedAdapterExecDetails = new ArrayList<DataAdapterExecutionDetails>();
        for (DataAdapterExecutionDetails enrichedAdapterExecDetail : enrichedAdapterExecDetails) {
            QuerySpec[] enrichedAdapterQuerySpecs = enrichedAdapterExecDetail.getQuerySpecs();
            ArrayList<QuerySpec> remappedAdapterQuerySpecs = new ArrayList<QuerySpec>();
            boolean enriched = false;
            for (QuerySpec enrichedQuery : enrichedAdapterQuerySpecs) {
                QuerySpec inputQuery = enrichedQuerySpecsMap.get(enrichedQuery);
                if (inputQuery != null && !inputQuery.equals(enrichedQuery)) {
                    remappedAdapterQuerySpecs.add(inputQuery);
                    enriched = true;
                    continue;
                }
                remappedAdapterQuerySpecs.add(enrichedQuery);
            }
            if (enriched) {
                DataAdapterExecutionDetails remappedAdapterExecDetail = new DataAdapterExecutionDetails(enrichedAdapterExecDetail.getDataAdapterInfo(), enrichedAdapterExecDetail.getInvocationId(), enrichedAdapterExecDetail.getElapsedTime(), remappedAdapterQuerySpecs.toArray(new QuerySpec[remappedAdapterQuerySpecs.size()]));
                remappedAdapterExecDetails.add(remappedAdapterExecDetail);
                continue;
            }
            remappedAdapterExecDetails.add(enrichedAdapterExecDetail);
        }
        return remappedAdapterExecDetails;
    }

    private Map<QuerySpec, Set<Object>> markDynamicAdapterObjects(Map<QuerySpec, List<ResultSetInfo>> resultsPerQuery) {
        assert (resultsPerQuery != null);
        HashMap<QuerySpec, Set<Object>> dynamicAdapterObjectsPerQuerySpec = new HashMap<QuerySpec, Set<Object>>();
        for (Map.Entry<QuerySpec, List<ResultSetInfo>> entry : resultsPerQuery.entrySet()) {
            HashSet<Object> dynamicAdapterObjects = new HashSet<Object>();
            for (ResultSetInfo rsi : entry.getValue()) {
                ResultSet rs = rsi.getResultSet();
                if (rs == null || rs.items == null || !(rs instanceof DynamicProviderResultSet)) continue;
                DynamicProviderResultSet drs = (DynamicProviderResultSet)rs;
                if (drs.allowFallbackRequest) continue;
                for (ResultItem ri : rs.items) {
                    dynamicAdapterObjects.add(ri.resourceObject);
                }
            }
            QuerySpec qs = entry.getKey();
            dynamicAdapterObjectsPerQuerySpec.put(qs, dynamicAdapterObjects);
        }
        return dynamicAdapterObjectsPerQuerySpec;
    }

    List<PropertyProvidersExecutionResult> getResultsFromPropertyProviders(DataAdaptersExecutionResult daExecutionResult, ExecutionProfiler profiler) throws InterruptedException {
        return this.getResultsFromPropertyProviders(daExecutionResult, false, profiler, null);
    }

    List<PropertyProvidersExecutionResult> getResultsFromDerivedPropertyProviders(DataAdaptersExecutionResult daExecutionResult, ExecutionProfiler profiler, Map<QuerySpec, Pair<QuerySpec, DerivedPropertyDataInternal>> enrichedQuerySpecsData) throws InterruptedException {
        HashMap<QuerySpec, DerivedPropertyDataInternal> derivedPropertyData = new HashMap<QuerySpec, DerivedPropertyDataInternal>();
        if (enrichedQuerySpecsData != null && !enrichedQuerySpecsData.isEmpty()) {
            for (QuerySpec enrichedQuery : enrichedQuerySpecsData.keySet()) {
                Pair<QuerySpec, DerivedPropertyDataInternal> enrichedQueryData = enrichedQuerySpecsData.get(enrichedQuery);
                if (enrichedQueryData != null && enrichedQueryData.first != null) {
                    derivedPropertyData.put((QuerySpec)enrichedQueryData.first, (DerivedPropertyDataInternal)enrichedQueryData.second);
                    continue;
                }
                derivedPropertyData.put(enrichedQuery, (DerivedPropertyDataInternal)enrichedQueryData.second);
            }
        }
        return this.getResultsFromPropertyProviders(daExecutionResult, true, profiler, derivedPropertyData);
    }

    List<PropertyProvidersExecutionResult> getResultsFromPropertyProviders(DataAdaptersExecutionResult daExecutionResult, boolean isForDerivedProperties, ExecutionProfiler profiler, Map<QuerySpec, DerivedPropertyDataInternal> derivedPropertyDataPerQuery) throws InterruptedException {
        Map<QuerySpec, ResultSetInfo> inputResults = daExecutionResult.getResultsPerQuery();
        if (inputResults == null || inputResults.isEmpty()) {
            return new ArrayList<PropertyProvidersExecutionResult>();
        }
        ArrayList<PropertyProvidersExecutionResult> ppaExecutionResults = new ArrayList<PropertyProvidersExecutionResult>();
        Map<QuerySpec, ResultSetInfo> results = daExecutionResult.getResultsPerQuery();
        Set<QuerySpec> inputQueries = inputResults.keySet();
        Map<QuerySpec, QuerySpec> transformedQueries = this.transformQueries(inputQueries.toArray(new QuerySpec[inputQueries.size()]));
        Object timerKey = profiler.startTimer(ORDERING_PROPERTY_TIME_LABEL);
        HashSet<QuerySpec> queriesPendingFurtherSorting = null;
        if (!isForDerivedProperties) {
            queriesPendingFurtherSorting = new HashSet<QuerySpec>();
        }
        PropertyProvidersExecutionResult ppExecOrderingResults = this.getResultsFromPropertyProviders(daExecutionResult, isForDerivedProperties, transformedQueries, true, derivedPropertyDataPerQuery, queriesPendingFurtherSorting);
        ppaExecutionResults.add(ppExecOrderingResults);
        profiler.stopTimer(timerKey);
        timerKey = profiler.startTimer(PAGE_SORT_TIME_LABEL);
        results = ResultsManager.applyResultSpecsToResults(results, queriesPendingFurtherSorting != null ? queriesPendingFurtherSorting : Collections.emptySet());
        profiler.stopTimer(timerKey);
        timerKey = profiler.startTimer(REMAINING_PROPERTY_TIME_LABEL);
        PropertyProvidersExecutionResult ppExecResults = this.getResultsFromPropertyProviders(daExecutionResult, isForDerivedProperties, transformedQueries, false, derivedPropertyDataPerQuery, null);
        ppaExecutionResults.add(ppExecResults);
        profiler.stopTimer(timerKey);
        return ppaExecutionResults;
    }

    private PropertyProvidersExecutionResult getResultsFromPropertyProviders(DataAdaptersExecutionResult daExecutionResult, boolean isForDerivedProperties, Map<QuerySpec, QuerySpec> transformedQueries, boolean getOnlyOrderingProps, Map<QuerySpec, DerivedPropertyDataInternal> derivedPropertyDataPerQuery, Set<QuerySpec> queriesPendingFurtherSorting) throws InterruptedException {
        Map<QuerySpec, ResultSetInfo> inputResults = daExecutionResult.getResultsPerQuery();
        IdentityHashMap<QuerySpec, PropertyProviderCallingInfo> remainingProperties = new IdentityHashMap<QuerySpec, PropertyProviderCallingInfo>(inputResults.size());
        LinkedList<PropertyProviderExecutionDetails> propProvidersExecDetails = new LinkedList<PropertyProviderExecutionDetails>();
        for (QuerySpec transformedQuery : transformedQueries.keySet()) {
            QuerySpec inputQuery = transformedQueries.get(transformedQuery);
            DerivedPropertyDataInternal derivedPropertyData = derivedPropertyDataPerQuery != null ? derivedPropertyDataPerQuery.get(inputQuery) : null;
            Set<String> orderingProperties = null;
            if (getOnlyOrderingProps && (orderingProperties = DataManager.getOrderingProperties(transformedQuery)).isEmpty()) continue;
            this.processPropertyProviderQueryResult(inputQuery, transformedQuery, inputResults, remainingProperties, propProvidersExecDetails, getOnlyOrderingProps, orderingProperties, isForDerivedProperties, derivedPropertyData);
            if (queriesPendingFurtherSorting == null || orderingProperties == null || orderingProperties.isEmpty()) continue;
            queriesPendingFurtherSorting.add(inputQuery);
        }
        Map<QuerySpec, ResultSetInfo> outputResults = inputResults;
        List<DataAdapterExecutionDetails> dynamicAdaptersExecDetails = null;
        if (!isForDerivedProperties) {
            DataAdaptersExecutionResult result = this.getDataFromDynamicAdaptersForRemainingProperties(inputResults, remainingProperties, daExecutionResult.getDynamicAdapterObjectsPerQuerySpec());
            outputResults = result.getResultsPerQuery();
            dynamicAdaptersExecDetails = result.getAdaptersExecutionDetails();
        }
        return new PropertyProvidersExecutionResult(outputResults, propProvidersExecDetails, dynamicAdaptersExecDetails);
    }

    private void processPropertyProviderQueryResult(QuerySpec inputQuery, QuerySpec transformedQuery, Map<QuerySpec, ResultSetInfo> inputResults, Map<QuerySpec, PropertyProviderCallingInfo> remainingProperties, List<PropertyProviderExecutionDetails> propProvidersExecDetails, boolean getOnlyOrderingProps, Set<String> remainingOrderingProps, boolean isForDerivedProperties, DerivedPropertyDataInternal derivedPropertyData) throws InterruptedException {
        ResultSetInfo inputResult = inputResults.get(inputQuery);
        PropertyProviderSpec propertyProviderSpec = this.getPropertyProviderSpec(transformedQuery, inputResult, remainingOrderingProps, isForDerivedProperties, derivedPropertyData);
        Map<PropertyProviderAdapter, PropertyProviderCallingInfo> supportedProviderInfos = propertyProviderSpec.supportedProviderInfos;
        int numPropProviders = supportedProviderInfos.size();
        if (numPropProviders > 0) {
            if (getOnlyOrderingProps) {
                Set<String> orderingProps = DataManager.getOrderingPropertiesForProviders(supportedProviderInfos);
                remainingOrderingProps.removeAll(orderingProps);
                _logger.warn("Sorting on property-provider properties: " + orderingProps);
            }
            Pair<List<ResultSetInfo>, List<PropertyProviderExecutionDetails>> propProvidersResult = this.invokePropertyProviders(transformedQuery, supportedProviderInfos);
            List ppaResults = (List)propProvidersResult.first;
            ArrayList<ResultSetInfo> resultsToBeMerged = new ArrayList<ResultSetInfo>(ppaResults.size() + 1);
            resultsToBeMerged.add(inputResult);
            resultsToBeMerged.addAll(ppaResults);
            ResultSetInfo mergedResult = this._resultsMerger.mergeResults(inputQuery, resultsToBeMerged);
            inputResults.put(inputQuery, mergedResult);
            List<PropertyProviderExecutionDetails> detailsFromProviders = (List<PropertyProviderExecutionDetails>)propProvidersResult.second;
            if (detailsFromProviders != null && detailsFromProviders.size() > 0) {
                if (isForDerivedProperties && derivedPropertyData != null) {
                    detailsFromProviders = DataManager.asDerivedPropProviderExecDetails(detailsFromProviders, derivedPropertyData.getSourcePropertyNamesByType());
                }
                propProvidersExecDetails.addAll((Collection<PropertyProviderExecutionDetails>)detailsFromProviders);
            }
        }
        remainingProperties.put(inputQuery, propertyProviderSpec.unsupportedProviderInfo);
    }

    private static List<PropertyProviderExecutionDetails> asDerivedPropProviderExecDetails(List<PropertyProviderExecutionDetails> propProvExecDetails, Map<String, List<String>> sourcePropertyNamesByType) {
        ArrayList<PropertyProviderExecutionDetails> newExecDetails = new ArrayList<PropertyProviderExecutionDetails>(propProvExecDetails.size());
        for (PropertyProviderExecutionDetails execDetails : propProvExecDetails) {
            newExecDetails.add(DerivedPropertyProviderExecutionDetails.copyOf(execDetails, sourcePropertyNamesByType));
        }
        return newExecDetails;
    }

    private static Set<String> getOrderingProperties(QuerySpec query) {
        assert (query != null);
        if (query.resultSpec == null || query.resultSpec.order == null || ArrayUtil.isNullOrEmpty((Object[])query.resultSpec.order.orderingProperties)) {
            return Collections.emptySet();
        }
        OrderingPropertySpec[] orderingPropertySpecs = query.resultSpec.order.orderingProperties;
        HashSet<String> orderingProperties = new HashSet<String>();
        for (OrderingPropertySpec orderingSpec : orderingPropertySpecs) {
            String[] orderingProps;
            if (orderingSpec == null || orderingSpec.propertyNames == null) continue;
            for (String orderingProperty : orderingProps = orderingSpec.propertyNames) {
                orderingProperties.add(orderingProperty);
            }
        }
        return orderingProperties;
    }

    private static Set<String> getOrderingPropertiesForProviders(Map<PropertyProviderAdapter, PropertyProviderCallingInfo> supportedProviderInfos) {
        if (supportedProviderInfos == null) {
            return Collections.emptySet();
        }
        HashSet<String> orderingPropsForProviders = new HashSet<String>();
        for (PropertyProviderAdapter adapter : supportedProviderInfos.keySet()) {
            PropertyProviderCallingInfo callingInfo = supportedProviderInfos.get(adapter);
            if (callingInfo == null) continue;
            Set<PropertySpec> propertySpecs = callingInfo.propertySet;
            DataManager.extractPropertyNames(propertySpecs, orderingPropsForProviders);
        }
        return orderingPropsForProviders;
    }

    private static void extractPropertyNames(Set<PropertySpec> propertySpecs, Set<String> orderingPropsForProviders) {
        if (propertySpecs == null) {
            return;
        }
        for (PropertySpec propSpec : propertySpecs) {
            String[] propNames;
            if (propSpec == null) continue;
            for (String propName : propNames = propSpec.propertyNames) {
                if (propName == null) continue;
                orderingPropsForProviders.add(propName);
            }
        }
    }

    private Pair<List<ResultSetInfo>, List<PropertyProviderExecutionDetails>> invokePropertyProviders(final QuerySpec query, Map<PropertyProviderAdapter, PropertyProviderCallingInfo> supportedProviderInfos) throws InterruptedException {
        int numPropProviders = supportedProviderInfos.size();
        assert (numPropProviders > 0) : "There should be at least one property provider";
        ArrayList<Callable<PropertyProviderExecutionResult>> tasks = new ArrayList<Callable<PropertyProviderExecutionResult>>(numPropProviders);
        ArrayList<PropertyProviderAdapter> propertyProviders = new ArrayList<PropertyProviderAdapter>(numPropProviders);
        for (final PropertyProviderAdapter propertyProvider : supportedProviderInfos.keySet()) {
            propertyProviders.add(propertyProvider);
            PropertyProviderCallingInfo propProviderCallingInfo = supportedProviderInfos.get(propertyProvider);
            final Object[] objectSet = propProviderCallingInfo.objectSet.toArray(EMPTY_OBJECTS);
            final PropertySpec[] propSpecForRemainingProps = propProviderCallingInfo.propertySet.toArray(EMPTY_PROP_SPECS);
            final DerivedPropertyData derivedPropertyData = propProviderCallingInfo.derivedPropertyData;
            Callable<PropertyProviderExecutionResult> task = new Callable<PropertyProviderExecutionResult>(){

                @Override
                public PropertyProviderExecutionResult call() {
                    ExecutionProfiler profiler = SessionUtil.getExecutionProfiler();
                    PropertyProviderExecutionResult ppResult = DataManager.getResultFromPropertyProvider(query, propertyProvider, objectSet, propSpecForRemainingProps, derivedPropertyData);
                    ppResult.result.getResultSet().queryName = query.name;
                    profiler.putExecutionTime(this.toString(), Long.valueOf(ppResult.details.getElapsedTime()));
                    return ppResult;
                }

                public String toString() {
                    return "Property provider " + propertyProvider;
                }
            };
            tasks.add(task);
        }
        List<PropertyProviderExecutionResult> ppResults = this.executeProperyProviderTasks(propertyProviders, tasks, query);
        ArrayList<PropertyProviderExecutionDetails> execDetails = new ArrayList<PropertyProviderExecutionDetails>(numPropProviders);
        ArrayList<ResultSetInfo> resultsFromProviders = new ArrayList<ResultSetInfo>(numPropProviders);
        for (PropertyProviderExecutionResult ppResult : ppResults) {
            resultsFromProviders.add(ppResult.result);
            execDetails.add(ppResult.details);
        }
        return new Pair(resultsFromProviders, execDetails);
    }

    private List<PropertyProviderExecutionResult> executeProperyProviderTasks(List<PropertyProviderAdapter> propertyProviders, List<Callable<PropertyProviderExecutionResult>> tasks, QuerySpec query) throws InterruptedException {
        assert (propertyProviders != null && tasks != null);
        assert (propertyProviders.size() == tasks.size());
        List taskResults = this._taskExecutor.executeTasks(tasks);
        ArrayList<PropertyProviderExecutionResult> executionResults = new ArrayList<PropertyProviderExecutionResult>(taskResults.size());
        for (int i = 0; i < taskResults.size(); ++i) {
            PropertyProviderExecutionResult executionResult;
            ExecutorUtil.TaskResult taskResult = taskResults.get(i);
            Exception taskException = taskResult.getException();
            if (taskException != null) {
                PropertyProviderAdapter propertyProvider = propertyProviders.get(i);
                taskException = this.processPropertyProviderTaskException(propertyProvider, taskException);
                ResultSetInfo resultSet = ResultSetInfo.createErrorResult(taskException);
                executionResult = new PropertyProviderExecutionResult(resultSet, null);
            } else {
                executionResult = (PropertyProviderExecutionResult)taskResult.getResult();
            }
            executionResults.add(executionResult);
        }
        return executionResults;
    }

    private Exception processPropertyProviderTaskException(PropertyProviderAdapter propertyProvider, Exception taskException) {
        if (!(taskException instanceof TimeoutException)) {
            return taskException;
        }
        String propertyProviderName = Utils.renderPropertyProvider(propertyProvider);
        String msg = String.format(Utils.getLocalizedString("error.propertyProviderTimeout"), propertyProviderName, this._taskExecutor.getTaskTimeoutInSecs());
        return new DataServiceException(msg, taskException);
    }

    private Map<QuerySpec, QuerySpec> createQueryForRemainingProperties(Map<QuerySpec, PropertyProviderCallingInfo> propertiesPerQuerySpec) {
        HashMap<QuerySpec, QuerySpec> result = new HashMap<QuerySpec, QuerySpec>();
        for (Map.Entry<QuerySpec, PropertyProviderCallingInfo> entry : propertiesPerQuerySpec.entrySet()) {
            QuerySpec qs = entry.getKey();
            PropertyProviderCallingInfo info = entry.getValue();
            QuerySpec queryForRemainingProperties = this.createQueryForRemainingProperties(info.objectSet, info.propertySet);
            if (queryForRemainingProperties == null) continue;
            queryForRemainingProperties.name = "remaining-property-" + qs.name;
            result.put(queryForRemainingProperties, qs);
        }
        return result;
    }

    private QuerySpec createQueryForRemainingProperties(Set<Object> objectSet, Set<PropertySpec> propSpecs) {
        if (objectSet.isEmpty()) {
            return null;
        }
        if (propSpecs.isEmpty()) {
            return null;
        }
        Set propertySpecs = CollectionUtil.filter(propSpecs, (Predicate)new Predicate<PropertySpec>(){

            public boolean evaluate(PropertySpec propSpec) {
                return !ArrayUtil.isNullOrEmpty((Object[])propSpec.propertyNames);
            }
        });
        if (propertySpecs.isEmpty()) {
            return null;
        }
        ArrayList<ObjectIdentityConstraint> nestedConstraints = new ArrayList<ObjectIdentityConstraint>();
        for (Object ref : objectSet) {
            ObjectIdentityConstraint oc = new ObjectIdentityConstraint();
            oc.target = ref;
            nestedConstraints.add(oc);
        }
        if (nestedConstraints.isEmpty()) {
            return null;
        }
        CompositeConstraint compConstraint = new CompositeConstraint();
        compConstraint.conjoiner = Conjoiner.OR;
        compConstraint.nestedConstraints = nestedConstraints.toArray(EMPTY_CONSTRAINTS);
        ResourceSpec rSpec = new ResourceSpec();
        rSpec.propertySpecs = propertySpecs.toArray(EMPTY_PROP_SPECS);
        rSpec.constraint = compConstraint;
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = rSpec;
        querySpec.resultSpec = new ResultSpec();
        querySpec.options = new HashMap<String, Object>();
        return querySpec;
    }

    private PropertyProviderSpec getPropertyProviderSpec(QuerySpec query, ResultSetInfo result, Set<String> retainProperties, boolean isForDerivedProperties, DerivedPropertyData derivedPropertyData) {
        assert (query != null && query.resourceSpec != null);
        assert (result != null && result.getResultSet() != null);
        PropertyProviderSpec propertyProviderSpec = new PropertyProviderSpec();
        ResultDirectory directory = new ResultDirectory(this._metadataRegistry, query, result);
        if (!directory.hasRemainingProperties()) {
            return propertyProviderSpec;
        }
        Map<String, Set<Object>> objectsPerType = directory.getEnumeratedObjects();
        if (objectsPerType.isEmpty()) {
            return propertyProviderSpec;
        }
        for (String type2 : objectsPerType.keySet()) {
            Set<Object> objetSet = objectsPerType.get(type2);
            if (objetSet.isEmpty()) continue;
            Set<String> remainingProperties = directory.getRemainingPropertiesFor(type2);
            if (retainProperties != null) {
                remainingProperties.retainAll(retainProperties);
            }
            if (remainingProperties.isEmpty()) continue;
            Collection<PropertyProviderInfo> propProviderInfos = null;
            propProviderInfos = !isForDerivedProperties ? this._dataAdapterRegistry.getPropertyProviders(type2, remainingProperties) : this._dataAdapterRegistry.getDerivedPropertyProviders(type2, remainingProperties);
            HashSet<String> unsupportedProperties = new HashSet<String>(remainingProperties);
            for (PropertyProviderInfo propProviderInfo : propProviderInfos) {
                PropertyProviderAdapter propProvider = propProviderInfo.propertyProvider;
                PropertyProviderCallingInfo propProviderCallingInfo = propertyProviderSpec.supportedProviderInfos.get(propProvider);
                if (propProviderCallingInfo == null) {
                    propProviderCallingInfo = new PropertyProviderCallingInfo();
                    propertyProviderSpec.supportedProviderInfos.put(propProvider, propProviderCallingInfo);
                }
                propProviderCallingInfo.objectSet.addAll(objetSet);
                Set<String> providedProperties = propProviderInfo.providedProperties;
                PropertySpec propSpecForSupportedRemainingProps = DataManager.getPropertySpec(directory, type2, propProviderInfo.providedProperties);
                propProviderCallingInfo.propertySet.add(propSpecForSupportedRemainingProps);
                propProviderCallingInfo.derivedPropertyData = derivedPropertyData;
                unsupportedProperties.removeAll(providedProperties);
            }
            if (unsupportedProperties.isEmpty()) continue;
            PropertyProviderCallingInfo unsupportedProviderInfo = propertyProviderSpec.unsupportedProviderInfo;
            unsupportedProviderInfo.objectSet.addAll(objetSet);
            PropertySpec propSpecForUnsupportedRemainingProps = DataManager.getPropertySpec(directory, type2, unsupportedProperties);
            unsupportedProviderInfo.propertySet.add(propSpecForUnsupportedRemainingProps);
            unsupportedProviderInfo.derivedPropertyData = derivedPropertyData;
        }
        return propertyProviderSpec;
    }

    private static PropertySpec getPropertySpec(ResultDirectory directory, String type2, Set<String> props) {
        ParameterSpec[] params = directory.getParametersFor(props).toArray(EMPTY_PARAMETER_SPECS);
        String[] providedProps = props.toArray(EMPTY_STRINGS);
        return Utils.newPropertySpec(type2, providedProps, params);
    }

    private DataAdaptersExecutionResult getDataFromDynamicAdaptersForRemainingProperties(Map<QuerySpec, ResultSetInfo> inputResults, Map<QuerySpec, PropertyProviderCallingInfo> remainingProperties, Map<QuerySpec, Set<Object>> dynamicAdapterObjectsPerQuerySpec) throws InterruptedException {
        if (remainingProperties.isEmpty()) {
            DataAdaptersExecutionResult results = new DataAdaptersExecutionResult(inputResults, null);
            return results;
        }
        if (inputResults.isEmpty()) {
            DataAdaptersExecutionResult results = new DataAdaptersExecutionResult(inputResults, null);
            return results;
        }
        Collection<DataAdapterInfo> dynamicAdapters = this._dataAdapterRegistry.getDynamicAdapters();
        int numAdapters = dynamicAdapters.size();
        if (numAdapters == 0) {
            DataAdaptersExecutionResult results = new DataAdaptersExecutionResult(inputResults, null);
            return results;
        }
        this.filterDynamicAdapterRetrievedObjects(remainingProperties, dynamicAdapterObjectsPerQuerySpec);
        Map<QuerySpec, QuerySpec> queriesForRemainingProperties = this.createQueryForRemainingProperties(remainingProperties);
        if (queriesForRemainingProperties.isEmpty()) {
            DataAdaptersExecutionResult results = new DataAdaptersExecutionResult(inputResults, null);
            return results;
        }
        Set<QuerySpec> allQueries = queriesForRemainingProperties.keySet();
        QuerySpec[] queryBatch = this.getQueriesAppropriateForDynamicAdapters(allQueries);
        if (queryBatch.length == 0) {
            DataAdaptersExecutionResult results = new DataAdaptersExecutionResult(inputResults, null);
            return results;
        }
        ArrayList<Callable<DataAdaptersExecutionResult>> tasks = new ArrayList<Callable<DataAdaptersExecutionResult>>(dynamicAdapters.size());
        ArrayList<DataAdapterUtil.DataAdapterQueryBatch> daQueryBatches = new ArrayList<DataAdapterUtil.DataAdapterQueryBatch>(dynamicAdapters.size());
        for (DataAdapterInfo daInfo : dynamicAdapters) {
            Callable<DataAdaptersExecutionResult> task = DataAdapterUtil.createAdapterTask(daInfo, queryBatch, "Dynamic adapter");
            tasks.add(task);
            daQueryBatches.add(new DataAdapterUtil.DataAdapterQueryBatch(daInfo, queryBatch));
        }
        List<DataAdaptersExecutionResult> results = DataAdapterUtil.executeAdapterTasks(this._taskExecutor, daQueryBatches, tasks);
        DataAdaptersExecutionResult mergedResults = this.mergeDataAdapterResults(inputResults, queriesForRemainingProperties, results);
        return mergedResults;
    }

    private void filterDynamicAdapterRetrievedObjects(Map<QuerySpec, PropertyProviderCallingInfo> remainingProperties, Map<QuerySpec, Set<Object>> dynamicAdapterObjectsPerQuerySpec) {
        if (dynamicAdapterObjectsPerQuerySpec == null) {
            return;
        }
        for (Map.Entry<QuerySpec, PropertyProviderCallingInfo> entry : remainingProperties.entrySet()) {
            QuerySpec qs = entry.getKey();
            Set<Object> dynamicAdapterObjects = dynamicAdapterObjectsPerQuerySpec.get(qs);
            PropertyProviderCallingInfo info = entry.getValue();
            if (dynamicAdapterObjects == null) continue;
            info.objectSet.removeAll(dynamicAdapterObjects);
        }
    }

    private QuerySpec[] getQueriesAppropriateForDynamicAdapters(Collection<? extends QuerySpec> queries) {
        assert (queries != null);
        if (queries.isEmpty()) {
            return EMPTY_QUERY_SPECS;
        }
        ArrayList<QuerySpec> queriesForDynamicAdapters = null;
        for (QuerySpec querySpec : queries) {
            if (!Utils.containsNonExplicitType(querySpec, this._metadataRegistry)) continue;
            if (queriesForDynamicAdapters == null) {
                queriesForDynamicAdapters = new ArrayList<QuerySpec>(queries.size());
            }
            queriesForDynamicAdapters.add(querySpec);
        }
        if (queriesForDynamicAdapters == null || queriesForDynamicAdapters.isEmpty()) {
            return EMPTY_QUERY_SPECS;
        }
        QuerySpec[] result = queriesForDynamicAdapters.toArray(new QuerySpec[queriesForDynamicAdapters.size()]);
        return result;
    }

    private DataAdaptersExecutionResult mergeDataAdapterResults(Map<QuerySpec, ResultSetInfo> inputResults, Map<QuerySpec, QuerySpec> queriesForRemainingProperties, List<DataAdaptersExecutionResult> execResults) {
        LinkedList<DataAdapterExecutionDetails> allExecDetails = new LinkedList<DataAdapterExecutionDetails>();
        for (DataAdaptersExecutionResult execResult : execResults) {
            Map<QuerySpec, ResultSetInfo> resultsForRemainingProperties = execResult.getResultsPerQuery();
            if (resultsForRemainingProperties == null) {
                _logger.info("resultsForRemainingProperties is null.");
                continue;
            }
            for (QuerySpec queryForRemainingProps : resultsForRemainingProperties.keySet()) {
                QuerySpec originalQuery = queriesForRemainingProperties.get(queryForRemainingProps);
                ArrayList<ResultSetInfo> results = new ArrayList<ResultSetInfo>();
                ResultSetInfo originalInputResult = inputResults.get(originalQuery);
                results.add(originalInputResult);
                ResultSetInfo resultForRemainingProperties = resultsForRemainingProperties.get(queryForRemainingProps);
                if (resultForRemainingProperties.getResultSet().error != null) {
                    DataManager.logInabilityToRetrieveRemainingProperties(queryForRemainingProps);
                    resultForRemainingProperties.getResultSet().error = null;
                }
                resultForRemainingProperties.getResultSet().totalMatchedObjectCount = 0;
                results.add(resultForRemainingProperties);
                ResultSetInfo mergedResult = this._resultsMerger.mergeResults(originalQuery, results);
                inputResults.put(originalQuery, mergedResult);
            }
            List<DataAdapterExecutionDetails> execDetails = execResult.getAdaptersExecutionDetails();
            if (execDetails == null || execDetails.size() <= 0) continue;
            allExecDetails.addAll(execDetails);
        }
        return new DataAdaptersExecutionResult(inputResults, allExecDetails);
    }

    private static void logInabilityToRetrieveRemainingProperties(QuerySpec query) {
        if (query == null || query.resourceSpec == null || query.resourceSpec.propertySpecs == null) {
            return;
        }
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("Cannot retrieve remaining properties: [");
        for (PropertySpec propSpec : query.resourceSpec.propertySpecs) {
            for (int i = 0; i < propSpec.propertyNames.length; ++i) {
                String propName = propSpec.propertyNames[i];
                if (i > 0) {
                    messageBuilder.append(",");
                }
                messageBuilder.append(propName);
            }
        }
        messageBuilder.append("] from dynamic-adpater");
        _logger.warn(messageBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertyProviderExecutionResult getResultFromPropertyProvider(QuerySpec querySpec, PropertyProviderAdapter propertyProvider, Object[] objectSet, PropertySpec[] propSpecForRemainingProps, DerivedPropertyData derivedPropertyData) {
        try (ViseDsLogConfigurator.ViseDsLogContext logContext = ViseDsLogConfigurator.onPropertyProviderStart(querySpec, propertyProvider);){
            long startMillis = System.currentTimeMillis();
            ResultSetInfo resultFromProvider = DataManager.getDataFromPropertyProvider(propertyProvider, objectSet, propSpecForRemainingProps, derivedPropertyData);
            long elapsedTime = System.currentTimeMillis() - startMillis;
            PropertyProviderExecutionDetails execDetails = new PropertyProviderExecutionDetails(propertyProvider, logContext.getInvocationId(), elapsedTime, querySpec, propSpecForRemainingProps);
            PropertyProviderExecutionResult propertyProviderExecutionResult = new PropertyProviderExecutionResult(resultFromProvider, execDetails);
            return propertyProviderExecutionResult;
        }
    }

    private static ResultSetInfo getDataFromPropertyProvider(PropertyProviderAdapter propertyProvider, Object[] objectSet, PropertySpec[] propSpecs, DerivedPropertyData derivedPropertyData) {
        ResultSetInfo resultFromProvider = null;
        PropertyRequestSpec propertyRequest = new PropertyRequestSpec();
        propertyRequest.objects = objectSet;
        propertyRequest.properties = propSpecs;
        propertyRequest.derivedPropertyData = derivedPropertyData;
        try {
            ResultSet outputResult = propertyProvider.getProperties(propertyRequest);
            if (outputResult != null) {
                outputResult.totalMatchedObjectCount = 0;
                resultFromProvider = ResultSetInfo.getResultSetInfo(outputResult, true);
            } else {
                resultFromProvider = ResultSetInfo.newEmptyResultSetInfo();
            }
        }
        catch (Exception ex) {
            resultFromProvider = ResultSetInfo.createErrorResult(ex);
        }
        catch (AssertionError er) {
            IllegalStateException translated = new IllegalStateException(String.format("Property provider adapter [%s] failed with internal assertion error with message `%s'.", propertyProvider, ((Throwable)((Object)er)).getMessage()), (Throwable)((Object)er));
            resultFromProvider = ResultSetInfo.createErrorResult(translated);
        }
        return resultFromProvider;
    }

    void shutdown() {
        this._taskExecutor.shutdown();
    }

    private static class PropertyProviderExecutionResult {
        final ResultSetInfo result;
        final PropertyProviderExecutionDetails details;

        PropertyProviderExecutionResult(ResultSetInfo result, PropertyProviderExecutionDetails details) {
            assert (result != null);
            this.result = result;
            this.details = details;
        }
    }

    private static class PropertyProviderSpec {
        final Map<PropertyProviderAdapter, PropertyProviderCallingInfo> supportedProviderInfos = new HashMap<PropertyProviderAdapter, PropertyProviderCallingInfo>();
        final PropertyProviderCallingInfo unsupportedProviderInfo = new PropertyProviderCallingInfo();

        private PropertyProviderSpec() {
        }
    }

    private static class PropertyProviderCallingInfo {
        final Set<Object> objectSet = new HashSet<Object>();
        final Set<PropertySpec> propertySet = new HashSet<PropertySpec>();
        DerivedPropertyData derivedPropertyData;

        private PropertyProviderCallingInfo() {
        }
    }
}

