/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceException;
import com.vmware.vise.data.query.DerivedPropertyDataInternal;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.BatchedQueryReducer;
import com.vmware.vise.data.query.impl.DataAdaptersExecutionResult;
import com.vmware.vise.data.query.impl.DataManager;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.FormattingResultTransformer;
import com.vmware.vise.data.query.impl.PropertyProvidersExecutionResult;
import com.vmware.vise.data.query.impl.QueryBatchReducer;
import com.vmware.vise.data.query.impl.RequestSpecNormalizer;
import com.vmware.vise.data.query.impl.RequestSpecValidator;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.data.query.impl.ResultsManager;
import com.vmware.vise.data.query.impl.SubTypeResolver;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.internal.profiling.ProfilingUtil;
import com.vmware.vise.data.query.internal.profiling.ViseDsLogConfigurator;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.metadata.ObjectModelProviderRegistryInternal;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.profiling.ExecutionProfiler;
import com.vmware.vise.util.profiling.ExecutionProfilerImpl;
import com.vmware.vise.util.session.SessionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataServiceImpl
implements DataService {
    private static final Logger _logger = LoggerFactory.getLogger(DataServiceImpl.class);
    private final DataManager _dataManager;
    private static final String DATA_SERVICE_PREFIX = "dataService.";
    private static final String DATA_SERVICE_TOTAL_TIME_LABEL = "dataService.totalTime";
    private static final String QUERY_BATCH_REDUCTION_TIME_LABEL = "dataService.queryBatchReduction";
    private static final String QUERY_ENRICHMENT_TIME_LABEL = "dataService.queryEnrichment";
    private static final String DATA_ADAPTER_TIME_LABEL = "dataService.dataAdapters";
    private static final String PROPERTY_PROVIDER_ADAPTER_TIME_LABEL = "dataService.propertyProviderAdapters";
    private static final String DERIVED_PROPERTY_PROVIDER_ADAPTER_TIME_LABEL = "dataService.derivedPropertyProviderAdapters";
    private static final String REMAP_ENRICHED_QUERY_TIME_LABEL = "dataService.remapEnrichedQuery";
    private static final String FORMATTING_TIME_LABEL = "dataService.formatting";
    private static final String RESULT_ORDERING_TIME_LABEL = "dataService.resultOrdering";
    private static final String DATA_SERVICE_CALL_COUNTER = "dataServiceCallCounter";
    private final FormattingResultTransformer _formattingResultTransformer;
    private final List<Class<? extends BatchedQueryReducer>> _reducerClasses;
    private final boolean _enableProfiling;
    private final Long _dataRetrievalTimeoutInMillis;

    public DataServiceImpl(DataServiceExtensionRegistryInternal adapterRegistry, MetadataServiceRegistryInternal metadataRegistry, ObjectModelProviderRegistryInternal objectModelProviderRegistry, ObjectReferenceService objectReferenceService, QuerySpecBuilder querySpecBuilder, SubTypeResolver subTypeResolver, List<String> reducerClassNames, boolean enableProfiling, long dataRetrievalTimeoutInMillis) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{adapterRegistry, metadataRegistry, objectReferenceService});
        QueryUtil.setDataServiceExtensionRegistry(adapterRegistry);
        this._formattingResultTransformer = new FormattingResultTransformer(metadataRegistry, objectReferenceService);
        this._dataRetrievalTimeoutInMillis = dataRetrievalTimeoutInMillis;
        this._dataManager = new DataManager(adapterRegistry, metadataRegistry, objectModelProviderRegistry, objectReferenceService, querySpecBuilder, subTypeResolver, this._dataRetrievalTimeoutInMillis);
        this._reducerClasses = DataServiceImpl.getReducerClasses(reducerClassNames);
        this._enableProfiling = enableProfiling;
    }

    public DataServiceImpl(DataServiceExtensionRegistryInternal adapterRegistry, MetadataServiceRegistryInternal metadataRegistry, ObjectModelProviderRegistryInternal objectModelProviderRegistry, ObjectReferenceService objectReferenceService, QuerySpecBuilder querySpecBuilder, SubTypeResolver subTypeResolver) {
        this(adapterRegistry, metadataRegistry, objectModelProviderRegistry, objectReferenceService, querySpecBuilder, subTypeResolver, DataServiceImpl.getDefaultReducerClassNames(), false, 120000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response getData(RequestSpec requestSpec) {
        RequestSpecValidator.validateRequest(requestSpec);
        Utils.generateNamesForNamelessQueries(requestSpec.querySpec);
        RequestSpecNormalizer.normalizeResultSpec(requestSpec);
        ViseDsLogConfigurator.ViseDsLogContext logContext = ViseDsLogConfigurator.onBatchStart();
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Start execution of query batch.");
            }
            Response response = this.getResponse(requestSpec, logContext);
            return response;
        }
        finally {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Finish execution of query batch.");
            }
            logContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getResponse(RequestSpec requestSpec, ViseDsLogConfigurator.ViseDsLogContext logContext) {
        Response results = new Response();
        if (requestSpec.enableProfiling != null && requestSpec.enableProfiling.booleanValue()) {
            SessionUtil.enableProfiling();
        }
        ExecutionProfiler existingProfiler = SessionUtil.getExecutionProfiler();
        boolean profilingRequested = SessionUtil.isProfilingEnabled();
        ExecutionProfiler profiler = this.getExecutionProfiler(profilingRequested);
        SessionUtil.setExecutionProfiler((ExecutionProfiler)profiler);
        Object profileKey = profiler.startTimer(DATA_SERVICE_TOTAL_TIME_LABEL);
        try {
            results.resultSet = this.getResults(requestSpec.querySpec, profiler);
        }
        finally {
            profiler.stopTimer(profileKey);
            existingProfiler.mergeProfilingResults(profiler);
            if (profiler.isEnabled()) {
                _logger.info("{}", (Object)profiler);
            }
            SessionUtil.setExecutionProfiler((ExecutionProfiler)existingProfiler);
        }
        if (results.resultSet != null) {
            if (profilingRequested) {
                results.executionTimeByDescription = profiler.getExecutionTimes();
            }
            this.logQueryInCaseOfError(requestSpec.querySpec, results.resultSet, logContext);
            return results;
        }
        Response emptySet = new Response();
        emptySet.resultSet = QueryUtil.EMPTYSET;
        if (profilingRequested) {
            emptySet.executionTimeByDescription = profiler.getExecutionTimes();
        }
        return emptySet;
    }

    private void logQueryInCaseOfError(QuerySpec[] querySpecs, ResultSet[] results, ViseDsLogConfigurator.ViseDsLogContext logContext) {
        assert (querySpecs.length == results.length);
        assert (logContext != null);
        for (int i = 0; i < results.length; ++i) {
            ResultSet result = results[i];
            if (result.error == null) continue;
            String querySpec = Utils.renderQuerySpec(querySpecs[i]);
            StringBuilder informationHeader = new StringBuilder();
            String providerInvocation = ViseDsLogConfigurator.getProviderInvocation();
            if (providerInvocation != null) {
                informationHeader.append("\nDataService is called by provider invocation: " + providerInvocation);
            }
            if (logContext.getPreviousInvocationId() != null) {
                informationHeader.append("\nParent viseBatch: " + logContext.getPreviousInvocationId());
            }
            informationHeader.append("\nThe query sent to the Data Service is:\n");
            String errorMessage = String.format("Error occurred while executing query: %s %s", informationHeader.toString(), querySpec);
            Exception error = result.error;
            _logger.error(errorMessage, (Throwable)error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ResultSet[] getResults(QuerySpec[] querySpecs, ExecutionProfiler profiler) {
        ResultSet[] resultSets;
        if (querySpecs == null || querySpecs.length == 0) {
            return QueryUtil.EMPTYSET;
        }
        ProfilingUtil.logQSpecsIfMaxResultCountIsWrong(querySpecs);
        if (_logger.isTraceEnabled()) {
            _logger.trace("QuerySpecs to execute:\n" + Utils.renderQuerySpecs(querySpecs));
        }
        Object timerKey = null;
        try {
            long startMillis = System.currentTimeMillis();
            timerKey = profiler.startTimer(QUERY_BATCH_REDUCTION_TIME_LABEL);
            List<BatchedQueryReducer> reducers = this.getReducers();
            QuerySpec[] reducedQuerySpecs = querySpecs;
            for (BatchedQueryReducer reducer : reducers) {
                reducedQuerySpecs = reducer.reduceBatch(reducedQuerySpecs);
            }
            if (_logger.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("original specs: " + querySpecs + "\n");
                sb.append("reduced specs " + reducedQuerySpecs + "\n");
                _logger.trace(sb.toString());
            }
            profiler.stopTimer(timerKey);
            timerKey = profiler.startTimer(QUERY_ENRICHMENT_TIME_LABEL);
            Map<QuerySpec, Pair<QuerySpec, DerivedPropertyDataInternal>> enrichedQuerySpecsData = this._dataManager.enrichQueriesForDerivedProperties(reducedQuerySpecs);
            Set<QuerySpec> enrichedQuerySpecs = enrichedQuerySpecsData.keySet();
            profiler.stopTimer(timerKey);
            timerKey = profiler.startTimer(DATA_ADAPTER_TIME_LABEL);
            DataAdaptersExecutionResult daExecResult = this._dataManager.getResultsFromDataAdapters(enrichedQuerySpecs.toArray(new QuerySpec[enrichedQuerySpecs.size()]), profiler);
            Map<QuerySpec, ResultSetInfo> results = daExecResult.getResultsPerQuery();
            profiler.stopTimer(timerKey);
            timerKey = profiler.startTimer(PROPERTY_PROVIDER_ADAPTER_TIME_LABEL);
            List<PropertyProvidersExecutionResult> ppaExecResults = this._dataManager.getResultsFromPropertyProviders(daExecResult, profiler);
            profiler.stopTimer(timerKey);
            timerKey = profiler.startTimer(REMAP_ENRICHED_QUERY_TIME_LABEL);
            daExecResult = this._dataManager.remapAndCollectResultsForEnrichedQueries(daExecResult, enrichedQuerySpecsData);
            results = daExecResult.getResultsPerQuery();
            profiler.stopTimer(timerKey);
            timerKey = profiler.startTimer(DERIVED_PROPERTY_PROVIDER_ADAPTER_TIME_LABEL);
            List<PropertyProvidersExecutionResult> dppaExecResults = this._dataManager.getResultsFromDerivedPropertyProviders(daExecResult, profiler, enrichedQuerySpecsData);
            ppaExecResults.addAll(dppaExecResults);
            profiler.stopTimer(timerKey);
            timerKey = profiler.startTimer(FORMATTING_TIME_LABEL);
            this._formattingResultTransformer.transform(results);
            profiler.stopTimer(timerKey);
            timerKey = profiler.startTimer(RESULT_ORDERING_TIME_LABEL);
            for (int i = reducers.size() - 1; i >= 0; --i) {
                BatchedQueryReducer reducer = reducers.get(i);
                results = reducer.getResultsByOriginalQuery(results);
            }
            resultSets = ResultsManager.orderResultsPerQueryOrder(querySpecs, results);
            profiler.stopTimer(timerKey);
            timerKey = null;
            long elapsedTime = System.currentTimeMillis() - startMillis;
            ProfilingUtil.logSlowExecutions(querySpecs, elapsedTime, daExecResult, ppaExecResults);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String msg = Utils.getLocalizedString("error.dataServiceInterrupted");
            resultSets = this.constructErrorResultFor(querySpecs, new DataServiceException(msg, e));
            profiler.stopTimer(timerKey);
        }
        catch (Exception e2) {
            _logger.error("The data service execution failed", (Throwable)e2);
            String msg = Utils.getLocalizedString("error.dataServiceFailure");
            resultSets = this.constructErrorResultFor(querySpecs, new DataServiceException(msg, e2));
            {
                catch (Throwable throwable) {
                    profiler.stopTimer(timerKey);
                    throw throwable;
                }
            }
            profiler.stopTimer(timerKey);
        }
        profiler.stopTimer(timerKey);
        if (_logger.isTraceEnabled()) {
            _logger.trace("ResultSets returned:\n" + Utils.renderResultSets(resultSets));
        }
        return resultSets;
    }

    private static List<String> getDefaultReducerClassNames() {
        ArrayList<String> reducers = new ArrayList<String>(2);
        reducers.add(QueryBatchReducer.class.getName());
        return reducers;
    }

    private static List<Class<? extends BatchedQueryReducer>> getReducerClasses(List<String> reducerClassNames) {
        ArrayList<Class<? extends BatchedQueryReducer>> reducers = new ArrayList<Class<? extends BatchedQueryReducer>>(reducerClassNames.size());
        for (String reducerClassName : reducerClassNames) {
            try {
                Class<?> reducerClass = Class.forName(reducerClassName);
                reducers.add(reducerClass);
            }
            catch (Exception e) {
                _logger.error("Error loading BatchedQueryReducer with class name: " + reducerClassName);
            }
        }
        return reducers;
    }

    private List<BatchedQueryReducer> getReducers() {
        ArrayList<BatchedQueryReducer> reducers = new ArrayList<BatchedQueryReducer>(this._reducerClasses.size());
        for (Class<? extends BatchedQueryReducer> reducerClass : this._reducerClasses) {
            try {
                BatchedQueryReducer reducer = reducerClass.newInstance();
                reducers.add(reducer);
            }
            catch (Exception e) {
                _logger.error("Error loading QueryBatchReducer with class name: " + reducerClass.getName() + ". Class must exist and specify a zero-argument public constructor.");
            }
        }
        return reducers;
    }

    private ResultSet[] constructErrorResultFor(QuerySpec[] querySpecs, Exception e) {
        assert (e != null) : "The exception should not be null";
        int numQueries = querySpecs.length;
        ResultSet[] resultSets = new ResultSet[numQueries];
        for (int i = 0; i < numQueries; ++i) {
            QuerySpec query = querySpecs[i];
            ResultSet resultSet = new ResultSet();
            resultSet.error = e;
            resultSet.queryName = query.name;
            resultSets[i] = resultSet;
        }
        return resultSets;
    }

    private ExecutionProfiler getExecutionProfiler(boolean profilingRequested) {
        if (this._enableProfiling || profilingRequested) {
            int dsCallId = DataServiceImpl.getDataServiceCallId();
            return new ExecutionProfilerImpl("dsCall" + dsCallId);
        }
        return ExecutionProfilerImpl.PASS_THROUGH_PROFILER;
    }

    void shutdown() {
        if (this._dataManager != null) {
            this._dataManager.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDataServiceCallId() {
        HttpServletRequest request = SessionUtil.getHttpRequest();
        if (request == null) {
            return 0;
        }
        AtomicInteger counter = (AtomicInteger)request.getAttribute(DATA_SERVICE_CALL_COUNTER);
        if (counter != null) {
            int id = counter.incrementAndGet();
            return id;
        }
        counter = new AtomicInteger(0);
        HttpServletRequest id = request;
        synchronized (id) {
            AtomicInteger existingCounter = (AtomicInteger)request.getAttribute(DATA_SERVICE_CALL_COUNTER);
            if (existingCounter == null) {
                request.setAttribute(DATA_SERVICE_CALL_COUNTER, (Object)counter);
            } else {
                counter = existingCounter;
            }
        }
        int id2 = counter.incrementAndGet();
        return id2;
    }
}

