/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.FacetSpec;
import com.vmware.vise.data.query.FacetValue;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.DataFormatUtil;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.metadata.RelationshipDescriptor;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FormattingResultTransformer {
    private static final Log _logger = LogFactory.getLog(FormattingResultTransformer.class);
    private final MetadataServiceRegistryInternal _metadataRegistry;
    private final ObjectReferenceService _objectReferenceService;

    public FormattingResultTransformer(MetadataServiceRegistryInternal metadataRegistry, ObjectReferenceService objectReferenceService) {
        assert (metadataRegistry != null);
        assert (objectReferenceService != null);
        this._metadataRegistry = metadataRegistry;
        this._objectReferenceService = objectReferenceService;
    }

    public void transform(Map<QuerySpec, ResultSetInfo> results) {
        assert (results != null);
        for (QuerySpec qSpec : results.keySet()) {
            ResultSetInfo resultSetInfo = results.get(qSpec);
            ResultSet result = resultSetInfo.getResultSet();
            this.transformResultItems(qSpec.resourceSpec.propertySpecs, result.items);
            if (qSpec.resultSpec == null) continue;
            this.transformFacets(qSpec.resultSpec.facets, result.facets);
        }
    }

    private void transformFacets(FacetSpec[] facetSpecs, FacetInfo[] facetInfos) {
        if (facetInfos == null || facetInfos.length == 0 || facetSpecs == null || facetSpecs.length == 0) {
            return;
        }
        for (FacetSpec facetSpec : facetSpecs) {
            assert (facetSpec.propSpec != null);
            assert (facetSpec.propSpec.propertyNames.length > 0);
            for (String propName : facetSpec.propSpec.propertyNames) {
                if (!FormattingResultTransformer.needsFormattingTransform(propName)) continue;
                propName = propName.substring(0, propName.length() - ".@formatted".length());
                this.transformFacetInfo(facetInfos, facetSpec.propSpec, propName);
            }
        }
    }

    private void transformFacetInfo(FacetInfo[] facetInfos, PropertySpec propertySpec, String propName) {
        String type2 = propertySpec.type;
        String relation = propertySpec.relation;
        if (relation != null && !relation.isEmpty()) {
            for (FacetInfo facetInfo : facetInfos) {
                PropertySpec ps = facetInfo.propSpec;
                if (!ObjectUtil.objectsEqual((Object)type2, (Object)ps.type) || !ObjectUtil.objectsEqual((Object)propName, (Object)ps.propertyNames[0]) || !ObjectUtil.objectsEqual((Object)relation, (Object)ps.relation)) continue;
                this.transformFacetInfo(facetInfo);
                break;
            }
        } else {
            for (FacetInfo facetInfo : facetInfos) {
                PropertySpec ps = facetInfo.propSpec;
                if (!ObjectUtil.objectsEqual((Object)type2, (Object)ps.type) || !ObjectUtil.objectsEqual((Object)propName, (Object)ps.propertyNames[0]) || ps.relation != null && !ps.relation.isEmpty()) continue;
                this.transformFacetInfo(facetInfo);
                break;
            }
        }
    }

    private void transformFacetInfo(FacetInfo facet) {
        FacetValue[] facetValues;
        PropertySpec propSpec = facet.propSpec;
        String propName = facet.propSpec.propertyNames[0];
        PropertyDescriptor propDescriptor = this.getPropertyDescriptor(propSpec, propName);
        if (propDescriptor == null) {
            String fullPropName = propSpec.relation == null ? propName : propSpec.relation + "." + propName;
            _logger.error((Object)("Formatting of FacetInfo for property: " + fullPropName + " failed because PropertyDescriptor was not found."));
        }
        facet.propSpec.propertyNames[0] = this.addFormattingSuffix(propName);
        for (FacetValue facetValue : facetValues = facet.facetValues) {
            facetValue.value = this.transformValue(propDescriptor, facetValue.value);
        }
    }

    private void transformResultItems(PropertySpec[] propertySpecs, ResultItem[] items) {
        if (items == null || items.length == 0 || propertySpecs == null || propertySpecs.length == 0) {
            return;
        }
        List<PropertyDescriptor[]> propDescriptorsForItems = null;
        for (PropertySpec propSpec : propertySpecs) {
            for (String propName : propSpec.propertyNames) {
                if (!FormattingResultTransformer.needsFormattingTransform(propName)) continue;
                if (StringUtil.isNullOrEmpty((String)propSpec.type) && propDescriptorsForItems == null) {
                    propDescriptorsForItems = this.getPropertyDescriptorsForItems(items);
                    assert (items.length == propDescriptorsForItems.size());
                }
                this.transformResultItems(propSpec, propName.substring(0, propName.length() - ".@formatted".length()), items, propDescriptorsForItems);
            }
        }
    }

    private void transformResultItems(PropertySpec propSpec, String propName, ResultItem[] items, List<PropertyDescriptor[]> propDescriptorsForItems) {
        String fullPropName;
        PropertyDescriptor propDescriptor = null;
        String string = fullPropName = propSpec.relation == null ? propName : propSpec.relation + "." + propName;
        if (!StringUtil.isNullOrEmpty((String)propSpec.type) && (propDescriptor = this.getPropertyDescriptor(propSpec, propName)) == null) {
            _logger.error((Object)("Formatting of ResultItems for property [" + fullPropName + "] failed because PropertyDescriptor was not found."));
            return;
        }
        Iterator<PropertyDescriptor[]> propDescriptorsForItemsIterator = propDescriptorsForItems != null ? propDescriptorsForItems.iterator() : null;
        for (ResultItem item : items) {
            PropertyDescriptor itemPropDescriptor = propDescriptor;
            PropertyValue[] propValues = item.properties;
            PropertyDescriptor[] propDescriptorsForItem = propDescriptorsForItemsIterator != null ? propDescriptorsForItemsIterator.next() : null;
            for (PropertyValue propValue : propValues) {
                if (!propValue.propertyName.equals(propName)) continue;
                if (propDescriptor == null) {
                    itemPropDescriptor = this.getPropertyDescriptorForItem(propDescriptorsForItem, propSpec.relation, propName, propValue);
                }
                if (itemPropDescriptor == null) {
                    _logger.error((Object)("Formatting of a ResultItem for object [" + item.resourceObject + "] and property [" + fullPropName + "] failed because PropertyDescriptor was not found."));
                    continue;
                }
                propValue.value = this.transformValue(itemPropDescriptor, propValue.value);
                propValue.propertyName = this.addFormattingSuffix(propName);
            }
        }
    }

    private Object transformValue(PropertyDescriptor propDescriptor, Object origValue) {
        if (origValue == null) {
            return origValue;
        }
        Object transformedValue = origValue;
        if (propDescriptor.unit != null) {
            transformedValue = DataFormatUtil.formatValueWithUnit(origValue, propDescriptor.unit, propDescriptor.displayForm);
        } else if (propDescriptor.staticValueSpace != null) {
            transformedValue = DataFormatUtil.formatValueWithStaticValueSpace(origValue, propDescriptor.staticValueSpace);
        }
        return transformedValue;
    }

    private PropertyDescriptor getPropertyDescriptor(PropertySpec propSpec, String propName) {
        PropertyDescriptor[] propDescriptors;
        assert (propSpec != null);
        String providerType = propSpec.type;
        if (!StringUtil.isNullOrEmpty((String)propSpec.relation)) {
            providerType = this.getProviderTypeFromRelationHops(providerType, propSpec.relation);
        }
        for (PropertyDescriptor propDescriptor : propDescriptors = this._metadataRegistry.lookUpPropertyDescriptors(providerType)) {
            if (!propDescriptor.name.equals(propName) && !ArrayUtil.contains((Object)propName, (Object[])propDescriptor.aliases).booleanValue()) continue;
            return propDescriptor;
        }
        return null;
    }

    private PropertyDescriptor getPropertyDescriptorForItem(PropertyDescriptor[] descriptorsForItem, String relation, String propName, PropertyValue propValue) {
        if (descriptorsForItem == null) {
            return null;
        }
        PropertyDescriptor[] propertyDescriptors = descriptorsForItem;
        if (!StringUtil.isNullOrEmpty((String)relation)) {
            if (propValue.resourceObject == null) {
                return null;
            }
            String relatedResourceType = this._objectReferenceService.getResourceObjectType(propValue.resourceObject);
            propertyDescriptors = this._metadataRegistry.lookUpPropertyDescriptors(relatedResourceType);
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!propertyDescriptor.name.equals(propName) && !ArrayUtil.contains((Object)propName, (Object[])propertyDescriptor.aliases).booleanValue()) continue;
            return propertyDescriptor;
        }
        return null;
    }

    private List<PropertyDescriptor[]> getPropertyDescriptorsForItems(ResultItem[] items) {
        assert (items != null);
        ArrayList<PropertyDescriptor[]> descriptorsForItems = new ArrayList<PropertyDescriptor[]>();
        HashMap<String, PropertyDescriptor[]> descriptorsByType = new HashMap<String, PropertyDescriptor[]>();
        for (ResultItem item : items) {
            String resourceType = this._objectReferenceService.getResourceObjectType(item.resourceObject);
            PropertyDescriptor[] propDescriptors = (PropertyDescriptor[])descriptorsByType.get(resourceType);
            if (propDescriptors == null) {
                propDescriptors = this._metadataRegistry.lookUpPropertyDescriptors(resourceType);
                descriptorsByType.put(resourceType, propDescriptors);
            }
            descriptorsForItems.add(propDescriptors);
        }
        return descriptorsForItems;
    }

    private String getProviderTypeFromRelationHops(String sourceType, String relationStr) {
        String[] relationHops;
        for (String relation : relationHops = relationStr.split(";")) {
            sourceType = this.getRelationTargetType(sourceType, relation);
        }
        return sourceType;
    }

    private String getRelationTargetType(String sourceType, String relation) {
        RelationshipDescriptor[] relDescriptors;
        for (RelationshipDescriptor relDescriptor : relDescriptors = this._metadataRegistry.lookUpRelationshipDescriptors(sourceType, null)) {
            if (!relDescriptor.name.equals(relation)) continue;
            return relDescriptor.targetType;
        }
        return null;
    }

    private static boolean needsFormattingTransform(String propName) {
        assert (propName != null);
        return propName.endsWith(".@formatted");
    }

    private String addFormattingSuffix(String propName) {
        return propName + ".@formatted";
    }
}

