/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.ResourceObjectReferenceAdapter;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.ObjectIdUtil;
import com.vmware.vise.util.ValidationUtil;

public final class ObjectReferenceServiceImpl
implements ObjectReferenceService {
    private final DataServiceExtensionRegistryInternal _dsExtRegistry;

    public ObjectReferenceServiceImpl(DataServiceExtensionRegistryInternal registry) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{registry});
        this._dsExtRegistry = registry;
    }

    @Override
    public String getResourceObjectType(Object reference) {
        ResourceObjectReferenceAdapter adapter = this.getRefTypeAdapter(reference);
        if (adapter == null) {
            return null;
        }
        String type2 = adapter.getResourceType(reference);
        return type2;
    }

    @Override
    public String getServerGuid(Object reference) {
        ResourceObjectReferenceAdapter adapter = this.getRefTypeAdapter(reference);
        if (adapter == null) {
            return null;
        }
        String serverGuid = adapter.getServerGuid(reference);
        return serverGuid;
    }

    @Override
    public String getUid(Object reference) {
        ResourceObjectReferenceAdapter adapter = this.getRefTypeAdapter(reference);
        if (adapter == null) {
            return null;
        }
        String uid = adapter.getUid(reference);
        return uid;
    }

    @Override
    public Object getReference(String uid) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{uid});
        ResourceObjectReferenceAdapter adapter = this._dsExtRegistry.getObjectRefTypeAdapter(uid);
        if (adapter == null) {
            return null;
        }
        Object entityRef = adapter.getReference(uid);
        return entityRef;
    }

    @Override
    public String getUid(Object reference, boolean encode) {
        String uid = this.getUid(reference);
        if (encode) {
            uid = ObjectIdUtil.encodeObjectId(uid);
        }
        return uid;
    }

    @Override
    public Object getReference(String uid, boolean decode) {
        if (decode) {
            uid = ObjectIdUtil.decodeObjectId(uid);
        }
        return this.getReference(uid);
    }

    private ResourceObjectReferenceAdapter getRefTypeAdapter(Object reference) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{reference});
        ResourceObjectReferenceAdapter adapter = this._dsExtRegistry.getObjectRefTypeAdapter(reference.getClass());
        return adapter;
    }
}

