/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.BatchedQueryReducer;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class QueryBatchReducer
implements BatchedQueryReducer {
    private static final Log _logger = LogFactory.getLog(QueryBatchReducer.class);
    private Map<QuerySpec, List<QuerySpec>> _skippedQueriesByRepresentativeQuery;

    @Override
    public QuerySpec[] reduceBatch(QuerySpec[] queryBatch) {
        if (queryBatch == null || queryBatch.length <= 1) {
            return queryBatch;
        }
        this._skippedQueriesByRepresentativeQuery = null;
        ArrayList<QuerySpec> reducedQueryBatch = new ArrayList<QuerySpec>(queryBatch.length);
        for (QuerySpec querySpec : queryBatch) {
            boolean skipQuery = false;
            for (QuerySpec representativeQuery : reducedQueryBatch) {
                List<QuerySpec> skippedQueries;
                if (!QueryUtil.areEquivalent(representativeQuery, querySpec)) continue;
                _logger.debug((Object)("Skipping QuerySpec: " + querySpec.name));
                if (this._skippedQueriesByRepresentativeQuery == null) {
                    this._skippedQueriesByRepresentativeQuery = new HashMap<QuerySpec, List<QuerySpec>>();
                }
                if ((skippedQueries = this._skippedQueriesByRepresentativeQuery.get(representativeQuery)) == null) {
                    skippedQueries = new ArrayList<QuerySpec>();
                    this._skippedQueriesByRepresentativeQuery.put(representativeQuery, skippedQueries);
                }
                skippedQueries.add(querySpec);
                skipQuery = true;
                break;
            }
            if (skipQuery) continue;
            reducedQueryBatch.add(querySpec);
        }
        if (_logger.isInfoEnabled() && reducedQueryBatch.size() < queryBatch.length) {
            _logger.info((Object)("Reduced query batch from " + queryBatch.length + " to " + reducedQueryBatch.size()));
        }
        return reducedQueryBatch.toArray(new QuerySpec[reducedQueryBatch.size()]);
    }

    @Override
    public Map<QuerySpec, ResultSetInfo> getResultsByOriginalQuery(Map<QuerySpec, ResultSetInfo> resultsByRepresentativeQuery) {
        if (this._skippedQueriesByRepresentativeQuery == null) {
            return resultsByRepresentativeQuery;
        }
        HashMap<QuerySpec, ResultSetInfo> resultByOriginalQuery = new HashMap<QuerySpec, ResultSetInfo>();
        for (Map.Entry<QuerySpec, ResultSetInfo> queryResultEntry : resultsByRepresentativeQuery.entrySet()) {
            QuerySpec representativeQuery = queryResultEntry.getKey();
            ResultSetInfo result = queryResultEntry.getValue();
            resultByOriginalQuery.put(representativeQuery, result);
            List<QuerySpec> skippedQueries = this._skippedQueriesByRepresentativeQuery.get(representativeQuery);
            if (skippedQueries == null) continue;
            for (QuerySpec skippedQuery : skippedQueries) {
                ResultSetInfo originalResult = QueryBatchReducer.toOriginalResult(skippedQuery, result);
                resultByOriginalQuery.put(skippedQuery, originalResult);
            }
        }
        return resultByOriginalQuery;
    }

    private static ResultSetInfo toOriginalResult(QuerySpec querySpec, ResultSetInfo result) {
        ResultSet resultSet = new ResultSet(result.getResultSet());
        resultSet.queryName = querySpec.name;
        ResultSetInfo originalResult = ResultSetInfo.getResultSetInfo(result, resultSet);
        return originalResult;
    }
}

