/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.ResultItemComparator;
import com.vmware.vise.data.query.util.ResultUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class ResultsManager {
    private static Log _logger = LogFactory.getLog(ResultsManager.class);

    private ResultsManager() {
    }

    static Map<QuerySpec, ResultSetInfo> applyResultSpecsToResults(Map<QuerySpec, ResultSetInfo> results, Set<QuerySpec> queriesPendingFurtherSorting) {
        ResultsManager.sortResults(results, queriesPendingFurtherSorting);
        ResultsManager.pageResults(results, queriesPendingFurtherSorting);
        return results;
    }

    static ResultSet[] orderResultsPerQueryOrder(QuerySpec[] querySpecs, Map<QuerySpec, ResultSetInfo> results) {
        if (querySpecs == null || querySpecs.length == 0 || results == null || results.size() == 0) {
            ResultSet rs = new ResultSet();
            rs.error = new Exception(Utils.getLocalizedString("error.invalidResult"));
            return new ResultSet[]{rs};
        }
        ArrayList<ResultSet> orderedResultSet = new ArrayList<ResultSet>();
        for (QuerySpec query : querySpecs) {
            ResultSetInfo result = results.get(query);
            ResultSet resultSet = null;
            if (result == null) {
                _logger.warn((Object)("No matching result set found for query - " + query.name));
                resultSet = new ResultSet();
                resultSet.queryName = query.name;
                resultSet.items = new ResultItem[0];
                resultSet.totalMatchedObjectCount = 0;
            } else {
                resultSet = result.getResultSet();
            }
            orderedResultSet.add(resultSet);
        }
        return orderedResultSet.toArray(new ResultSet[orderedResultSet.size()]);
    }

    private static void sortResults(Map<QuerySpec, ResultSetInfo> results, Set<QuerySpec> queriesPendingFurtherSorting) {
        assert (results != null);
        for (QuerySpec qSpec : results.keySet()) {
            ResultSetInfo result = results.get(qSpec);
            if (result.isSorted()) {
                return;
            }
            ResultSetInfo sortedResult = ResultsManager.getSortedResult(qSpec, result, queriesPendingFurtherSorting.contains(qSpec));
            results.put(qSpec, sortedResult);
        }
    }

    private static ResultSetInfo getSortedResult(QuerySpec qSpec, ResultSetInfo result, boolean isPartialSort) {
        assert (qSpec != null);
        ResultSpec resultSpec = qSpec.resultSpec;
        if (resultSpec == null) {
            return result;
        }
        OrderingCriteria orderingCriteria = resultSpec.order;
        if (orderingCriteria == null) {
            orderingCriteria = Utils.getDefaultOrderingCriteria();
        }
        ResultSetInfo sortedResult = ResultsManager.sortBySpec(result, orderingCriteria, isPartialSort);
        return sortedResult;
    }

    private static ResultSetInfo sortBySpec(ResultSetInfo result, OrderingCriteria order, boolean isPartialSort) {
        assert (result != null);
        assert (order != null);
        Arrays.sort(result.getResultSet().items, new ResultItemComparator(order));
        ResultSetInfo sortedResult = ResultSetInfo.getResultSetInfo(result.getResultSet(), !isPartialSort, isPartialSort ? false : result.isPaged());
        return sortedResult;
    }

    private static void pageResults(Map<QuerySpec, ResultSetInfo> results, Set<QuerySpec> queriesPendingFurtherSorting) {
        for (QuerySpec qSpec : results.keySet()) {
            boolean resultPaged;
            if (queriesPendingFurtherSorting.contains(qSpec)) continue;
            ResultSpec resultSpec = qSpec.resultSpec;
            ResultSetInfo result = results.get(qSpec);
            if (!result.isSorted() && ResultsManager.isOffsetSpecified(resultSpec)) {
                _logger.warn((Object)"Result could not be paged because it is unsorted and the resultSpec specifies an offset greater than zero.");
                continue;
            }
            if (result.isPaged() || !(resultPaged = ResultUtil.pageResult(result.getResultSet(), resultSpec))) continue;
            ResultSetInfo pagedResult = ResultSetInfo.getResultSetInfo(result.getResultSet(), result.isSorted(), true);
            results.put(qSpec, pagedResult);
        }
    }

    private static boolean isOffsetSpecified(ResultSpec resultSpec) {
        return resultSpec != null && resultSpec.offset != null && resultSpec.offset > 0;
    }
}

