/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.core.model.IdentifiableGenerationNumber;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.FacetValue;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.FacetItemComparator;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResultsMerger {
    private static final Logger _logger = LoggerFactory.getLogger(ResultsMerger.class);
    private final MetadataServiceRegistryInternal _metadataServiceRegistry;
    private final ObjectReferenceService _objectReferenceService;
    private final Comparator<PropertyValue> _propertyValueComparator;

    public ResultsMerger(MetadataServiceRegistryInternal metadataServiceRegistry, ObjectReferenceService objectReferenceService) {
        this._metadataServiceRegistry = metadataServiceRegistry;
        this._objectReferenceService = objectReferenceService;
        this._propertyValueComparator = new PropertyValueComparator(objectReferenceService);
    }

    Map<QuerySpec, ResultSetInfo> mergeResultsPerQuery(Map<QuerySpec, List<ResultSetInfo>> results) {
        if (results == null) {
            return null;
        }
        IdentityHashMap<QuerySpec, ResultSetInfo> aggregatedResults = new IdentityHashMap<QuerySpec, ResultSetInfo>();
        for (QuerySpec query : results.keySet()) {
            List<ResultSetInfo> queryResults = results.get(query);
            ResultSetInfo result = this.mergeResults(query, queryResults);
            aggregatedResults.put(query, result);
        }
        return aggregatedResults;
    }

    ResultSetInfo mergeResults(QuerySpec querySpec, List<ResultSetInfo> results) {
        if (results == null || results.size() == 0) {
            return ResultSetInfo.newEmptyResultSetInfo();
        }
        LinkedHashMap<String, ArrayList<ResultItem>> objResultMap = new LinkedHashMap<String, ArrayList<ResultItem>>();
        int totalMatchedObjectCount = 0;
        ArrayList<Exception> faults = new ArrayList<Exception>();
        HashSet<ResultSetInfo> objectSources = new HashSet<ResultSetInfo>();
        LinkedHashMap<PropertySpec, Set<FacetValue>> facetsByPropSpec = new LinkedHashMap<PropertySpec, Set<FacetValue>>();
        for (ResultSetInfo resultInfo : results) {
            if (resultInfo == null) continue;
            ResultSet result = resultInfo.getResultSet();
            if (result.error != null) {
                this.addException(result.error, faults);
            }
            this.addToFacetsByPropSpec(facetsByPropSpec, result.facets);
            if (result.totalMatchedObjectCount == null) {
                result.totalMatchedObjectCount = result.items != null ? result.items.length : 0;
            }
            totalMatchedObjectCount += result.totalMatchedObjectCount.intValue();
            if (result.items == null) continue;
            for (ResultItem ri : result.items) {
                String moKey = this._objectReferenceService.getUid(ri.resourceObject);
                ArrayList<ResultItem> resultItems = (ArrayList<ResultItem>)objResultMap.get(moKey);
                if (resultItems == null) {
                    resultItems = new ArrayList<ResultItem>();
                    objResultMap.put(moKey, resultItems);
                    objectSources.add(resultInfo);
                }
                resultItems.add(ri);
            }
        }
        ResultSet resultSet = new ResultSet();
        resultSet.totalMatchedObjectCount = totalMatchedObjectCount;
        resultSet.queryName = querySpec.name;
        List<FacetInfo> aggregatedFacets = this.getAggregatedFacets(facetsByPropSpec);
        for (FacetInfo facet : aggregatedFacets) {
            Arrays.sort(facet.facetValues, new FacetItemComparator());
        }
        resultSet.facets = aggregatedFacets.toArray(new FacetInfo[0]);
        if (faults.size() > 0) {
            resultSet.error = faults.size() > 1 ? new CompositeException(faults) : (Exception)faults.get(0);
        }
        Set<String> primaryPropertyOrder = this.getPrimaryPropertyOrder(querySpec.resourceSpec.propertySpecs);
        ArrayList<ResultItem> aggregatedResults = new ArrayList<ResultItem>();
        for (String key : objResultMap.keySet()) {
            List individualResults = (List)objResultMap.get(key);
            if (individualResults == null || individualResults.size() == 0) continue;
            ResultItem result = (ResultItem)individualResults.get(0);
            Object ref = result.resourceObject;
            ResultItem ri = new ResultItem();
            ri.resourceObject = ref;
            ri.currentGenerations = this.getLowestGeneration(individualResults);
            ri.properties = this.mergeProperties(individualResults, primaryPropertyOrder);
            aggregatedResults.add(ri);
        }
        resultSet.items = aggregatedResults.toArray(new ResultItem[0]);
        boolean resultSorted = this.isSorted(objectSources);
        boolean resultPaged = this.isPaged(objectSources);
        ResultSetInfo resultSetInfo = ResultSetInfo.getResultSetInfo(resultSet, resultSorted, resultPaged);
        return resultSetInfo;
    }

    private Set<String> getPrimaryPropertyOrder(PropertySpec[] propertySpecs) {
        LinkedHashSet<String> propertyOrder = new LinkedHashSet<String>();
        for (PropertySpec ps : propertySpecs) {
            if (!StringUtil.isNullOrEmpty((String)ps.relation)) continue;
            for (String property : ps.propertyNames) {
                property = Utils.stripIfEndsWith(property, ".@formatted");
                propertyOrder.add(property);
            }
        }
        return propertyOrder;
    }

    private List<FacetInfo> getAggregatedFacets(Map<PropertySpec, Set<FacetValue>> facetsByPropSpec) {
        ArrayList<FacetInfo> facets = new ArrayList<FacetInfo>();
        for (Map.Entry<PropertySpec, Set<FacetValue>> entry : facetsByPropSpec.entrySet()) {
            FacetInfo facet = new FacetInfo();
            facet.propSpec = entry.getKey();
            facet.facetValues = entry.getValue().toArray(new FacetValue[0]);
            facets.add(facet);
        }
        return facets;
    }

    private void addToFacetsByPropSpec(Map<PropertySpec, Set<FacetValue>> facetsByPropSpec, FacetInfo[] facets) {
        if (facets == null) {
            return;
        }
        for (FacetInfo facet : facets) {
            if (facetsByPropSpec.containsKey(facet.propSpec)) {
                facetsByPropSpec.get(facet.propSpec).addAll(Arrays.asList(facet.facetValues));
                continue;
            }
            facetsByPropSpec.put(facet.propSpec, new HashSet<FacetValue>(Arrays.asList(facet.facetValues)));
        }
    }

    private boolean isSorted(Collection<ResultSetInfo> objectSources) {
        assert (objectSources != null);
        if (objectSources.isEmpty()) {
            return true;
        }
        if (objectSources.size() > 1) {
            return false;
        }
        ResultSetInfo resultSetInfo = objectSources.iterator().next();
        boolean isSorted = resultSetInfo.isSorted();
        return isSorted;
    }

    private boolean isPaged(Collection<ResultSetInfo> objectSources) {
        assert (objectSources != null);
        if (objectSources.isEmpty()) {
            return true;
        }
        if (objectSources.size() > 1) {
            return false;
        }
        ResultSetInfo resultSetInfo = objectSources.iterator().next();
        boolean isPaged = resultSetInfo.isPaged();
        return isPaged;
    }

    private void addException(Exception mf, List<Exception> faults) {
        if (mf instanceof CompositeException) {
            for (Exception f : ((CompositeException)mf).getExceptions()) {
                this.addException(f, faults);
            }
            return;
        }
        faults.add(mf);
    }

    private PropertyValue[] mergeProperties(List<ResultItem> resultItems, Set<String> primaryPropertyOrder) {
        if (resultItems == null || resultItems.isEmpty()) {
            return null;
        }
        Object resourceProvider = null;
        HashMap<String, PropertyValue> primaryProviderProperties = new HashMap<String, PropertyValue>();
        ArrayList<PropertyValue> relatedProviderProperties = null;
        for (ResultItem ri : resultItems) {
            if (resourceProvider == null) {
                resourceProvider = ri.resourceObject;
            }
            assert (this._objectReferenceService.getUid(resourceProvider) == null || this._objectReferenceService.getUid(resourceProvider).equals(this._objectReferenceService.getUid(ri.resourceObject)));
            if (ri.properties == null) continue;
            for (PropertyValue propertyValue : ri.properties) {
                if (propertyValue == null) continue;
                Object valueProvider = propertyValue.resourceObject;
                String propertyName = propertyValue.propertyName;
                if (valueProvider == null || valueProvider.equals(resourceProvider)) {
                    PropertyValue foundPropertyValue = (PropertyValue)primaryProviderProperties.get(propertyName);
                    if (foundPropertyValue == null) {
                        primaryProviderProperties.put(propertyName, propertyValue);
                        continue;
                    }
                    if (!_logger.isDebugEnabled() || foundPropertyValue.equals(propertyValue)) continue;
                    _logger.debug("Property '{}' for resource '{}' was already provided with value '{}' and the new value '{}' will be ignored.", new Object[]{propertyName, resourceProvider, foundPropertyValue, propertyValue});
                    continue;
                }
                if (relatedProviderProperties == null) {
                    relatedProviderProperties = new ArrayList<PropertyValue>();
                    relatedProviderProperties.add(propertyValue);
                    continue;
                }
                int index = Collections.binarySearch(relatedProviderProperties, propertyValue, this._propertyValueComparator);
                if (index >= 0) continue;
                int insertionPoint = -(index + 1);
                if (insertionPoint >= relatedProviderProperties.size()) {
                    relatedProviderProperties.add(propertyValue);
                    continue;
                }
                relatedProviderProperties.add(insertionPoint, propertyValue);
            }
        }
        return this.getOrderedProperties(primaryPropertyOrder, primaryProviderProperties, relatedProviderProperties);
    }

    private PropertyValue[] getOrderedProperties(Set<String> primaryPropertyOrder, Map<String, PropertyValue> primaryProviderProperties, List<PropertyValue> relatedProviderProperties) {
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>();
        if (relatedProviderProperties != null) {
            for (PropertyValue propertyValue : relatedProviderProperties) {
                values.add(propertyValue);
            }
        }
        for (String property : primaryPropertyOrder) {
            PropertyValue propertyValue = primaryProviderProperties.get(property);
            if (propertyValue == null) continue;
            values.add(propertyValue);
        }
        return values.toArray(new PropertyValue[values.size()]);
    }

    private IdentifiableGenerationNumber[] getLowestGeneration(List<ResultItem> resultItems) {
        if (resultItems == null || resultItems.isEmpty()) {
            return null;
        }
        Hashtable<String, Long> ht = new Hashtable<String, Long>();
        for (ResultItem ri : resultItems) {
            if (ri.currentGenerations == null) continue;
            for (int i = 0; i < ri.currentGenerations.length; ++i) {
                Long currValue;
                if (ri.currentGenerations[i].key == null || (currValue = (Long)ht.get(ri.currentGenerations[i].key)) != null && (currValue == null || ri.currentGenerations[i].value >= currValue)) continue;
                ht.put(ri.currentGenerations[i].key, ri.currentGenerations[i].value);
            }
        }
        IdentifiableGenerationNumber[] genNum = new IdentifiableGenerationNumber[ht.size()];
        int counter = 0;
        for (Map.Entry pairs : ht.entrySet()) {
            genNum[counter] = IdentifiableGenerationNumber.newInstance((String)((String)pairs.getKey()), (Long)((Long)pairs.getValue()));
            ++counter;
        }
        return genNum;
    }

    private class PropertyValueComparator
    implements Comparator<PropertyValue> {
        private final ObjectReferenceService _objectReferenceService;

        public PropertyValueComparator(ObjectReferenceService objectReferenceService) {
            this._objectReferenceService = objectReferenceService;
        }

        @Override
        public int compare(PropertyValue pv1, PropertyValue pv2) {
            int result = pv1.propertyName.compareTo(pv2.propertyName);
            if (result == 0) {
                String uid1 = this._objectReferenceService.getUid(pv1);
                String uid2 = this._objectReferenceService.getUid(pv2);
                if (uid1 == null && uid2 == null) {
                    return 0;
                }
                if (uid1 == null) {
                    return -1;
                }
                if (uid2 == null) {
                    return 1;
                }
                return uid1.compareTo(uid2);
            }
            return result;
        }
    }

    public class ResultsMergerException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ResultsMergerException(String msg, Throwable cause) {
            super(msg, cause);
        }

        public ResultsMergerException(String msg) {
            super(msg);
        }
    }
}

