/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.core.model.IdentifiableGenerationNumber;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.FacetSpec;
import com.vmware.vise.data.query.FacetValue;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.SortType;
import com.vmware.vise.data.query.impl.ServicePropertyProviderAdapter;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Utils {
    public static final QuerySpec[] EMPTY_QUERY_SPECS = new QuerySpec[0];
    public static final ResultItem[] EMPTY_RESULT_ITEMS = new ResultItem[0];
    public static final FacetInfo[] EMPTY_FACET_INFOS = new FacetInfo[0];
    public static final IdentifiableGenerationNumber[] EMPTY_IDENTIFIABLE_GENERATIONS = new IdentifiableGenerationNumber[0];
    public static final PropertyValue[] EMPTY_PROPERTY_VALUES = new PropertyValue[0];
    private static final Log _logger = LogFactory.getLog(Utils.class);
    public static final String DS_TIMEOUT_CONFIG_KEY = "dataservice.timeoutSeconds";
    public static final long DEFAULT_DS_TIMEOUT_SECONDS = 120L;
    public static final String DS_CONNECTION_TIMEOUT_CONFIG_KEY = "dataservice.connectiontimeoutSeconds";
    public static final long DEFAULT_DS_CONNECTION_TIMEOUT_SECONDS = 20L;
    public static final String RELATION_SEPARATOR = ";";
    public static final String AT_FORMATTED_SUFFIX = ".@formatted";
    private static final String RESOURCE_BUNDLE_NAME = "DataService";
    private static final String PROPERTY_ID = "id";
    public static final OrderingCriteria DEFAULT_ORDERING_CRITERIA = Utils.getDefaultOrderingCriteria();
    private static final char INDENTATION_CHAR = ' ';
    private static final String NEW_LINE = "\n";
    private static final String GET_METHOD = "get";
    private static final String PROP_NAMESPACE_SEPARATOR = ":";
    private static final AtomicLong queryNameCounter = new AtomicLong(0L);
    private static final int NUMBER_OF_RENDERED_OI_CONSTRAINTS = 4;

    public static OrderingCriteria getDefaultOrderingCriteria() {
        OrderingCriteria orderingCriteria = new OrderingCriteria();
        orderingCriteria.orderingProperties = new OrderingPropertySpec[1];
        orderingCriteria.orderingProperties[0] = new OrderingPropertySpec();
        orderingCriteria.orderingProperties[0].propertyNames = new String[]{PROPERTY_ID};
        orderingCriteria.orderingProperties[0].type = "Object";
        orderingCriteria.orderingProperties[0].orderingType = SortType.ASCENDING;
        return orderingCriteria;
    }

    public static boolean isObjectIdProperty(String type2, String property) {
        return "Object".equals(type2) && PROPERTY_ID.equals(property);
    }

    public static String getLocalizedString(String key) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (ClassLoader)Utils.class.getClassLoader());
    }

    public static String createXmlFromObject(Object obj, Class ... classes) throws Exception {
        Class[] clss = Arrays.copyOf(classes, classes.length + 1);
        clss[clss.length - 1] = obj.getClass();
        JAXBContext context = JAXBContext.newInstance((Class[])clss);
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        m.marshal((Object)new JAXBElement(new QName("", "object"), obj.getClass(), obj), (OutputStream)out);
        return out.toString();
    }

    public static String getLocalizedString(String key, String ... parameters) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (String[])parameters, (ClassLoader)Utils.class.getClassLoader());
    }

    public static Object[] getEnumeratedObjects(QuerySpec querySpec) {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (querySpec.resourceSpec != null) {
            Utils.fillObjectsFromConstraints(querySpec.resourceSpec.constraint, objects, false);
        }
        return objects.toArray();
    }

    public static Object[] getEnumeratedObjects(RelationalConstraint rc) {
        ArrayList<Object> objects = new ArrayList<Object>();
        Utils.fillObjectsFromConstraints(rc, objects, true);
        return objects.toArray();
    }

    public static PropertySpec newPropertySpec(String typeName, String[] properties, ParameterSpec[] params) {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.type = typeName;
        propertySpec.propertyNames = properties;
        propertySpec.parameters = params;
        return propertySpec;
    }

    public static OrderingPropertySpec newOrderingPropertySpec(String typeName, String[] properties, ParameterSpec[] params, SortType sortType) {
        OrderingPropertySpec orderingPropertySpec = new OrderingPropertySpec();
        orderingPropertySpec.type = typeName;
        orderingPropertySpec.propertyNames = properties;
        orderingPropertySpec.parameters = params;
        orderingPropertySpec.orderingType = sortType;
        return orderingPropertySpec;
    }

    private static void fillObjectsFromConstraints(Constraint constraint, ArrayList<Object> objects, boolean includeObjectsFromRelationalConstraints) {
        if (constraint == null) {
            return;
        }
        if (ObjectIdentityConstraint.class.isInstance(constraint)) {
            ObjectIdentityConstraint oc = (ObjectIdentityConstraint)constraint;
            objects.add(oc.target);
        } else if (CompositeConstraint.class.isInstance(constraint)) {
            CompositeConstraint cc = (CompositeConstraint)constraint;
            if (cc.conjoiner.equals((Object)Conjoiner.OR)) {
                for (Constraint c : cc.nestedConstraints) {
                    Utils.fillObjectsFromConstraints(c, objects, includeObjectsFromRelationalConstraints);
                }
            }
        } else if (RelationalConstraint.class.isInstance(constraint) && includeObjectsFromRelationalConstraints) {
            RelationalConstraint rc = (RelationalConstraint)constraint;
            Utils.fillObjectsFromConstraints(rc.constraintOnRelatedObject, objects, includeObjectsFromRelationalConstraints);
        }
    }

    public static String renderPropertyProvider(PropertyProviderAdapter provider) {
        assert (provider != null);
        return Utils.renderPropertyProvider(provider, true);
    }

    public static String renderPropertyProvider(PropertyProviderAdapter provider, boolean renderFullName) {
        assert (provider != null);
        if (provider instanceof ServicePropertyProviderAdapter) {
            ServicePropertyProviderAdapter serviceProvider = (ServicePropertyProviderAdapter)provider;
            PropertyProviderBean providerBean = serviceProvider.getPropertyProvider();
            return renderFullName ? providerBean.getClass().getCanonicalName() : providerBean.getClass().getSimpleName();
        }
        return renderFullName ? provider.getClass().getCanonicalName() : provider.getClass().getSimpleName();
    }

    /*
     * WARNING - void declaration
     */
    public static String renderQuerySpec(QuerySpec querySpec) {
        if (querySpec == null) {
            return "\nQuerySpec: null\n";
        }
        StringBuilder output = new StringBuilder();
        output.append(NEW_LINE);
        Utils.writeLine(output, "QuerySpec", 0);
        String queryName = StringUtil.isNullOrEmpty((String)querySpec.name) ? "null" : querySpec.name;
        Utils.writeLine(output, "QueryName: " + queryName, 1);
        if (querySpec.resourceSpec != null) {
            Utils.writeLine(output, "ResourceSpec", 1);
            Utils.renderConstraint(output, querySpec.resourceSpec.constraint, 2);
            if (querySpec.resourceSpec.propertySpecs != null) {
                Utils.writeLine(output, String.format("PropertySpec[%1$s]", querySpec.resourceSpec.propertySpecs.length), 2);
                for (PropertySpec propertySpec : querySpec.resourceSpec.propertySpecs) {
                    Utils.renderPropertySpec(output, propertySpec, 3);
                }
            }
        } else {
            Utils.writeLine(output, "ResourceSpec: null", 1);
        }
        if (querySpec.resultSpec != null) {
            Utils.writeLine(output, "ResultSpec:", 1);
            Utils.writeLine(output, "Offset: " + querySpec.resultSpec.offset, 2);
            Utils.writeLine(output, "MaxResultCount: " + querySpec.resultSpec.maxResultCount, 2);
            if (querySpec.resultSpec.order != null) {
                Utils.writeLine(output, "OrderingCriteria", 2);
                if (querySpec.resultSpec.order.orderingProperties != null) {
                    Utils.writeLine(output, String.format("OrderPropertySpec[%1$s]", querySpec.resultSpec.order.orderingProperties.length), 3);
                    for (PropertySpec propertySpec : querySpec.resultSpec.order.orderingProperties) {
                        Utils.writeLine(output, "ProviderType: " + ((OrderingPropertySpec)propertySpec).type, 4);
                        Utils.writeLine(output, "Relationship: " + ((OrderingPropertySpec)propertySpec).relation, 4);
                        Utils.writeLine(output, "SortType: " + (Object)((Object)((OrderingPropertySpec)propertySpec).orderingType), 4);
                        Utils.writeLine(output, String.format("OrderingProperties[%1$s]", ((OrderingPropertySpec)propertySpec).propertyNames.length), 4);
                        for (String propName : ((OrderingPropertySpec)propertySpec).propertyNames) {
                            Utils.writeLine(output, "PropertyName: " + propName, 5);
                        }
                    }
                }
            } else {
                Utils.writeLine(output, "OrderingCriteria: null", 2);
            }
            if (querySpec.resultSpec.facets != null) {
                void var6_11;
                FacetSpec[] facets = querySpec.resultSpec.facets;
                Utils.writeLine(output, String.format("Facets[%d]", facets.length), 2);
                FacetSpec[] facetSpecArray = facets;
                int n = facetSpecArray.length;
                boolean bl = false;
                while (var6_11 < n) {
                    FacetSpec facet = facetSpecArray[var6_11];
                    Utils.renderPropertySpec(output, facet.propSpec, 3);
                    ++var6_11;
                }
            } else {
                Utils.writeLine(output, "Facets: null", 2);
            }
        } else {
            Utils.writeLine(output, "ResultSpec: null", 1);
        }
        Utils.renderQueryOptions(output, querySpec.options, 1);
        return output.toString();
    }

    private static void renderPropertySpec(StringBuilder output, PropertySpec propSpec, int indentation) {
        Utils.writeLine(output, "ProviderType: " + propSpec.type, indentation);
        Utils.writeLine(output, "Relationship: " + propSpec.relation, indentation);
        Utils.writeLine(output, String.format("Properties[%1$s]", propSpec.propertyNames.length), indentation);
        for (String propName : propSpec.propertyNames) {
            Utils.writeLine(output, "PropertyName: " + propName, indentation + 1);
        }
    }

    private static void renderQueryOptions(StringBuilder output, Map<String, Object> options, int indentation) {
        int nextIndentation = indentation + 1;
        if (options != null) {
            Utils.writeLine(output, "Options:", indentation);
            if (!options.isEmpty()) {
                for (Map.Entry<String, Object> entry : options.entrySet()) {
                    String entryAsString = entry.toString();
                    Utils.writeLine(output, entryAsString, nextIndentation);
                }
            } else {
                Utils.writeLine(output, "Options: [empty]", indentation);
            }
        } else {
            Utils.writeLine(output, "Options: null", indentation);
        }
    }

    private static void appendQuerySpec(StringBuilder sb, QuerySpec querySpec, int index) {
        if (index > 0) {
            sb.append(NEW_LINE);
        }
        sb.append("Query");
        if (index >= 0) {
            sb.append('[').append(index).append(']');
        }
        sb.append(":\n");
        String queryString = Utils.renderQuerySpec(querySpec);
        sb.append(queryString);
    }

    public static String renderQuerySpecs(QuerySpec[] querySpecs) {
        if (querySpecs == null) {
            return "<null>";
        }
        if (querySpecs.length == 0) {
            return "<empty_array>";
        }
        StringBuilder sb = new StringBuilder(1000);
        int total = querySpecs.length;
        for (int i = 0; i < total; ++i) {
            Utils.appendQuerySpec(sb, querySpecs[i], i);
        }
        return sb.toString();
    }

    public static String renderQuerySpecs(Collection<QuerySpec> querySpecs) {
        if (querySpecs == null) {
            return "<null>";
        }
        if (querySpecs.isEmpty()) {
            return "<empty_collection>";
        }
        StringBuilder sb = new StringBuilder(1000);
        int i = 0;
        for (QuerySpec querySpec : querySpecs) {
            Utils.appendQuerySpec(sb, querySpec, i);
            ++i;
        }
        return sb.toString();
    }

    private static void renderConstraint(StringBuilder output, Constraint constraint, int indentation) {
        if (constraint == null) {
            return;
        }
        String constraintType = constraint.getClass().getSimpleName();
        Utils.writeLine(output, String.format("Constraint: %1$s", constraintType), indentation);
        Utils.writeLine(output, "TargetType: " + constraint.targetType, indentation + 1);
        if (constraint instanceof ObjectIdentityConstraint) {
            Utils.writeLine(output, "Target: " + ((ObjectIdentityConstraint)constraint).target, indentation + 1);
        } else if (constraint instanceof PropertyConstraint) {
            PropertyConstraint pc = (PropertyConstraint)constraint;
            Utils.writeLine(output, "PropertyName: " + pc.propertyName, indentation + 1);
            Utils.writeLine(output, "Comparator: " + (Object)((Object)pc.comparator), indentation + 1);
            Object comparableValue = pc.comparableValue;
            Utils.writeLine(output, "ComparableValue: " + (comparableValue != null ? "(" + comparableValue.getClass().getName() + ") " : "") + (comparableValue instanceof Object[] ? Arrays.toString((Object[])comparableValue) : comparableValue), indentation + 1);
        } else if (constraint instanceof RelationalConstraint) {
            Utils.writeLine(output, "Relationship: " + ((RelationalConstraint)constraint).relation, indentation + 1);
            Utils.writeLine(output, "IsSourceConstrained: " + ((RelationalConstraint)constraint).hasInverseRelation, indentation + 1);
            Utils.renderConstraint(output, ((RelationalConstraint)constraint).constraintOnRelatedObject, indentation + 1);
        } else if (constraint instanceof CompositeConstraint) {
            Utils.writeLine(output, "Conjoiner: " + (Object)((Object)((CompositeConstraint)constraint).conjoiner), indentation + 1);
            Constraint[] nestedConstraints = ((CompositeConstraint)constraint).nestedConstraints;
            Utils.renderNestedConstraints(output, nestedConstraints, indentation + 1);
        }
    }

    private static void renderNestedConstraints(StringBuilder output, Constraint[] constraints, int indentation) {
        if (constraints == null || constraints.length == 0) {
            return;
        }
        int numberOfNestedConstraints = constraints.length;
        if (_logger.isDebugEnabled() || numberOfNestedConstraints <= 8 || !Utils.onlyObjectIdentityConstraints(constraints)) {
            for (Constraint constraint : constraints) {
                Utils.renderConstraint(output, constraint, indentation);
            }
            return;
        }
        for (int i = 0; i < 4; ++i) {
            Utils.renderConstraint(output, constraints[i], indentation);
        }
        Utils.writeLine(output, "...(" + (numberOfNestedConstraints - 4) + " more)...", indentation);
    }

    private static boolean onlyObjectIdentityConstraints(Constraint[] nestedConstraints) {
        for (Constraint constraint : nestedConstraints) {
            if (constraint instanceof ObjectIdentityConstraint) continue;
            return false;
        }
        return true;
    }

    private static void writeLine(StringBuilder output, String message, int indentation) {
        for (int i = 0; i < indentation; ++i) {
            output.append(' ');
        }
        output.append(message);
        output.append(NEW_LINE);
    }

    public static String getPropertyName(Method method) {
        if (!Utils.isPropertyGetter(method)) {
            return null;
        }
        String methodName = method.getName();
        String generatedPropertyName = methodName.substring(GET_METHOD.length());
        String firstChar = generatedPropertyName.substring(0, 1);
        generatedPropertyName = generatedPropertyName.replaceFirst(firstChar, firstChar.toLowerCase());
        return generatedPropertyName;
    }

    public static boolean isPropertyGetter(Method method) {
        if (method == null) {
            return false;
        }
        String methodName = method.getName();
        if (!methodName.startsWith(GET_METHOD)) {
            return false;
        }
        int modifier = method.getModifiers();
        if (Modifier.isStatic(modifier) || !Modifier.isPublic(modifier)) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length != 0;
    }

    public static void generateNamesForNamelessQueries(QuerySpec[] querySpecs) {
        if (querySpecs == null) {
            return;
        }
        for (QuerySpec qs : querySpecs) {
            if (!StringUtil.isNullOrEmpty((String)qs.name)) continue;
            qs.name = "auto-name-" + queryNameCounter.incrementAndGet();
        }
    }

    public static List<String> getQueryNames(QuerySpec[] querySpecs) {
        if (querySpecs == null || querySpecs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(querySpecs.length);
        for (QuerySpec qs : querySpecs) {
            names.add(qs.name);
        }
        return names;
    }

    public static List<String> getQueryNames(Collection<QuerySpec> querySpecs) {
        if (querySpecs == null || querySpecs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(querySpecs.size());
        for (QuerySpec qs : querySpecs) {
            names.add(qs.name);
        }
        return names;
    }

    public static String getNamespacedProperty(String propertyName, String propertyNamespace) {
        if (!StringUtil.isNullOrEmpty((String)propertyNamespace)) {
            return propertyNamespace + PROP_NAMESPACE_SEPARATOR + propertyName;
        }
        return propertyName;
    }

    public static boolean contains(PropertySpec[] propertySpecs, String typeName, String propertyName) {
        if (StringUtil.isNullOrEmpty((String)typeName)) {
            throw new IllegalArgumentException("The typeName shouldn't be null");
        }
        if (StringUtil.isNullOrEmpty((String)propertyName)) {
            throw new IllegalArgumentException("The propertyName shouldn't be null");
        }
        if (propertySpecs == null) {
            return false;
        }
        for (PropertySpec ps : propertySpecs) {
            if (!typeName.equals(ps.type) || ps.propertyNames == null || !ArrayUtil.contains((Object)propertyName, (Object[])ps.propertyNames).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static String getStringBeforeSubStr(String str, String substr) {
        if (str == null || substr == null) {
            return str;
        }
        int pos = str.indexOf(substr);
        if (pos >= 0) {
            return str.substring(0, pos);
        }
        return str;
    }

    public static String stripIfEndsWith(String str, String endStr) {
        if (str == null || endStr == null) {
            return str;
        }
        if (str.endsWith(endStr)) {
            return str.substring(0, str.length() - endStr.length());
        }
        return str;
    }

    public static String[] getTypeNamesFromConstraint(Constraint constraint) {
        if (constraint == null) {
            return null;
        }
        HashSet<String> matchedTypes = new HashSet<String>();
        Utils.gatherTypesFromConstraint(constraint, matchedTypes, false);
        String[] result = matchedTypes.toArray(new String[0]);
        return result;
    }

    public static String[] getAllTypeNamesFromConstraint(Constraint constraint) {
        if (constraint == null) {
            return null;
        }
        HashSet<String> matchedTypes = new HashSet<String>();
        Utils.gatherTypesFromConstraint(constraint, matchedTypes, true);
        String[] result = matchedTypes.toArray(new String[0]);
        return result;
    }

    private static void gatherTypesFromConstraint(Constraint constraint, Set<String> matchedTypes, boolean gatherTypeNamesFromRelations) {
        if (constraint == null) {
            return;
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint oc = (ObjectIdentityConstraint)constraint;
            if (oc.target != null) {
                String typeName = QueryUtil.getReferenceType(oc.target);
                if (typeName == null) {
                    _logger.warn((Object)String.format("Type cannot be resolved for %1$s", oc.target.toString()));
                    return;
                }
                matchedTypes.add(typeName);
            }
        } else if (constraint instanceof CompositeConstraint) {
            CompositeConstraint cc = (CompositeConstraint)constraint;
            for (Constraint nestedConstraint : cc.nestedConstraints) {
                Utils.gatherTypesFromConstraint(nestedConstraint, matchedTypes, gatherTypeNamesFromRelations);
            }
        } else if (gatherTypeNamesFromRelations && constraint instanceof RelationalConstraint) {
            RelationalConstraint rc = (RelationalConstraint)constraint;
            if (rc.targetType != null) {
                matchedTypes.add(rc.targetType);
            }
            Utils.gatherTypesFromConstraint(rc.constraintOnRelatedObject, matchedTypes, gatherTypeNamesFromRelations);
        } else if (constraint.targetType != null) {
            matchedTypes.add(constraint.targetType);
        }
    }

    public static boolean containsNonExplicitType(QuerySpec querySpec, MetadataServiceRegistryInternal metadataRegistry) {
        if (querySpec == null) {
            throw new IllegalArgumentException("The querySpec argument shouldn't be null");
        }
        if (metadataRegistry == null) {
            throw new IllegalArgumentException("The metadataRegistry argument shouldn't be null");
        }
        if (querySpec.resourceSpec == null) {
            throw new IllegalArgumentException("The query doesn't have a resourceSpec");
        }
        Constraint constraint = querySpec.resourceSpec.constraint;
        if (constraint == null) {
            throw new IllegalArgumentException("The query doesn't have a constraint");
        }
        String[] typeNames = Utils.getTypeNamesFromConstraint(constraint);
        if (typeNames == null || typeNames.length == 0) {
            return true;
        }
        boolean foundNonExplicitType = Utils.containsNonExplicitType(typeNames, metadataRegistry);
        return foundNonExplicitType;
    }

    public static boolean containsNonExplicitType(String[] typeNames, MetadataServiceRegistryInternal metadataRegistry) {
        if (typeNames == null) {
            throw new IllegalArgumentException("The typeNames argument shouldn't be null");
        }
        if (metadataRegistry == null) {
            throw new IllegalArgumentException("The metadataRegistry argument shouldn't be null");
        }
        if (typeNames.length == 0) {
            return true;
        }
        for (String typeName : typeNames) {
            if (typeName == null) {
                return true;
            }
            boolean isExplicit = metadataRegistry.isTypeExplicit(typeName);
            if (isExplicit) continue;
            return true;
        }
        return false;
    }

    public static boolean isObjectConstrained(Constraint constraint) {
        if (constraint instanceof ObjectIdentityConstraint) {
            return true;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint composite = (CompositeConstraint)constraint;
            if (composite.nestedConstraints == null) {
                return true;
            }
            if (composite.conjoiner != null && !Conjoiner.OR.equals((Object)composite.conjoiner) && composite.nestedConstraints.length > 1) {
                return false;
            }
            for (Constraint subConstraint : composite.nestedConstraints) {
                if (Utils.isObjectConstrained(subConstraint)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<String> getPropertyNames(PropertySpec[] propertySpecs) {
        if (propertySpecs == null || propertySpecs.length == 0) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> propNames = new LinkedHashSet<String>();
        for (PropertySpec propSpec : propertySpecs) {
            if (propSpec == null) continue;
            for (String propertyName : propSpec.propertyNames) {
                propNames.add(propertyName);
            }
        }
        return new ArrayList<String>(propNames);
    }

    public static Set<Object> getConstrainedObjects(Constraint constraint) {
        if (constraint == null) {
            return Collections.emptySet();
        }
        HashSet<Object> constrainedObjects = new HashSet<Object>();
        Utils.harvestConstrainedObjects(constraint, constrainedObjects);
        return constrainedObjects;
    }

    private static void harvestConstrainedObjects(Constraint constraint, Set<Object> constrainedObjectReferences) {
        if (constraint == null) {
            return;
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint oic = (ObjectIdentityConstraint)constraint;
            constrainedObjectReferences.add(oic.target);
            return;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint composite = (CompositeConstraint)constraint;
            if (composite.nestedConstraints == null) {
                return;
            }
            for (Constraint subConstraint : composite.nestedConstraints) {
                Utils.harvestConstrainedObjects(subConstraint, constrainedObjectReferences);
            }
        }
    }

    public static Set<ObjectIdentityConstraint> getObjectConstraints(Constraint constraint) {
        if (constraint == null) {
            return Collections.emptySet();
        }
        HashSet<ObjectIdentityConstraint> constrainedObjects = new HashSet<ObjectIdentityConstraint>();
        Utils.harvestConstrainedObjectConstraints(constraint, constrainedObjects);
        return constrainedObjects;
    }

    private static void harvestConstrainedObjectConstraints(Constraint constraint, Set<ObjectIdentityConstraint> constrainedObjectReferences) {
        if (constraint == null) {
            return;
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint oic = (ObjectIdentityConstraint)constraint;
            constrainedObjectReferences.add(oic);
            return;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint composite = (CompositeConstraint)constraint;
            if (composite.nestedConstraints == null) {
                return;
            }
            for (Constraint subConstraint : composite.nestedConstraints) {
                Utils.harvestConstrainedObjectConstraints(subConstraint, constrainedObjectReferences);
            }
        }
    }

    public static Object getResourceObject(ResultItem item, PropertyValue propValue) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{item, propValue});
        Object currentRef = propValue.resourceObject;
        if (currentRef != null) {
            return currentRef;
        }
        return item.resourceObject;
    }

    public static Map<Object, Map<String, Object>> extractValuesByObject(ResultSet result) {
        HashMap<Object, Map<String, Object>> valuesByObjectRef = new HashMap<Object, Map<String, Object>>();
        if (result == null || result.items == null) {
            return Collections.emptyMap();
        }
        for (ResultItem item : result.items) {
            if (item == null || item.properties == null) continue;
            for (PropertyValue propValue : item.properties) {
                Object existingValue;
                Object objectRef;
                if (propValue == null || (objectRef = Utils.getResourceObject(item, propValue)) == null) continue;
                HashMap<String, Object> valuesByPropName = (HashMap<String, Object>)valuesByObjectRef.get(objectRef);
                if (valuesByPropName == null) {
                    valuesByPropName = new HashMap<String, Object>();
                    valuesByObjectRef.put(objectRef, valuesByPropName);
                }
                if ((existingValue = valuesByPropName.put(propValue.propertyName, propValue.value)) == null) continue;
                _logger.warn((Object)("duplicate values for " + objectRef + "." + propValue.propertyName));
            }
        }
        return valuesByObjectRef;
    }

    public static long getDataServiceTimeout(ConfigurationService configService) {
        long dsTimeout = PropertyUtil.getLongProperty((ConfigurationService)configService, (String)DS_TIMEOUT_CONFIG_KEY, (long)120L);
        return dsTimeout * 1000L;
    }

    public static String renderResultSet(ResultSet resultSet) {
        StringBuilder sb = new StringBuilder();
        Utils.appendResultSet(sb, resultSet);
        return sb.toString();
    }

    public static String renderResultSets(ResultSet[] resultSets) {
        if (resultSets == null) {
            return "null";
        }
        if (resultSets.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        for (ResultSet resultSet : resultSets) {
            Utils.appendResultSet(sb, resultSet);
            sb.append(NEW_LINE);
        }
        return sb.toString();
    }

    public static long getDataServiceConnectionTimeout(ConfigurationService configService) {
        long dsTimeout = PropertyUtil.getLongProperty((ConfigurationService)configService, (String)DS_CONNECTION_TIMEOUT_CONFIG_KEY, (long)20L);
        return dsTimeout * 1000L;
    }

    private static void appendResultSet(StringBuilder output, ResultSet resultSet) {
        if (resultSet == null) {
            Utils.writeLine(output, "ResultSet: null", 0);
            return;
        }
        Utils.writeLine(output, "ResultSet", 0);
        if (!StringUtil.isNullOrEmpty((String)resultSet.queryName)) {
            Utils.writeLine(output, "QueryName: " + resultSet.queryName, 1);
        }
        Utils.writeLine(output, "TotalMatchedObjectCount: " + resultSet.totalMatchedObjectCount, 1);
        if (resultSet.error != null) {
            Utils.writeLine(output, "Error: " + resultSet.error, 1);
        }
        if (resultSet.items != null) {
            Utils.writeLine(output, "Items[" + resultSet.items.length + "]", 1);
            for (ResultItem item : resultSet.items) {
                Utils.appendResultItem(output, item, 2);
            }
        } else {
            Utils.writeLine(output, "Items: null", 1);
        }
        if (resultSet.facets != null) {
            Utils.writeLine(output, "Facets[" + resultSet.facets.length + "]", 1);
            for (FacetInfo facetInfo : resultSet.facets) {
                Utils.appendFacetInfo(output, facetInfo, 2);
            }
        }
    }

    private static void appendFacetInfo(StringBuilder output, FacetInfo facetInfo, int indentation) {
        Utils.writeLine(output, "FacetInfo", indentation);
        Utils.renderPropertySpec(output, facetInfo.propSpec, indentation + 1);
        if (facetInfo.facetValues != null) {
            int i = 0;
            for (FacetValue facetValue : facetInfo.facetValues) {
                Utils.writeLine(output, String.format("FacetValue[%d]", i + 1), indentation + 1);
                Utils.writeLine(output, "value: " + facetValue.value, indentation + 2);
                Utils.renderConstraint(output, facetValue.constraint, indentation + 2);
                ++i;
            }
        } else {
            Utils.writeLine(output, "facetValues[0]", indentation + 1);
        }
    }

    private static void appendResultItem(StringBuilder output, ResultItem item, int indentation) {
        Utils.writeLine(output, "ResultItem", indentation);
        Utils.writeLine(output, "ResourceObject: " + item.resourceObject, indentation + 1);
        if (!ArrayUtil.isNullOrEmpty((Object[])item.properties)) {
            Utils.writeLine(output, "Properties[" + item.properties.length + "]", indentation + 1);
            for (PropertyValue propertyValue : item.properties) {
                Utils.appendPropertyValue(output, propertyValue, indentation + 2);
            }
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])item.currentGenerations)) {
            Utils.writeLine(output, "CurrentGenerations[" + item.currentGenerations.length + "]", indentation + 1);
            for (PropertyValue propertyValue : item.currentGenerations) {
                Utils.appendGenerationNumber(output, (IdentifiableGenerationNumber)propertyValue, indentation + 2);
            }
        }
    }

    private static void appendPropertyValue(StringBuilder output, PropertyValue propertyValue, int indentation) {
        if (propertyValue == null) {
            Utils.writeLine(output, "null", indentation);
        } else {
            Utils.writeLine(output, propertyValue.toString(), indentation);
        }
    }

    private static void appendGenerationNumber(StringBuilder output, IdentifiableGenerationNumber generationNumber, int indentation) {
        if (generationNumber == null) {
            Utils.writeLine(output, "null", indentation);
        } else {
            Utils.writeLine(output, generationNumber.key + "=" + generationNumber.value, indentation);
        }
    }
}

