/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform;

import com.vmware.vise.data.query.transform.TransformUtil;
import com.vmware.vise.data.query.transform.TransformationException;
import com.vmware.vise.data.query.transform.Transformer;
import com.vmware.vise.util.collection.Node;
import com.vmware.vise.util.collection.Tree;
import com.vmware.vise.util.collection.TreeIterator;

public class TreeTransformer<T>
implements Transformer<Tree<T>, Tree<T>> {
    private final Transformer<Node<T>, Node<T>> _transformer;

    public TreeTransformer(Transformer<Node<T>, Node<T>> transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException("Invalid transformer.");
        }
        this._transformer = transformer;
    }

    @Override
    public Transformer.Result<Tree<T>> transform(Tree<T> tree) {
        boolean transformationMade = false;
        TransformationException error = null;
        TreeIterator iterator = tree.iterator();
        while (iterator.hasNext()) {
            Node currentNode = (Node)iterator.next();
            Transformer.Result<Node<T>> modifiedCurrentNodeResult = this.transformNode(iterator, currentNode);
            transformationMade = transformationMade || modifiedCurrentNodeResult.isTransformed();
            error = TransformUtil.getCompositeError(error, modifiedCurrentNodeResult.getError());
        }
        return new Transformer.Result<Tree<T>>(tree, transformationMade, error);
    }

    private Transformer.Result<Node<T>> transformNode(TreeIterator<T> iterator, Node<T> node) {
        Transformer.Result<Node<T>> result = this._transformer.transform(node);
        Node<T> modifiedNode = result.getData();
        if (result.isTransformed()) {
            iterator.set(modifiedNode);
        }
        return result;
    }
}

