/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform.impl;

import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.transform.DataTransformer;
import com.vmware.vise.data.query.transform.Transformer;
import com.vmware.vise.data.query.transform.impl.CustomPropertyConstraintTransformer;
import com.vmware.vise.data.query.transform.impl.CustomPropertyOrderTransformer;
import com.vmware.vise.data.query.transform.impl.EnumPropertyConstraintTransformer;
import com.vmware.vise.data.query.transform.impl.FormattingPropertyConstraintTransformer;
import com.vmware.vise.data.query.transform.impl.FormattingPropertySpecTransformer;
import com.vmware.vise.data.query.transform.impl.NormalizeConstraintTransformer;
import com.vmware.vise.data.query.transform.impl.QuerySpecTransformer;
import com.vmware.vise.metadata.ObjectModelProviderRegistryInternal;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.ArrayUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public final class DataTransformerImpl
implements DataTransformer {
    private final QuerySpecTransformer _querySpecTransformer;

    public DataTransformerImpl(DataServiceExtensionRegistryInternal dataServiceExtensionRegistry, MetadataServiceRegistryInternal metadataRegistry, ObjectModelProviderRegistryInternal objectModelProviderRegistry) {
        Validate.notNull(objectModelProviderRegistry);
        this._querySpecTransformer = DataTransformerImpl.buildQueryTransformer(dataServiceExtensionRegistry, metadataRegistry, objectModelProviderRegistry);
    }

    @Override
    public Transformer.Result<QuerySpec> transformQuery(QuerySpec querySpec) {
        Transformer.Result<QuerySpec> modifiedQueryResult = this._querySpecTransformer.transform(querySpec);
        return modifiedQueryResult;
    }

    @Override
    public Map<QuerySpec, Transformer.Result<QuerySpec>> transformQueries(List<QuerySpec> querySpecs) {
        if (ArrayUtil.isNullOrEmpty(querySpecs)) {
            return Collections.emptyMap();
        }
        HashMap<QuerySpec, Transformer.Result<QuerySpec>> transformedQueries = new HashMap<QuerySpec, Transformer.Result<QuerySpec>>();
        for (QuerySpec querySpec : querySpecs) {
            Transformer.Result<QuerySpec> transformedQueryResult = this.transformQuery(querySpec);
            if (transformedQueryResult.isTransformed()) {
                transformedQueries.put(querySpec, transformedQueryResult);
                continue;
            }
            transformedQueries.put(querySpec, new Transformer.Result<QuerySpec>(querySpec, false, null));
        }
        return transformedQueries;
    }

    private static QuerySpecTransformer buildQueryTransformer(DataServiceExtensionRegistryInternal dataServiceExtensionRegistry, MetadataServiceRegistryInternal metadataRegistry, ObjectModelProviderRegistryInternal objectModelProviderRegistry) {
        assert (dataServiceExtensionRegistry != null);
        assert (metadataRegistry != null);
        QuerySpecTransformer querySpecTransformer = new QuerySpecTransformer();
        querySpecTransformer.registerConstraintTransformer(new FormattingPropertyConstraintTransformer());
        querySpecTransformer.registerConstraintTransformer(new CustomPropertyConstraintTransformer(dataServiceExtensionRegistry));
        querySpecTransformer.registerConstraintTransformer(new NormalizeConstraintTransformer());
        querySpecTransformer.registerConstraintTransformer(new EnumPropertyConstraintTransformer(metadataRegistry));
        querySpecTransformer.registerPropertySpecTransformer(new FormattingPropertySpecTransformer());
        querySpecTransformer.registerOrderingTransformer(new CustomPropertyOrderTransformer(dataServiceExtensionRegistry));
        return querySpecTransformer;
    }
}

