/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform.impl;

import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.transform.Transformer;

public final class FormattingPropertySpecTransformer
implements Transformer<PropertySpec, PropertySpec> {
    @Override
    public Transformer.Result<PropertySpec> transform(PropertySpec propertySpec) {
        if (propertySpec == null || propertySpec.propertyNames == null) {
            return new Transformer.Result<PropertySpec>(propertySpec, false);
        }
        String[] oldPropNames = propertySpec.propertyNames;
        String[] newPropNames = new String[oldPropNames.length];
        boolean isTransformed = false;
        for (int i = 0; i < oldPropNames.length; ++i) {
            if (oldPropNames[i].indexOf(".@formatted") >= 0) {
                newPropNames[i] = Utils.getStringBeforeSubStr(oldPropNames[i], ".@formatted");
                isTransformed = true;
                continue;
            }
            newPropNames[i] = oldPropNames[i];
        }
        PropertySpec modifiedSpec = propertySpec;
        if (isTransformed) {
            modifiedSpec = new PropertySpec();
            modifiedSpec.parameters = propertySpec.parameters;
            modifiedSpec.relation = propertySpec.relation;
            modifiedSpec.type = propertySpec.type;
            modifiedSpec.propertyNames = newPropNames;
        }
        return new Transformer.Result<PropertySpec>(modifiedSpec, isTransformed);
    }
}

