/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util;

import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.Pair;

public class PropertyConstraintCompUtil {
    public static boolean matchValues(Object actualValue, Object comparableValue, Comparator comparator) {
        switch (comparator) {
            case EQUALS: {
                return ObjectUtil.objectsEqual((Object)actualValue, (Object)comparableValue);
            }
            case NOT_EQUALS: {
                return !ObjectUtil.objectsEqual((Object)actualValue, (Object)comparableValue);
            }
            case EQUALS_ANY_OF: {
                return ObjectUtil.equalsAnyOf((Object)actualValue, (Object)comparableValue);
            }
            case GREATER: {
                return PropertyConstraintCompUtil.greaterThan(actualValue, comparableValue);
            }
            case SMALLER: {
                return PropertyConstraintCompUtil.smallerThan(actualValue, comparableValue);
            }
            case STARTS_WITH: {
                return ObjectUtil.startsWith((Object)actualValue, (Object)comparableValue);
            }
            case ENDS_WITH: {
                return ObjectUtil.endsWith((Object)actualValue, (Object)comparableValue);
            }
            case CONTAINS: {
                return ObjectUtil.contains((Object)actualValue, (Object)comparableValue);
            }
            case CONTAINS_ANY_OF: {
                return ObjectUtil.containsAnyOf((Object)actualValue, (Object)comparableValue);
            }
            case MATCHES: 
            case TEXTUALLY_MATCHES: {
                return ObjectUtil.matches((Object)actualValue, (Object)comparableValue);
            }
            case RANGES_BETWEEN: {
                return PropertyConstraintCompUtil.rangesBetween(actualValue, comparableValue);
            }
        }
        throw new UnsupportedOperationException("Unsupported comparator: " + (Object)((Object)comparator));
    }

    private static boolean greaterThan(Object actualValue, Object comparableValue) {
        try {
            int result = ObjectUtil.compare((Object)actualValue, (Object)comparableValue);
            return result > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean smallerThan(Object actualValue, Object comparableValue) {
        try {
            int result = ObjectUtil.compare((Object)actualValue, (Object)comparableValue);
            return result < 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean rangesBetween(Object actualValue, Object comparableValue) {
        if (actualValue == null || comparableValue == null) {
            return false;
        }
        if (comparableValue instanceof Pair) {
            Pair pair = (Pair)comparableValue;
            Object min = pair.first;
            Object max = pair.second;
            if (min != null) {
                if (actualValue.equals(min)) {
                    return true;
                }
                if (PropertyConstraintCompUtil.smallerThan(actualValue, min)) {
                    return false;
                }
            }
            if (max != null) {
                if (actualValue.equals(max)) {
                    return true;
                }
                if (PropertyConstraintCompUtil.greaterThan(actualValue, max)) {
                    return false;
                }
            }
            return true;
        }
        throw new UnsupportedOperationException("The range operation works only if the range is specified with a " + Pair.class.getName());
    }
}

