/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util;

import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class PropertyValueMap {
    public Map<String, PropertyValue> data = new HashMap<String, PropertyValue>();

    public PropertyValueMap() {
    }

    public PropertyValueMap(String[] uids, PropertyValue[] pvs) {
        this.putProperties(uids, pvs);
    }

    public void putProperty(String uid, PropertyValue value) {
        String key = uid + "|" + value.propertyName;
        this.data.put(key, value);
    }

    public void putProperties(String[] uids, PropertyValue[] values) {
        if (ArrayUtil.isNullOrEmpty((Object[])uids) || ArrayUtil.isNullOrEmpty((Object[])values) || values.length != uids.length) {
            throw new IllegalArgumentException("Invalid arguments to register property value.");
        }
        for (int i = 0; i < values.length; ++i) {
            this.putProperty(uids[i], values[i]);
        }
    }

    public PropertyValue getProperty(String entityUid, String propertyName) {
        if (StringUtil.isNullOrEmpty((String)entityUid) || StringUtil.isNullOrEmpty((String)propertyName)) {
            return null;
        }
        String key = entityUid + "|" + propertyName;
        PropertyValue result = this.data.get(key);
        return result;
    }
}

