/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util;

import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.SortType;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import java.util.Comparator;

public final class ResultItemComparator
implements Comparator<ResultItem> {
    private final OrderingCriteria _orderingCriteria;

    public ResultItemComparator(OrderingCriteria orderingCriteria) {
        this._orderingCriteria = orderingCriteria;
    }

    @Override
    public int compare(ResultItem resItem1, ResultItem resItem2) {
        if (this._orderingCriteria == null || ArrayUtil.isNullOrEmpty((Object[])this._orderingCriteria.orderingProperties)) {
            return 0;
        }
        for (OrderingPropertySpec propSpec : this._orderingCriteria.orderingProperties) {
            boolean ascending = this.isOrderingAscending(propSpec);
            for (String prop : propSpec.propertyNames) {
                int comparisonValue = 0;
                comparisonValue = Utils.isObjectIdProperty(propSpec.type, prop) ? this.compareResourceObjects(resItem1, resItem2) : this.compareOrderingProperties(resItem1, resItem2, prop);
                if (comparisonValue == 0) continue;
                return ascending ? comparisonValue : -comparisonValue;
            }
        }
        return 0;
    }

    private int compareResourceObjects(ResultItem resItem1, ResultItem resItem2) {
        boolean isResObject1Null = this.isResourceObjectNull(resItem1);
        boolean isResObject2Null = this.isResourceObjectNull(resItem2);
        if (isResObject1Null || isResObject2Null) {
            return isResObject1Null == isResObject2Null ? 0 : (isResObject1Null ? -1 : 1);
        }
        return this.compareTo(resItem1.resourceObject, resItem2.resourceObject);
    }

    private int compareOrderingProperties(ResultItem resItem1, ResultItem resItem2, String prop) {
        PropertyValue prop1 = ResultUtil.getPropertyValue(resItem1, prop);
        PropertyValue prop2 = ResultUtil.getPropertyValue(resItem2, prop);
        boolean isValue1Null = this.isValueNull(prop1);
        boolean isValue2Null = this.isValueNull(prop2);
        if (isValue1Null || isValue2Null) {
            return isValue1Null == isValue2Null ? 0 : (isValue1Null ? -1 : 1);
        }
        return this.compareTo(prop1.value, prop2.value);
    }

    private int compareTo(Object value1, Object value2) {
        if (value1 instanceof String && value2 instanceof String) {
            String valueStr1 = (String)value1;
            String valueStr2 = (String)value2;
            return valueStr1.toLowerCase().compareTo(valueStr2.toLowerCase());
        }
        if (value1 instanceof Comparable && ResultItemComparator.areOfSameClass(value1, value2)) {
            return ((Comparable)value1).compareTo(value2);
        }
        return value1.toString().compareToIgnoreCase(value2.toString());
    }

    private static boolean areOfSameClass(Object value1, Object value2) {
        return value1.getClass().equals(value2.getClass());
    }

    private boolean isValueNull(PropertyValue propertyValue) {
        return propertyValue == null || propertyValue.value == null;
    }

    private boolean isResourceObjectNull(ResultItem resultItem) {
        return resultItem == null || resultItem.resourceObject == null;
    }

    private boolean isOrderingAscending(OrderingPropertySpec orderingSpec) {
        return orderingSpec.orderingType == null || orderingSpec.orderingType == SortType.ASCENDING;
    }
}

