/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util;

import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.query.DataException;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.util.ResultItemComparator;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Merger;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ResultUtil {
    private static final Log _logger = LogFactory.getLog(ResultUtil.class);
    private static final ResultItem[] EMPTY_RESULT_ITEMS = new ResultItem[0];

    public static boolean pageResult(ResultSet result, ResultSpec resultSpec) {
        int limit;
        int offset;
        if (result == null || result.items == null || result.items.length <= 0 || resultSpec == null) {
            return false;
        }
        int maxResultCount = resultSpec.maxResultCount != null ? resultSpec.maxResultCount : -1;
        int n = offset = resultSpec.offset != null ? resultSpec.offset : 0;
        if (offset == 0 && maxResultCount < 0) {
            return false;
        }
        int beginIndex = offset;
        ResultItem[] resultItems = result.items;
        if (beginIndex < 0 || beginIndex >= resultItems.length) {
            result.items = EMPTY_RESULT_ITEMS;
            return true;
        }
        int endIndex = maxResultCount < 0 ? resultItems.length : ((limit = offset + maxResultCount) < 0 || limit > resultItems.length ? resultItems.length : limit);
        result.items = Arrays.copyOfRange(resultItems, beginIndex, endIndex);
        return true;
    }

    public static void sortResult(ResultSet result, ResultSpec resultSpec) {
        if (resultSpec == null || resultSpec.order == null || ArrayUtil.isNullOrEmpty((Object[])resultSpec.order.orderingProperties) || result == null || ArrayUtil.isNullOrEmpty((Object[])result.items)) {
            return;
        }
        ResultItemComparator comparator = new ResultItemComparator(resultSpec.order);
        Arrays.sort(result.items, comparator);
    }

    public static PropertyValue getPropertyValue(ResultItem resultItem, String propName) {
        if (resultItem == null || resultItem.properties == null || StringUtil.isNullOrEmpty((String)propName)) {
            return null;
        }
        for (PropertyValue propValue : resultItem.properties) {
            if (propValue == null || !propName.equals(propValue.propertyName)) continue;
            return propValue;
        }
        return null;
    }

    public static boolean hasProperty(ResultItem resultItem, String propName) {
        return ResultUtil.getPropertyValue(resultItem, propName) != null;
    }

    public static void addProperty(ResultItem resultItem, PropertyValue property) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{resultItem, property});
        int newLength = resultItem.properties.length + 1;
        resultItem.properties = Arrays.copyOfRange(resultItem.properties, 0, newLength);
        resultItem.properties[newLength - 1] = property;
    }

    public static ResultSet newEmptyResultSet() {
        ResultSet result = new ResultSet();
        result.totalMatchedObjectCount = 0;
        return result;
    }

    public static ResultSet newErrorResultSet(Exception ... exceptions) {
        ResultSet result = new ResultSet();
        if (exceptions == null || exceptions.length == 0) {
            throw new IllegalArgumentException("Parameters must include at least one exception");
        }
        result.error = exceptions.length == 1 ? exceptions[0] : new CompositeException(exceptions);
        return result;
    }

    public static PropertyValue newProperty(String name, Object value) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Property name is " + (name == null ? "null." : "empty."));
        }
        PropertyValue property = new PropertyValue();
        property.propertyName = name;
        property.value = value;
        return property;
    }

    public static PropertyValue newProperty(String name, Object value, Object provider) {
        PropertyValue property = ResultUtil.newProperty(name, value);
        property.resourceObject = provider;
        return property;
    }

    public static List<DataException> mergeDuplicates(Collection<DataException> exceptions) {
        List mergedFaults = CollectionUtil.mergeDuplicates(exceptions, (Comparator)new Comparator<DataException>(){

            @Override
            public int compare(DataException de1, DataException de2) {
                Throwable rootCause1 = de1.rootCause;
                Throwable rootCause2 = de2.rootCause;
                boolean rootCausesMatch = false;
                if (rootCause1 == null) {
                    if (rootCause2 != null) {
                        return -1;
                    }
                    rootCausesMatch = true;
                } else {
                    if (rootCause2 == null) {
                        return 1;
                    }
                    String msg1 = rootCause1.getMessage();
                    String msg2 = rootCause2.getMessage();
                    boolean bl = rootCause1.getClass().equals(rootCause2.getClass()) && (msg1 == null ? msg2 == null : msg1.equals(msg2)) ? true : (rootCausesMatch = false);
                }
                if (rootCausesMatch && Arrays.equals(de1.objects, de2.objects)) {
                    return 0;
                }
                return 1;
            }
        }, (Merger)new Merger<DataException>(){

            public DataException merge(DataException de1, DataException de2) {
                String[] properties;
                if (de1.properties == null) {
                    properties = de2.properties;
                } else if (de2.properties == null) {
                    properties = de1.properties;
                } else {
                    properties = new String[de1.properties.length + de2.properties.length];
                    System.arraycopy(de1.properties, 0, properties, 0, de1.properties.length);
                    System.arraycopy(de2.properties, 0, properties, de1.properties.length, de2.properties.length);
                }
                de1.properties = properties;
                return de1;
            }
        });
        return mergedFaults;
    }

    public static void setQueryNamesIntoResults(QuerySpec[] querySpecs, ResultSet[] resultSets) {
        if (querySpecs == null || resultSets == null) {
            return;
        }
        if (querySpecs.length != resultSets.length) {
            throw new IllegalArgumentException("The number of querySpecs (" + querySpecs.length + ") is different from the number of resultSets (" + resultSets.length + ").");
        }
        int total = resultSets.length;
        for (int i = 0; i < total; ++i) {
            QuerySpec querySpec;
            ResultSet resultSet = resultSets[i];
            if (resultSet == null || (querySpec = querySpecs[i]) == null || querySpec.name == null) continue;
            if (!StringUtil.isNullOrWhitespace((String)resultSet.queryName) && !resultSet.queryName.equals(querySpec.name)) {
                _logger.warn((Object)("The result set at position " + i + " (0-based) has a queryName (" + resultSet.queryName + ") but it's different from the name of the querySpec (" + querySpec.name + "). The querySpec's name will overwrite the resultSet's name."));
            }
            resultSet.queryName = querySpec.name;
        }
    }
}

