/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuerySpecBuilderImpl
implements QuerySpecBuilder {
    private static final Logger _logger = LoggerFactory.getLogger(QuerySpecBuilderImpl.class);
    public static final Constraint[] EMPTY_CONSTRAINTS = new Constraint[0];
    public static final ResultSet[] EMPTYSET = new ResultSet[0];
    private final ObjectReferenceService _objectReferenceService;

    public QuerySpecBuilderImpl(ObjectReferenceService objectReferenceService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectReferenceService});
        this._objectReferenceService = objectReferenceService;
    }

    @Override
    public QuerySpec buildQuerySpec(Object entity, String[] properties) {
        ObjectIdentityConstraint oc = new ObjectIdentityConstraint();
        oc.target = entity;
        String targetType = this._objectReferenceService.getResourceObjectType(entity);
        HashSet<String> targetTypes = new HashSet<String>();
        targetTypes.add(targetType);
        QuerySpec query = this.buildQuerySpec(oc, properties, targetTypes);
        return query;
    }

    @Override
    public QuerySpec buildQuerySpec(Object[] entities, String[] properties) {
        if (entities.length == 1) {
            return this.buildQuerySpec(entities[0], properties);
        }
        CompositeConstraint cc = new CompositeConstraint();
        cc.conjoiner = Conjoiner.OR;
        Constraint[] nestedConstraints = new Constraint[entities.length];
        HashSet<String> targetTypes = new HashSet<String>();
        String targetType = null;
        for (int index = 0; index < entities.length; ++index) {
            ObjectIdentityConstraint oc = new ObjectIdentityConstraint();
            oc.target = entities[index];
            nestedConstraints[index] = oc;
            targetType = this._objectReferenceService.getResourceObjectType(oc.target);
            targetTypes.add(targetType);
        }
        cc.nestedConstraints = nestedConstraints;
        QuerySpec query = this.buildQuerySpec(cc, properties, targetTypes);
        return query;
    }

    @Override
    public QuerySpec buildQuerySpec(Constraint constraint, String[] properties) {
        Set<String> targetTypes = constraint.targetType == null ? null : Collections.singleton(constraint.targetType);
        QuerySpec query = this.buildQuerySpec(constraint, properties, targetTypes);
        return query;
    }

    @Override
    public QuerySpec buildQuerySpec(Constraint constraint, String[] properties, Set<String> targetTypes) {
        QuerySpec query = new QuerySpec();
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        ArrayList<PropertySpec> pSpecs = new ArrayList<PropertySpec>();
        if (targetTypes != null) {
            for (String targetType : targetTypes) {
                PropertySpec propSpec = this.createPropertySpec(properties, targetType);
                pSpecs.add(propSpec);
            }
        } else {
            PropertySpec propSpec = this.createPropertySpec(properties, null);
            pSpecs.add(propSpec);
        }
        resourceSpec.propertySpecs = pSpecs.toArray(new PropertySpec[0]);
        query.resourceSpec = resourceSpec;
        return query;
    }

    @Override
    public PropertySpec createPropertySpec(String[] properties, String targetType) {
        PropertySpec propSpec = new PropertySpec();
        propSpec.type = targetType;
        propSpec.propertyNames = properties;
        return propSpec;
    }

    @Override
    public ResourceSpec createEmptyResourceSpec() {
        PropertySpec propSpec = new PropertySpec();
        propSpec.propertyNames = new String[0];
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.propertySpecs = new PropertySpec[]{propSpec};
        return resourceSpec;
    }

    @Override
    public boolean areEquivalent(QuerySpec a, QuerySpec b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return ObjectUtil.objectsEqual((Object)a.resourceSpec, (Object)b.resourceSpec) && ObjectUtil.objectsEqual((Object)a.resultSpec, (Object)b.resultSpec) && ObjectUtil.objectsEqual(a.options, b.options);
    }

    @Override
    public Map<String, Set<String>> getQueryProperties(QuerySpec query, boolean mayHaveHeterogenousConstraints) {
        if (query == null || query.resourceSpec == null || ArrayUtil.isNullOrEmpty((Object[])query.resourceSpec.propertySpecs)) {
            return new HashMap<String, Set<String>>();
        }
        Set<String> constraintTypes = this.getConstraintTargetTypes(query.resourceSpec.constraint, mayHaveHeterogenousConstraints);
        PropertySpec[] propertySpecs = query.resourceSpec.propertySpecs;
        if (constraintTypes.isEmpty()) {
            constraintTypes.add("*");
        }
        HashMap<String, Set<String>> queryProperties = new HashMap<String, Set<String>>();
        for (PropertySpec propertySpec : propertySpecs) {
            if (!this.isValidNonRelational(propertySpec)) continue;
            if (StringUtil.isNullOrEmpty((String)propertySpec.type) || "*".equals(propertySpec.type)) {
                for (String constraintType : constraintTypes) {
                    this.addQueryProperties(queryProperties, constraintType, propertySpec.propertyNames);
                }
                continue;
            }
            this.addQueryProperties(queryProperties, propertySpec.type, propertySpec.propertyNames);
        }
        return queryProperties;
    }

    private void addQueryProperties(Map<String, Set<String>> queryProperties, String type2, String[] properties) {
        Set<String> typeProperties = queryProperties.get(type2);
        if (typeProperties == null) {
            typeProperties = new HashSet<String>();
            queryProperties.put(type2, typeProperties);
        }
        for (String propertyName : properties) {
            typeProperties.add(Utils.stripIfEndsWith(propertyName, ".@formatted"));
        }
    }

    private boolean isValidNonRelational(PropertySpec propertySpec) {
        return propertySpec != null && StringUtil.isNullOrEmpty((String)propertySpec.relation) && !ArrayUtil.isNullOrEmpty((Object[])propertySpec.propertyNames);
    }

    @Override
    public RelationalConstraint createRelationalConstraint(String relationship, Constraint constraintOnRelatedObject, Boolean hasInverseRelation, String targetType) {
        RelationalConstraint rc = new RelationalConstraint();
        rc.relation = relationship;
        rc.hasInverseRelation = hasInverseRelation;
        rc.constraintOnRelatedObject = constraintOnRelatedObject;
        rc.targetType = targetType;
        return rc;
    }

    @Override
    public Constraint createConstraintForRelationship(Object object, String relationship, String targetType) {
        ObjectIdentityConstraint objectConstraint = this.createObjectIdentityConstraint(object);
        RelationalConstraint relationalConstraint = this.createRelationalConstraint(relationship, objectConstraint, true, targetType);
        return relationalConstraint;
    }

    @Override
    public PropertyConstraint createPropertyConstraint(String objectType, String propertyName, Comparator comparator, Object comparableValue) {
        PropertyConstraint constraint = new PropertyConstraint();
        constraint.targetType = objectType;
        constraint.propertyName = propertyName;
        constraint.comparator = comparator;
        constraint.comparableValue = comparableValue;
        return constraint;
    }

    @Override
    public Constraint combineIntoSingleConstraint(Constraint[] constraints, Conjoiner conjoiner) {
        if (ArrayUtil.isNullOrEmpty((Object[])constraints)) {
            return null;
        }
        if (constraints.length == 1) {
            return constraints[0];
        }
        return this.createCompositeConstraint(constraints, conjoiner);
    }

    @Override
    public Constraint combineIntoSingleConstraint(Object[] entities, Conjoiner conjoiner) {
        if (ArrayUtil.isNullOrEmpty((Object[])entities)) {
            return null;
        }
        Constraint[] nestedConstraints = new Constraint[entities.length];
        for (int index = 0; index < entities.length; ++index) {
            ObjectIdentityConstraint oc = new ObjectIdentityConstraint();
            oc.target = entities[index];
            oc.targetType = this._objectReferenceService.getResourceObjectType(entities[index]);
            nestedConstraints[index] = oc;
        }
        if (entities.length == 1) {
            return nestedConstraints[0];
        }
        return this.createCompositeConstraint(nestedConstraints, conjoiner);
    }

    @Override
    public CompositeConstraint createCompositeConstraint(Constraint[] nestedConstraints, Conjoiner conjoiner) {
        HashSet<String> targetTypes = new HashSet<String>(nestedConstraints.length);
        for (Constraint nestedConstraint : nestedConstraints) {
            targetTypes.add(nestedConstraint.targetType);
        }
        String targetType = targetTypes.size() == 1 ? (String)targetTypes.iterator().next() : null;
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.targetType = targetType;
        compositeConstraint.nestedConstraints = nestedConstraints;
        compositeConstraint.conjoiner = conjoiner;
        return compositeConstraint;
    }

    @Override
    public ObjectIdentityConstraint createObjectIdentityConstraint(Object entity) {
        ObjectIdentityConstraint oc = new ObjectIdentityConstraint();
        oc.target = entity;
        oc.targetType = this._objectReferenceService.getResourceObjectType(entity);
        return oc;
    }

    @Override
    public boolean validateQueryConstraint(Constraint constraint) {
        if (constraint == null) {
            _logger.warn("Invalid constraint: constraint is null");
            return false;
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            boolean isValid;
            ObjectIdentityConstraint oic = (ObjectIdentityConstraint)constraint;
            boolean bl = isValid = oic.target != null;
            if (!isValid) {
                _logger.warn("Invalid constraint: constraint target is null");
            }
            return isValid;
        }
        if (constraint instanceof RelationalConstraint) {
            RelationalConstraint rc = (RelationalConstraint)constraint;
            if (StringUtil.isNullOrEmpty((String)rc.relation)) {
                _logger.warn("Invalid constraint: relational constraint's relation is null");
                return false;
            }
            return this.validateQueryConstraint(rc.constraintOnRelatedObject);
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint cc = (CompositeConstraint)constraint;
            if (cc.nestedConstraints == null) {
                _logger.warn("Invalid composite constraint: nested constraints are null");
                return false;
            }
            if (cc.nestedConstraints.length == 0) {
                _logger.warn("Invalid composite constraint: nested constraints are empty");
                return false;
            }
            if (cc.conjoiner == null) {
                _logger.warn("Invalid composite constraint: conjoiner is null");
                return false;
            }
            for (Constraint c : cc.nestedConstraints) {
                if (this.validateQueryConstraint(c)) continue;
                return false;
            }
        } else if (constraint instanceof PropertyConstraint) {
            boolean isValid;
            PropertyConstraint pc = (PropertyConstraint)constraint;
            boolean bl = isValid = pc.comparator != null;
            if (!isValid) {
                _logger.warn("Invalid constraint: property constraint comparator is null");
            }
            return isValid;
        }
        return true;
    }

    @Override
    public Set<String> getConstraintTargetTypes(Constraint constraint, boolean mayHaveHeterogenousConstraints) {
        if (constraint == null || constraint instanceof RelationalConstraint && ((RelationalConstraint)constraint).hasInverseRelation) {
            return new HashSet<String>();
        }
        String targetType = constraint.targetType;
        if (constraint instanceof ObjectIdentityConstraint) {
            targetType = this._objectReferenceService.getResourceObjectType(((ObjectIdentityConstraint)constraint).target);
        } else if (constraint instanceof CompositeConstraint) {
            Constraint[] nestedConstraints = ((CompositeConstraint)constraint).nestedConstraints;
            nestedConstraints = nestedConstraints == null ? new Constraint[]{} : nestedConstraints;
            HashSet<String> nestedTypes = new HashSet<String>();
            for (Constraint nestedConstraint : nestedConstraints) {
                Set<String> nestedConstraintTypes = this.getConstraintTargetTypes(nestedConstraint, mayHaveHeterogenousConstraints);
                if (nestedConstraintTypes.isEmpty()) continue;
                nestedTypes.addAll(nestedConstraintTypes);
            }
            if (!nestedTypes.isEmpty()) {
                if (mayHaveHeterogenousConstraints) {
                    return nestedTypes;
                }
                if (nestedTypes.size() == 1) {
                    targetType = (String)nestedTypes.iterator().next();
                }
            }
        }
        return StringUtil.isNullOrEmpty((String)targetType) ? new HashSet<String>() : new HashSet<String>(Arrays.asList(targetType));
    }

    @Override
    public String getConstraintTargetType(Constraint constraint) {
        Set<String> constraintTargetTypes = this.getConstraintTargetTypes(constraint, false);
        if (constraintTargetTypes != null && constraintTargetTypes.size() == 1) {
            return constraintTargetTypes.iterator().next();
        }
        return null;
    }
}

