/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.uri;

import com.vmware.vise.util.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;

public final class DefaultUriSchemeUtil {
    static final String PREFIX = "urn:vri";
    private static final char TYPE_DELIMITER = ':';
    private static final char NSS_DELIMITER = ':';
    private static final String PREFIX_PLUS_NSS_DELIMITER = "urn:vri:";
    private static final String ID_SEGMENT_DELIMITER = "/";
    static final char ESCAPE_CHAR = '!';
    static final char ESCAPE_CHAR_FOR_DELIMITER = '_';

    public static URI createUri(String type2, String id) {
        URI result;
        if (StringUtil.isNullOrEmpty((String)type2)) {
            throw new IllegalArgumentException("The type of the resource that the URI identifies should be specified!");
        }
        if (StringUtil.isNullOrEmpty((String)id)) {
            throw new IllegalArgumentException("The resource identification part of the URI should be specified!");
        }
        id = DefaultUriSchemeUtil.escapeUriComponent(id);
        try {
            result = new URI(PREFIX, type2 + ':' + id, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    public static URI createUri(String type2, String[] idSegments) {
        if (StringUtil.isNullOrEmpty((String)type2)) {
            throw new IllegalArgumentException("The type of the URI should be specified!");
        }
        if (idSegments == null || idSegments.length == 0) {
            throw new IllegalArgumentException("The idSegments of the URI should be specified!");
        }
        StringBuffer buffer = new StringBuffer(idSegments.length);
        for (int i = 0; i < idSegments.length - 1; ++i) {
            buffer.append(idSegments[i]);
            buffer.append(ID_SEGMENT_DELIMITER);
        }
        buffer.append(idSegments[idSegments.length - 1]);
        URI uri = DefaultUriSchemeUtil.createUri(type2, buffer.toString());
        return uri;
    }

    public static String getType(URI uri) {
        return DefaultUriSchemeUtil.parseSchemeSpecificPart(uri, true);
    }

    public static String getId(URI uri) {
        String result = DefaultUriSchemeUtil.parseSchemeSpecificPart(uri, false);
        result = DefaultUriSchemeUtil.unescapeUriComponent(result);
        return result;
    }

    public static String[] getIdSegments(URI uri) {
        String uriId = DefaultUriSchemeUtil.getId(uri);
        int segmentSeparatorIndex = uriId.indexOf(ID_SEGMENT_DELIMITER);
        if (segmentSeparatorIndex == -1) {
            return new String[]{uriId};
        }
        return uriId.split(ID_SEGMENT_DELIMITER);
    }

    private static String parseSchemeSpecificPart(URI uri, boolean parseType) {
        DefaultUriSchemeUtil.checkValid(uri);
        String ssPart = uri.getSchemeSpecificPart();
        ssPart = ssPart.substring(ssPart.indexOf(58) + 1);
        int separatorIndex = ssPart.lastIndexOf(58);
        if (separatorIndex == -1) {
            throw new IllegalArgumentException("The provided URI does not contain valid type delimiter.");
        }
        String result = parseType ? ssPart.substring(0, separatorIndex) : ssPart.substring(separatorIndex + 1);
        return result;
    }

    private static void checkValid(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("The provided URI is null");
        }
        if (!uri.toString().startsWith(PREFIX_PLUS_NSS_DELIMITER)) {
            throw new IllegalArgumentException("The provided URI doesn't use the default scheme: urn:vri:");
        }
    }

    static String escapeUriComponent(String str) {
        if (StringUtil.isNullOrEmpty((String)str)) {
            return str;
        }
        if (str.indexOf(33) < 0 && str.indexOf(58) < 0) {
            return str;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len + 10);
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == ':') {
                sb.append('!').append('_');
                continue;
            }
            if (ch == '!') {
                sb.append('!').append('!');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    static String unescapeUriComponent(String str) {
        int i;
        if (StringUtil.isNullOrEmpty((String)str)) {
            return str;
        }
        if (str.indexOf(33) < 0) {
            return str;
        }
        int lastCharIndex = str.length() - 1;
        StringBuilder sb = new StringBuilder(lastCharIndex + 10);
        block4: for (i = 0; i < lastCharIndex; ++i) {
            char ch = str.charAt(i);
            if (ch != '!') {
                sb.append(ch);
                continue;
            }
            char nextChar = str.charAt(++i);
            switch (nextChar) {
                case '_': {
                    sb.append(':');
                    continue block4;
                }
                case '!': {
                    sb.append('!');
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported escape sequence: " + ch + nextChar);
                }
            }
        }
        if (i == lastCharIndex) {
            sb.append(str.charAt(lastCharIndex));
        }
        return sb.toString();
    }
}

