/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata;

import com.vmware.vise.core.model.data;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.common.XSFacet;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.metadata.Descriptor;
import com.vmware.vise.metadata.Units;
import com.vmware.vise.util.i18n.MessageLocalizer;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.text.ParseException;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@data
public class DataElementDescriptor
extends Descriptor {
    private static final Log _logger = LogFactory.getLog(DataElementDescriptor.class);
    @XmlAttribute(required=true)
    public String valueTypeName;
    public XSFacet[] staticValueSpace;
    public QuerySpec dynamicValueSpace;
    @XmlElement(required=true)
    public String providerName;
    public boolean isOptional;
    public Object defaultValue;
    public Units unit;
    public Units displayForm;

    public DataElementDescriptor() {
    }

    public DataElementDescriptor(DataElementDescriptor original) {
        original.copyFieldsTo(this, false);
    }

    @Override
    protected void copyFieldsTo(Descriptor target, boolean cloneLocalizableFields) {
        super.copyFieldsTo(target, cloneLocalizableFields);
        if (target instanceof DataElementDescriptor) {
            DataElementDescriptor ded = (DataElementDescriptor)target;
            ded.valueTypeName = this.valueTypeName;
            if (cloneLocalizableFields && this.staticValueSpace != null) {
                int len = this.staticValueSpace.length;
                ded.staticValueSpace = new XSFacet[len];
                for (int i = 0; i < len; ++i) {
                    ded.staticValueSpace[i] = this.cloneXSFacetForLocalization(this.staticValueSpace[i]);
                }
            } else {
                ded.staticValueSpace = this.staticValueSpace;
            }
            ded.dynamicValueSpace = this.dynamicValueSpace;
            ded.providerName = this.providerName;
            ded.isOptional = this.isOptional;
            ded.defaultValue = this.defaultValue;
            ded.unit = this.unit;
            ded.displayForm = this.displayForm;
        }
    }

    private XSFacet cloneXSFacetForLocalization(XSFacet original) {
        if (original == null) {
            return null;
        }
        Object value = original.value;
        if (value instanceof NameValuePair) {
            XSFacet clone = new XSFacet();
            clone.type = original.type;
            NameValuePair nvp = (NameValuePair)value;
            NameValuePair clonedNVP = new NameValuePair(nvp.name, nvp.value);
            clone.value = clonedNVP;
            return clone;
        }
        return original;
    }

    @Override
    protected void localize(MessageLocalizer msgLoc) {
        super.localize(msgLoc);
        if (msgLoc == null || this.staticValueSpace == null) {
            return;
        }
        XSFacet[] xsfValues = this.staticValueSpace;
        int total = xsfValues.length;
        for (int i = 0; i < total; ++i) {
            Object value;
            XSFacet xsfValue = xsfValues[i];
            if (xsfValue == null || !((value = xsfValue.value) instanceof NameValuePair)) continue;
            NameValuePair nvp = (NameValuePair)value;
            try {
                String localizedName = ResourceUtil.localizeString((String)nvp.name, (MessageLocalizer)msgLoc);
                if (localizedName == null || localizedName.equals(nvp.name)) continue;
                nvp.name = localizedName;
                continue;
            }
            catch (ParseException e) {
                _logger.error((Object)("Failed to localize a staticValueSpace label at position " + i + " (0-based) for descriptor " + this.providerName + " / " + this.name + ". The key that could not be localized was: " + nvp.name), (Throwable)e);
            }
        }
    }

    @Override
    protected void appendFieldValuesTo(StringBuilder sb) {
        super.appendFieldValuesTo(sb);
        sb.append(", valueTypeName=").append(this.valueTypeName).append(", providerName=").append(this.providerName).append(", isOptional=").append(this.isOptional).append(", defaultValue=").append(this.defaultValue).append(", unit=").append((Object)this.unit).append(", displayForm=").append((Object)this.displayForm).append(", staticValueSpace=").append(Arrays.toString(this.staticValueSpace)).append(", dynamicValueSpace=").append(this.dynamicValueSpace != null ? Utils.renderQuerySpec(this.dynamicValueSpace) : null);
    }
}

