/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata;

import com.vmware.vise.core.model.data;
import com.vmware.vise.metadata.impl.jaxb.JaxbTagsMapAdapter;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.MessageLocalizer;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@data
public class Descriptor
implements Cloneable {
    private static final Log _logger = LogFactory.getLog(Descriptor.class);
    @XmlAttribute(required=true)
    public String name;
    @XmlAttribute
    public String title;
    @XmlAttribute
    public String description;
    @XmlJavaTypeAdapter(value=JaxbTagsMapAdapter.class)
    public Map<String, String> tags;

    public Descriptor() {
    }

    public Descriptor(String name, String title, String description, Map<String, String> tags) {
        if (StringUtil.isNullOrWhitespace((String)name)) {
            throw new IllegalArgumentException("The name shouldn't be null or whitespace");
        }
        this.name = name;
        this.title = title;
        this.description = description;
        if (tags != null) {
            this.tags = new HashMap<String, String>(tags);
        }
    }

    public Descriptor(Descriptor original) {
        if (original == null) {
            throw new IllegalArgumentException("Cannot create a copy of a null " + this.getClass().getName());
        }
        original.copyFieldsTo(this, false);
    }

    public Descriptor buildLocalizedCopy(MessageLocalizer msgLoc) {
        Descriptor copy = this.createInstanceForLocalization();
        this.copyFieldsTo(copy, true);
        copy.localize(msgLoc);
        return copy;
    }

    protected Descriptor createInstanceForLocalization() {
        try {
            return (Descriptor)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Failed to create a copy of a " + this.getClass().getName() + " for localization", e);
        }
    }

    protected void copyFieldsTo(Descriptor target, boolean cloneLocalizableFields) {
        if (target == null) {
            throw new IllegalArgumentException("The 'target' Desscriptor should not be null");
        }
        target.name = this.name;
        target.title = this.title;
        target.description = this.description;
        target.tags = this.tags;
    }

    protected void localize(MessageLocalizer msgLoc) {
        if (msgLoc == null) {
            return;
        }
        try {
            this.title = ResourceUtil.localizeString((String)this.title, (MessageLocalizer)msgLoc);
        }
        catch (ParseException e) {
            _logger.error((Object)"Failed to localize a descriptor's title.", (Throwable)e);
        }
        try {
            this.description = ResourceUtil.localizeString((String)this.description, (MessageLocalizer)msgLoc);
        }
        catch (ParseException e) {
            _logger.error((Object)"Failed to localize a descriptor's description.", (Throwable)e);
        }
    }

    protected void appendFieldValuesTo(StringBuilder sb) {
        sb.append("name=").append(this.name).append(", title=").append(this.title).append(", description=").append(this.description).append(", tags=").append(this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append('[').append(this.getClass().getSimpleName()).append(": ");
        this.appendFieldValuesTo(sb);
        sb.append(']');
        return sb.toString();
    }
}

