/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.ImageArea;
import org.apache.fop.image.SVGImage;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.awt.FontMetricsMapper;
import org.apache.fop.render.awt.FontSetup;
import org.apache.fop.svg.SVGArea;
import org.apache.fop.svg.SVGUserAgent;
import org.apache.fop.viewer.ProgressListener;
import org.apache.fop.viewer.Translator;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class AWTRenderer
extends AbstractRenderer
implements Printable,
Pageable {
    protected int pageWidth = 0;
    protected int pageHeight = 0;
    protected double scaleFactor = 100.0;
    protected int pageNumber = 0;
    protected Vector pageList = new Vector();
    protected ProgressListener progressListener = null;
    protected Translator res = null;
    protected Map fontNames = new HashMap();
    protected Map fontStyles = new HashMap();
    protected Color saveColor = null;
    private BufferedImage pageImage = null;
    protected Graphics2D graphics = null;
    protected String currentFontName;
    protected int currentFontSize;
    protected float currentRed = 0.0f;
    protected float currentGreen = 0.0f;
    protected float currentBlue = 0.0f;
    protected Font lastFont = null;
    protected Color lastColor = null;
    protected Component parent;
    protected Map options;

    public AWTRenderer(Translator aRes) {
        this.res = aRes;
    }

    protected void addFilledRect(int x, int y, int w, int h, ColorType col) {
        float r = col.red();
        float g = col.green();
        float b = col.blue();
        this.addRect(x, y, w, h, r, g, b, r, g, b);
    }

    protected void addLine(int x1, int y1, int x2, int y2, int th, float r, float g, float b) {
        int width;
        int height;
        this.graphics.setColor(new Color(r, g, b));
        int x = x1;
        int y = y1;
        if (x1 == x2) {
            height = y2 - y1;
            if (height > 0) {
                height = -height;
                y = y2;
            }
            if ((width = th) < 0) {
                width = -width;
                x -= width;
            }
        } else {
            width = x2 - x1;
            if (width < 0) {
                width = -width;
                x = x2;
            }
            if ((height = th) > 0) {
                height = -height;
                y -= height;
            }
        }
        this.addRect(x, y, width, height, false);
    }

    protected void addRect(int x, int y, int w, int h, float r, float g, float b) {
        this.graphics.setColor(new Color(r, g, b));
        this.addRect(x, y, w, h, true);
    }

    protected void addRect(int x, int y, int w, int h, float r, float g, float b, float fr, float fg, float fb) {
        this.graphics.setColor(new Color(r, g, b));
        this.addRect(x, y, w, h, true);
        this.graphics.setColor(new Color(fr, fg, fb));
        this.addRect(x, y, w, h, false);
    }

    protected void addRect(int x, int y, int w, int h, boolean drawAsOutline) {
        int startx = (x + 500) / 1000;
        int starty = this.pageHeight - (y + 500) / 1000;
        int endx = (x + w + 500) / 1000;
        int endy = this.pageHeight - (y + h + 500) / 1000;
        if (drawAsOutline) {
            this.graphics.drawRect(startx, starty, endx - startx, endy - starty);
        } else {
            if (w != 0 && endx == startx) {
                ++endx;
            }
            if (h != 0 && endy == starty) {
                ++endy;
            }
            this.graphics.fillRect(startx, starty, endx - startx, endy - starty);
        }
    }

    public static Color colorType2Color(ColorType ct) {
        if (ct == null) {
            return null;
        }
        return new Color(ct.red(), ct.green(), ct.blue());
    }

    protected void doFrame(Area area) {
        ColorType borderColor;
        int rx = this.currentAreaContainerXPosition;
        int w = area.getContentWidth();
        if (area instanceof BlockArea) {
            rx += ((BlockArea)area).getStartIndent();
        }
        int h = area.getContentHeight();
        int ry = this.currentYPosition;
        w = w + area.getPaddingLeft() + area.getPaddingRight();
        h = h + area.getPaddingTop() + area.getPaddingBottom();
        this.doBackground(area, rx -= area.getPaddingLeft(), ry += area.getPaddingTop(), w, h);
        rx -= area.getBorderLeftWidth();
        ry += area.getBorderTopWidth();
        w = w + area.getBorderLeftWidth() + area.getBorderRightWidth();
        h = h + area.getBorderTopWidth() + area.getBorderBottomWidth();
        BorderAndPadding bp = area.getBorderAndPadding();
        if (area.getBorderTopWidth() != 0) {
            borderColor = bp.getBorderColor(0);
            this.addLine(rx, ry, rx + w, ry, -area.getBorderTopWidth(), borderColor.red(), borderColor.green(), borderColor.blue());
        }
        if (area.getBorderLeftWidth() != 0) {
            borderColor = bp.getBorderColor(3);
            this.addLine(rx, ry, rx, ry - h, area.getBorderLeftWidth(), borderColor.red(), borderColor.green(), borderColor.blue());
        }
        if (area.getBorderRightWidth() != 0) {
            borderColor = bp.getBorderColor(1);
            this.addLine(rx + w, ry, rx + w, ry - h, -area.getBorderRightWidth(), borderColor.red(), borderColor.green(), borderColor.blue());
        }
        if (area.getBorderBottomWidth() != 0) {
            borderColor = bp.getBorderColor(2);
            this.addLine(rx, ry - h, rx + w, ry - h, area.getBorderBottomWidth(), borderColor.red(), borderColor.green(), borderColor.blue());
        }
    }

    protected void drawFrame() {
        int width = this.pageWidth;
        int height = this.pageHeight;
        this.graphics.setColor(Color.white);
        this.graphics.fillRect(0, 0, width, height);
        this.graphics.setColor(Color.black);
        this.graphics.drawRect(-1, -1, width + 2, height + 2);
        this.graphics.drawLine(width + 2, 0, width + 2, height + 2);
        this.graphics.drawLine(width + 3, 1, width + 3, height + 3);
        this.graphics.drawLine(0, height + 2, width + 2, height + 2);
        this.graphics.drawLine(1, height + 3, width + 3, height + 3);
    }

    protected void drawImageClipped(int x, int y, int clipX, int clipY, int clipW, int clipH, FopImage image, FontState fs) {
    }

    protected void drawImageScaled(int x, int y, int w, int h, FopImage image, FontState fs) {
    }

    protected Rectangle2D getBounds(Area a) {
        return new Rectangle2D.Double(this.currentAreaContainerXPosition, this.currentYPosition, a.getAllocationWidth(), a.getHeight());
    }

    public BufferedImage getLastRenderedPage() {
        return this.pageImage;
    }

    public int getNumberOfPages() {
        return this.pageList.size();
    }

    public int getPageCount() {
        return this.pageList.size();
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        double height;
        if (pageIndex >= this.pageList.size()) {
            return null;
        }
        Page page = (Page)this.pageList.get(pageIndex);
        PageFormat pageFormat = new PageFormat();
        Paper paper = new Paper();
        double width = page.getWidth();
        if (width > (height = (double)page.getHeight())) {
            paper.setImageableArea(0.0, 0.0, height / 1000.0, width / 1000.0);
            paper.setSize(height / 1000.0, width / 1000.0);
            pageFormat.setOrientation(0);
        } else {
            paper.setImageableArea(0.0, 0.0, width / 1000.0, height / 1000.0);
            paper.setSize(width / 1000.0, height / 1000.0);
            pageFormat.setOrientation(1);
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.pageList.size()) {
            return 1;
        }
        Graphics2D oldGraphics = this.graphics;
        int oldPageNumber = this.pageNumber;
        this.graphics = (Graphics2D)g;
        this.graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Page aPage = (Page)this.pageList.get(pageIndex);
        this.renderPage(aPage);
        this.graphics = oldGraphics;
        return 0;
    }

    public void removePage(int page) {
        this.pageList.removeElementAt(page);
    }

    public void render(int aPageNumber) {
        if (aPageNumber >= this.pageList.size()) {
            return;
        }
        try {
            this.render((Page)this.pageList.get(aPageNumber));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void render(Page page) throws IOException {
        this.idReferences = page.getIDReferences();
        this.pageWidth = (int)((double)((float)page.getWidth() / 1000.0f) + 0.5);
        this.pageHeight = (int)((double)((float)page.getHeight() / 1000.0f) + 0.5);
        this.pageImage = new BufferedImage(this.pageWidth * (int)this.scaleFactor / 100, this.pageHeight * (int)this.scaleFactor / 100, 1);
        this.graphics = this.pageImage.createGraphics();
        this.graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.transform(this.graphics, this.scaleFactor, 0.0);
        this.drawFrame();
        this.renderPage(page);
    }

    public void render(Page page, OutputStream stream) throws IOException {
        this.pageList.add(page);
    }

    public void renderDisplaySpace(DisplaySpace space) {
        int d = space.getSize();
        this.currentYPosition -= d;
    }

    public void renderForeignObjectArea(ForeignObjectArea area) {
        area.getObject().render(this);
    }

    public void renderImageArea(ImageArea area) {
        int x = this.currentXPosition + area.getXOffset();
        int y = this.currentYPosition;
        int w = area.getContentWidth();
        int h = area.getHeight();
        this.currentYPosition -= h;
        FopImage img = area.getImage();
        if (img == null) {
            this.log.error("Error while loading image : area.getImage() is null");
            this.addRect(x, y, w, h, true);
            Font f = this.graphics.getFont();
            Font smallFont = new Font(f.getFontName(), f.getStyle(), 8);
            this.graphics.setFont(smallFont);
            this.graphics.drawString("area.getImage() is null", (x + 500) / 1000, this.pageHeight - (y + 500) / 1000);
            this.graphics.setFont(f);
        } else if (img instanceof SVGImage) {
            try {
                SVGDocument svg = ((SVGImage)img).getSVGDocument();
                this.renderSVGDocument(svg, x, y);
            }
            catch (FopImageException fopImageException) {}
        } else {
            String urlString = img.getURL();
            try {
                URL url = new URL(urlString);
                ImageIcon icon = new ImageIcon(url);
                Image image = icon.getImage();
                int startx = (x + 500) / 1000;
                int starty = this.pageHeight - (y + 500) / 1000;
                int endx = (x + w + 500) / 1000;
                int endy = this.pageHeight - (y + h + 500) / 1000;
                this.graphics.drawImage(image, startx, starty, endx - startx, starty - endy, null);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.currentXPosition += area.getContentWidth();
    }

    public void renderInlineSpace(InlineSpace space) {
        if (space.getUnderlined() || space.getOverlined() || space.getLineThrough()) {
            int rx = this.currentXPosition;
            int bl = this.currentYPosition;
            Font oldFont = this.graphics.getFont();
            if (this.lastFont != null) {
                this.graphics.setFont(this.lastFont);
            }
            Color oldColor = this.graphics.getColor();
            if (this.lastColor != null) {
                this.graphics.setColor(this.lastColor);
            }
            int width = (space.getSize() + 500) / 1000;
            this.renderTextDecoration(rx, bl, width, this.graphics.getFont(), " ", space.getUnderlined(), space.getOverlined(), space.getLineThrough());
            this.graphics.setFont(oldFont);
            this.graphics.setColor(oldColor);
        }
        this.currentXPosition += space.getSize();
    }

    public void renderLeaderArea(LeaderArea area) {
        int rx = this.currentXPosition;
        int ry = this.currentYPosition;
        int w = area.getLeaderLength();
        int h = area.getHeight();
        int th = area.getRuleThickness();
        int st = area.getRuleStyle();
        float r = area.getRed();
        float g = area.getGreen();
        float b = area.getBlue();
        Color oldColor = this.graphics.getColor();
        this.graphics.setColor(new Color(r, g, b));
        this.addRect(rx, ry, w, -th, false);
        this.graphics.setColor(oldColor);
        this.currentXPosition += area.getContentWidth();
    }

    public void renderPage(Page page) {
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.renderRegions(page);
    }

    public void renderSVGArea(SVGArea area) {
        int x = this.currentXPosition;
        int y = this.currentYPosition;
        int w = area.getContentWidth();
        int h = area.getHeight();
        Document doc = area.getSVGDocument();
        this.renderSVGDocument(doc, x, y);
        this.currentXPosition += area.getContentWidth();
    }

    protected void renderSVGDocument(Document doc, int x, int y) {
        GraphicsNode root;
        MUserAgent userAgent = new MUserAgent(new AffineTransform());
        userAgent.setLogger(this.log);
        GVTBuilder builder = new GVTBuilder();
        BridgeContext ctx = new BridgeContext(userAgent);
        try {
            root = builder.build(ctx, doc);
        }
        catch (Exception e) {
            this.log.error("svg graphic could not be built: " + e.getMessage(), e);
            return;
        }
        float w = (float)ctx.getDocumentSize().getWidth() * 1000.0f;
        float h = (float)ctx.getDocumentSize().getHeight() * 1000.0f;
        this.graphics.translate((x + 500) / 1000, this.pageHeight - (y + 500) / 1000);
        SVGSVGElement svg = ((SVGDocument)doc).getRootElement();
        AffineTransform at = ViewBox.getPreserveAspectRatioTransform(svg, w / 1000.0f, h / 1000.0f);
        AffineTransform inverse = null;
        try {
            inverse = at.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {}
        if (!at.isIdentity()) {
            this.graphics.transform(at);
        }
        try {
            root.paint(this.graphics);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (inverse != null && !inverse.isIdentity()) {
            this.graphics.transform(inverse);
        }
        this.graphics.translate(-(x + 500) / 1000, (y + 500) / 1000 - this.pageHeight);
    }

    protected void renderTextDecoration(int x, int bl, int width, Font font, String text, boolean underline, boolean overline, boolean linethrough) {
        int deltay;
        if (!(underline || overline || linethrough)) {
            return;
        }
        int newx = (x + 500) / 1000;
        int newy = this.pageHeight - (bl + 500) / 1000;
        FontMetrics fm = this.graphics.getFontMetrics(font);
        LineMetrics lm = fm.getLineMetrics(text, this.graphics);
        int ulthick = (int)lm.getUnderlineThickness();
        if (ulthick < 1) {
            ulthick = 1;
        }
        if (underline) {
            deltay = fm.getDescent() / 2;
            this.graphics.fillRect(newx, newy + deltay, width, ulthick);
        }
        if (overline) {
            deltay = -((int)((double)lm.getAscent() * 0.8));
            this.graphics.fillRect(newx, newy + deltay, width, ulthick);
        }
        if (linethrough) {
            int ltthick = (int)lm.getStrikethroughThickness();
            if (ltthick < 1) {
                ltthick = 1;
            }
            int deltay2 = (int)lm.getStrikethroughOffset();
            this.graphics.fillRect(newx, newy + deltay2, width, ltthick);
        }
    }

    public void renderWordArea(WordArea area) {
        FontMetricsMapper mapper;
        StringBuffer pdf = new StringBuffer();
        String fontname = area.getFontState().getFontName();
        int size = area.getFontState().getFontSize();
        float red = area.getRed();
        float green = area.getGreen();
        float blue = area.getBlue();
        try {
            mapper = (FontMetricsMapper)area.getFontState().getFontInfo().getMetricsFor(fontname);
        }
        catch (FOPException fOPException) {
            mapper = new FontMetricsMapper("MonoSpaced", 0, this.graphics);
        }
        if (!fontname.equals(this.currentFontName) || size != this.currentFontSize) {
            this.currentFontName = fontname;
            this.currentFontSize = size;
        }
        if (red != this.currentRed || green != this.currentGreen || blue != this.currentBlue) {
            this.currentRed = red;
            this.currentGreen = green;
            this.currentBlue = blue;
        }
        int rx = this.currentXPosition;
        int bl = this.currentYPosition;
        String s = area.getText();
        Color oldColor = this.graphics.getColor();
        Font oldFont = this.graphics.getFont();
        Font f = mapper.getFont(size);
        if (this.saveColor != null) {
            if ((float)this.saveColor.getRed() != red || (float)this.saveColor.getGreen() != green || (float)this.saveColor.getBlue() != blue) {
                this.saveColor = new Color(red, green, blue);
            }
        } else {
            this.saveColor = new Color(red, green, blue);
        }
        this.graphics.setColor(this.saveColor);
        this.graphics.setFont(f);
        int newx = (rx + 500) / 1000;
        int newy = this.pageHeight - (bl + 500) / 1000;
        this.graphics.drawString(s, newx, newy);
        FontMetrics fm = this.graphics.getFontMetrics(f);
        int tdwidth = (int)fm.getStringBounds(s, this.graphics).getWidth();
        this.renderTextDecoration(rx, bl, tdwidth, f, " ", area.getUnderlined(), area.getOverlined(), area.getLineThrough());
        this.lastFont = this.graphics.getFont();
        this.lastColor = this.graphics.getColor();
        this.graphics.setFont(oldFont);
        this.graphics.setColor(oldColor);
        this.currentXPosition += area.getContentWidth();
    }

    public void setComponent(Component parent) {
        this.parent = parent;
    }

    public void setOptions(Map options) {
        this.options = options;
    }

    public void setPageNumber(int aValue) {
        this.pageNumber = aValue;
    }

    public void setProducer(String producer) {
    }

    public void setProgressListener(ProgressListener l) {
        this.progressListener = l;
    }

    public void setScaleFactor(double newScaleFactor) {
        this.scaleFactor = newScaleFactor;
    }

    public void setupFontInfo(FontInfo fontInfo) throws FOPException {
        BufferedImage fontImage = new BufferedImage(100, 100, 1);
        FontSetup.setup(fontInfo, fontImage.createGraphics());
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        this.render(0);
    }

    public void transform(Graphics2D g2d, double zoomPercent, double angle) {
        AffineTransform at = g2d.getTransform();
        at.rotate(angle);
        at.scale(zoomPercent / 100.0, zoomPercent / 100.0);
        g2d.setTransform(at);
    }

    protected class MUserAgent
    extends SVGUserAgent {
        protected MUserAgent(AffineTransform at) {
            super(at);
        }

        public Point getClientAreaLocationOnScreen() {
            return new Point(0, 0);
        }

        public EventDispatcher getEventDispatcher() {
            return null;
        }

        public Dimension2D getViewportSize() {
            return new Dimension(100, 100);
        }

        public void openLink(SVGAElement elt) {
        }

        public void setSVGCursor(Cursor cursor) {
        }
    }
}

