/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.geom.AffineTransform;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Version;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fonts.Glyphs;
import org.apache.fop.image.EPSImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.ImageArea;
import org.apache.fop.image.JpegImage;
import org.apache.fop.image.SVGImage;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.pdf.Font;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.render.ps.ASCII85OutputStream;
import org.apache.fop.render.ps.Finalizable;
import org.apache.fop.render.ps.FlateEncodeOutputStream;
import org.apache.fop.render.ps.PSGraphics2D;
import org.apache.fop.render.ps.PSStream;
import org.apache.fop.render.ps.RunLengthEncodeOutputStream;
import org.apache.fop.svg.SVGArea;
import org.apache.fop.svg.SVGUserAgent;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class PSRenderer
extends AbstractRenderer {
    protected String producer;
    int imagecount = 0;
    int pagecount = 0;
    private boolean enableComments = true;
    private boolean autoRotateLandscape = false;
    protected PSStream out;
    private boolean ioTrouble = false;
    private String currentFontName;
    private int currentFontSize;
    private int pageHeight;
    private int pageWidth;
    private float currRed;
    private float currGreen;
    private float currBlue;
    private FontInfo fontInfo;
    private int psLevel = 3;
    protected Map options;

    protected void addFilledRect(int x, int y, int w, int h, ColorType col) {
        if (h < 0) {
            h = -h;
        }
        this.write("newpath");
        this.write(String.valueOf(x) + " " + y + " " + w + " " + -h + " re");
        this.useColor(col);
        this.write("fill");
    }

    protected void comment(String comment) {
        if (this.enableComments) {
            this.write(comment);
        }
    }

    private void defineWinAnsiEncoding() {
        this.write("/WinAnsiEncoding [");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < Glyphs.winAnsiEncoding.length) {
            char ch;
            String glyphname;
            if (i > 0) {
                if (i % 5 == 0) {
                    this.write(sb.toString());
                    sb.setLength(0);
                } else {
                    sb.append(" ");
                }
            }
            if ("".equals(glyphname = Glyphs.charToGlyphName(ch = Glyphs.winAnsiEncoding[i]))) {
                sb.append("/.notdef");
            } else {
                sb.append("/");
                sb.append(glyphname);
            }
            ++i;
        }
        this.write(sb.toString());
        this.write("] def");
    }

    protected void doFrame(Area area) {
        int rx = this.currentAreaContainerXPosition;
        int w = area.getContentWidth();
        BorderAndPadding bap = area.getBorderAndPadding();
        if (area instanceof BlockArea) {
            rx += ((BlockArea)area).getStartIndent();
        }
        int h = area.getContentHeight();
        int ry = this.currentYPosition;
        rx -= area.getPaddingLeft();
        ry += area.getPaddingTop();
        w = w + area.getPaddingLeft() + area.getPaddingRight();
        h = h + area.getPaddingTop() + area.getPaddingBottom();
        w = w + area.getBorderLeftWidth() + area.getBorderRightWidth();
        h = h + area.getBorderTopWidth() + area.getBorderBottomWidth();
        this.doBackground(area, rx -= area.getBorderLeftWidth(), ry += area.getBorderTopWidth(), w, h);
        if (area.getBorderTopWidth() != 0) {
            this.write("newpath");
            this.write(String.valueOf(rx) + " " + ry + " M");
            this.write(String.valueOf(w) + " 0 rlineto");
            this.write(String.valueOf(area.getBorderTopWidth()) + " setlinewidth");
            this.write("0 setlinecap");
            this.useColor(bap.getBorderColor(0));
            this.write("stroke");
        }
        if (area.getBorderLeftWidth() != 0) {
            this.write("newpath");
            this.write(String.valueOf(rx) + " " + ry + " M");
            this.write("0 " + -h + " rlineto");
            this.write(String.valueOf(area.getBorderLeftWidth()) + " setlinewidth");
            this.write("0 setlinecap");
            this.useColor(bap.getBorderColor(3));
            this.write("stroke");
        }
        if (area.getBorderRightWidth() != 0) {
            this.write("newpath");
            this.write(String.valueOf(rx + w) + " " + ry + " M");
            this.write("0 " + -h + " rlineto");
            this.write(String.valueOf(area.getBorderRightWidth()) + " setlinewidth");
            this.write("0 setlinecap");
            this.useColor(bap.getBorderColor(1));
            this.write("stroke");
        }
        if (area.getBorderBottomWidth() != 0) {
            this.write("newpath");
            this.write(String.valueOf(rx) + " " + (ry - h) + " M");
            this.write(String.valueOf(w) + " 0 rlineto");
            this.write(String.valueOf(area.getBorderBottomWidth()) + " setlinewidth");
            this.write("0 setlinecap");
            this.useColor(bap.getBorderColor(2));
            this.write("stroke");
        }
    }

    protected void drawImageClipped(int x, int y, int clipX, int clipY, int clipW, int clipH, FopImage image, FontState fs) {
        this.write("gsave");
        this.write(String.valueOf(clipX) + " " + clipY + " " + clipW + " " + clipH + " re");
        this.write("clippath");
        try {
            int w = image.getWidth() * 1000;
            int h = image.getHeight() * 1000;
            this.drawImageScaled(x, y, w, h, image, fs);
        }
        catch (FopImageException e) {
            this.log.error("Error getting image extents", e);
        }
        this.write("grestore");
    }

    protected void drawImageScaled(int x, int y, int w, int h, FopImage image, FontState fs) {
        if (image instanceof SVGImage) {
            try {
                this.renderSVGDocument(((SVGImage)image).getSVGDocument(), x, y, fs);
            }
            catch (FopImageException e) {
                this.log.error("Error rendering SVG image", e);
            }
        } else if (image instanceof EPSImage) {
            this.renderEPS(image, x, y, w, h);
        } else {
            this.renderBitmap(image, x, y, w, h);
        }
    }

    public int getPSLevel() {
        return this.psLevel;
    }

    public boolean isAutoRotateLandscape() {
        return this.autoRotateLandscape;
    }

    protected void movetoCurrPosition() {
        this.write(String.valueOf(this.currentXPosition) + " " + this.currentYPosition + " M");
    }

    public void render(Page page, OutputStream outputStream) {
        this.renderPage(page);
    }

    public void renderBitmap(FopImage img, int x, int y, int w, int h) {
        try {
            boolean iscolor = img.getColorSpace().getColorSpace() != 1;
            byte[] imgmap = img.getBitmaps();
            this.write("gsave");
            if (img.getColorSpace().getColorSpace() == 3) {
                this.write("/DeviceCMYK setcolorspace");
            } else if (img.getColorSpace().getColorSpace() == 1) {
                this.write("/DeviceGray setcolorspace");
            } else {
                this.write("/DeviceRGB setcolorspace");
            }
            this.write(String.valueOf(x) + " " + (y - h) + " translate");
            this.write(String.valueOf(w) + " " + h + " scale");
            this.write("{{");
            if (img instanceof JpegImage) {
                this.write("/RawData currentfile /ASCII85Decode filter def");
                this.write("/Data RawData << >> /DCTDecode filter def");
            } else if (this.psLevel >= 3) {
                this.write("/RawData currentfile /ASCII85Decode filter def");
                this.write("/Data RawData /FlateDecode filter def");
            } else {
                this.write("/RawData currentfile /ASCII85Decode filter def");
                this.write("/Data RawData /RunLengthDecode filter def");
            }
            this.write("<<");
            this.write("  /ImageType 1");
            this.write("  /Width " + img.getWidth());
            this.write("  /Height " + img.getHeight());
            this.write("  /BitsPerComponent 8");
            if (img.getColorSpace().getColorSpace() == 3) {
                if (img.invertImage()) {
                    this.write("  /Decode [1 0 1 0 1 0 1 0]");
                } else {
                    this.write("  /Decode [0 1 0 1 0 1 0 1]");
                }
            } else if (iscolor) {
                this.write("  /Decode [0 1 0 1 0 1]");
            } else {
                this.write("  /Decode [0 1]");
            }
            this.write("  /ImageMatrix [" + img.getWidth() + " 0 0 -" + img.getHeight() + " 0 " + img.getHeight() + "]");
            this.write("  /DataSource Data");
            this.write(">>");
            this.write("image");
            this.write("} stopped {handleerror} if");
            this.write("  RawData flushfile");
            this.write("} exec");
            try {
                FilterOutputStream out = this.out;
                out = new ASCII85OutputStream(out);
                if (!(img instanceof JpegImage)) {
                    out = this.psLevel >= 3 ? new FlateEncodeOutputStream(out) : new RunLengthEncodeOutputStream(out);
                }
                ((OutputStream)out).write(imgmap);
                if (out instanceof Finalizable) {
                    ((Finalizable)((Object)out)).finalizeStream();
                } else {
                    ((OutputStream)out).flush();
                }
            }
            catch (IOException e) {
                if (!this.ioTrouble) {
                    e.printStackTrace();
                }
                this.ioTrouble = true;
            }
            this.write("");
            this.write("grestore");
        }
        catch (FopImageException e) {
            this.log.error("PSRenderer.renderImageArea(): Error rendering bitmap (" + e.getMessage() + ")", e);
        }
    }

    public void renderDisplaySpace(DisplaySpace space) {
        this.currentYPosition -= space.getSize();
    }

    public void renderEPS(FopImage img, int x, int y, int w, int h) {
        try {
            EPSImage eimg = (EPSImage)img;
            int[] bbox = eimg.getBBox();
            int bboxw = bbox[2] - bbox[0];
            int bboxh = bbox[3] - bbox[1];
            this.write("%%BeginDocument: " + eimg.getDocName());
            this.write("BeginEPSF");
            this.write(String.valueOf(x) + " " + (y - h) + " translate");
            this.write("0.0 rotate");
            this.write(String.valueOf((long)(w / bboxw)) + " " + (long)(h / bboxh) + " scale");
            this.write(String.valueOf(-bbox[0]) + " " + -bbox[1] + " translate");
            this.write(String.valueOf(bbox[0]) + " " + bbox[1] + " " + bboxw + " " + bboxh + " rectclip");
            this.write("newpath");
            this.out.writeByteArr(img.getBitmaps());
            this.write("%%EndDocument");
            this.write("EndEPSF");
            this.write("");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("PSRenderer.renderImageArea(): Error rendering bitmap (" + e.getMessage() + ")", e);
        }
    }

    public void renderForeignObjectArea(ForeignObjectArea area) {
        this.currentXPosition += area.getXOffset();
        int plOffset = 0;
        Area parent = area.getParent();
        if (parent instanceof LineArea) {
            plOffset = ((LineArea)parent).getPlacementOffset();
        }
        this.currentYPosition += plOffset;
        area.getObject().render(this);
        this.currentXPosition += area.getEffectiveWidth();
        this.currentYPosition -= plOffset;
    }

    public void renderImageArea(ImageArea area) {
        int x = this.currentXPosition + area.getXOffset();
        int ploffset = 0;
        if (area.getParent() instanceof LineArea) {
            ploffset = ((LineArea)area.getParent()).getPlacementOffset();
        }
        int y = this.currentYPosition + ploffset;
        int w = area.getContentWidth();
        int h = area.getHeight();
        this.currentXPosition += w;
        FopImage img = area.getImage();
        if (img == null) {
            this.log.error("Error while loading image: area.getImage() is null");
        } else {
            this.drawImageScaled(x, y, w, h, img, area.getFontState());
        }
    }

    public void renderInlineSpace(InlineSpace space) {
        if (space.getUnderlined() || space.getLineThrough() || space.getOverlined()) {
            this.movetoCurrPosition();
            this.write("ULS");
            this.write(String.valueOf(space.getSize()) + " 0 RM");
            if (space.getUnderlined()) {
                this.write("ULE");
            }
            if (space.getLineThrough()) {
                this.write("SOE");
            }
            if (space.getOverlined()) {
                this.write("OLE");
            }
        }
        this.currentXPosition += space.getSize();
    }

    public void renderLeaderArea(LeaderArea area) {
        int rx = this.currentXPosition;
        int ry = this.currentYPosition;
        int w = area.getContentWidth();
        int th = area.getRuleThickness();
        int th2 = th / 2;
        int th3 = th / 3;
        int th4 = th / 4;
        switch (area.getLeaderPattern()) {
            case 100: {
                if (area.getRuleStyle() == 75) break;
                this.useColor(area.getRed(), area.getGreen(), area.getBlue());
                this.write("gsave");
                this.write("0 setlinecap");
                switch (area.getRuleStyle()) {
                    case 27: {
                        this.write("newpath");
                        this.write("[1000 3000] 0 setdash");
                        this.write(String.valueOf(th) + " setlinewidth");
                        this.write(String.valueOf(rx) + " " + ry + " M");
                        this.write(String.valueOf(w) + " 0 rlineto");
                        this.useColor(area.getRed(), area.getGreen(), area.getBlue());
                        this.write("stroke");
                        break;
                    }
                    case 22: {
                        this.write("newpath");
                        this.write("[3000 3000] 0 setdash");
                        this.write(String.valueOf(th) + " setlinewidth");
                        this.write(String.valueOf(rx) + " " + ry + " M");
                        this.write(String.valueOf(w) + " 0 rlineto");
                        this.useColor(area.getRed(), area.getGreen(), area.getBlue());
                        this.write("stroke");
                        break;
                    }
                    case 104: {
                        this.write("newpath");
                        this.write(String.valueOf(th) + " setlinewidth");
                        this.write(String.valueOf(rx) + " " + ry + " M");
                        this.write(String.valueOf(w) + " 0 rlineto");
                        this.useColor(area.getRed(), area.getGreen(), area.getBlue());
                        this.write("stroke");
                        break;
                    }
                    case 28: {
                        this.write("newpath");
                        this.write(String.valueOf(th3) + " setlinewidth");
                        this.write(String.valueOf(rx) + " " + (ry - th3) + " M");
                        this.write(String.valueOf(w) + " 0 rlineto");
                        this.write(String.valueOf(rx) + " " + (ry + th3) + " M");
                        this.write(String.valueOf(w) + " 0 rlineto");
                        this.useColor(area.getRed(), area.getGreen(), area.getBlue());
                        this.write("stroke");
                        break;
                    }
                    case 43: {
                        this.write(String.valueOf(th2) + " setlinewidth");
                        this.write("newpath");
                        this.write(String.valueOf(rx) + " " + (ry - th4) + " M");
                        this.write(String.valueOf(w) + " 0 rlineto");
                        this.useColor(area.getRed(), area.getGreen(), area.getBlue());
                        this.write("stroke");
                        this.write("newpath");
                        this.write(String.valueOf(rx) + " " + (ry + th4) + " M");
                        this.write(String.valueOf(w) + " 0 rlineto");
                        this.useColor(1.0f, 1.0f, 1.0f);
                        this.write("stroke");
                        break;
                    }
                    case 96: {
                        this.write(String.valueOf(th2) + " setlinewidth");
                        this.write("newpath");
                        this.write(String.valueOf(rx) + " " + (ry - th4) + " M");
                        this.write(String.valueOf(w) + " 0 rlineto");
                        this.useColor(1.0f, 1.0f, 1.0f);
                        this.write("stroke");
                        this.write("newpath");
                        this.write(String.valueOf(rx) + " " + (ry + th4) + " M");
                        this.write(String.valueOf(w) + " 0 rlineto");
                        this.useColor(area.getRed(), area.getGreen(), area.getBlue());
                        this.write("stroke");
                        break;
                    }
                }
                this.write("grestore");
                break;
            }
            case 26: {
                this.comment("% --- Leader dots NYI");
                this.log.error("Leader dots: Not yet implemented");
                break;
            }
            case 124: {
                this.comment("% --- Leader use-content NYI");
                this.log.error("Leader use-content: Not yet implemented");
                break;
            }
        }
        this.currentXPosition += area.getContentWidth();
        this.write(String.valueOf(area.getContentWidth()) + " 0 RM");
    }

    public void renderLineArea(LineArea area) {
        int rx = this.currentAreaContainerXPosition + area.getStartIndent();
        int ry = this.currentYPosition;
        int w = area.getContentWidth();
        int h = area.getHeight();
        this.currentYPosition -= area.getPlacementOffset();
        this.currentXPosition = rx;
        int bl = this.currentYPosition;
        this.movetoCurrPosition();
        String fontWeight = area.getFontState().getFontWeight();
        ArrayList children = area.getChildren();
        int i = 0;
        while (i < children.size()) {
            Box b = (Box)children.get(i);
            this.currentYPosition = ry - area.getPlacementOffset();
            b.render(this);
            ++i;
        }
        this.currentYPosition = ry - h;
        this.currentXPosition = rx;
    }

    public void renderPage(Page page) {
        ++this.pagecount;
        this.idReferences = page.getIDReferences();
        this.write("%%Page: " + page.getNumber() + " " + this.pagecount);
        long pagewidth = page.getWidth();
        long pageheight = page.getHeight();
        double pspagewidth = (float)pagewidth / 1000.0f;
        double pspageheight = (float)pageheight / 1000.0f;
        boolean rotate = false;
        if (this.isAutoRotateLandscape() && pageheight < pagewidth) {
            rotate = true;
            this.write("%%PageBoundingBox: 0 0 " + Math.round(pspageheight) + " " + Math.round(pspagewidth));
            this.write("%%PageOrientation: Landscape");
        } else {
            this.write("%%PageBoundingBox: 0 0 " + Math.round(pspagewidth) + " " + Math.round(pspageheight));
            if (this.isAutoRotateLandscape()) {
                this.write("%%PageOrientation: Portrait");
            }
        }
        this.write("%%BeginPageSetup");
        if (rotate) {
            this.write(String.valueOf(Math.round(pspageheight)) + " 0 translate");
            this.write("90 rotate");
        }
        this.write("0.001 0.001 scale");
        this.write("%%EndPageSetup");
        this.renderRegions(page);
        this.write("showpage");
        this.write("%%PageTrailer");
        this.write("%%EndPage");
    }

    public void renderSVGArea(SVGArea area) {
        int x = this.currentXPosition;
        int y = this.currentYPosition;
        this.renderSVGDocument(area.getSVGDocument(), x, y, area.getFontState());
    }

    protected void renderSVGDocument(Document doc, int x, int y, FontState fs) {
        GraphicsNode root;
        SVGUserAgent userAgent = new SVGUserAgent(new AffineTransform());
        userAgent.setLogger(this.log);
        GVTBuilder builder = new GVTBuilder();
        BridgeContext ctx = new BridgeContext(userAgent);
        try {
            root = builder.build(ctx, doc);
        }
        catch (Exception e) {
            this.log.error("svg graphic could not be built: " + e.getMessage(), e);
            return;
        }
        float w = (float)ctx.getDocumentSize().getWidth() * 1000.0f;
        float h = (float)ctx.getDocumentSize().getHeight() * 1000.0f;
        SVGSVGElement svg = ((SVGDocument)doc).getRootElement();
        AffineTransform at = ViewBox.getPreserveAspectRatioTransform(svg, w / 1000.0f, h / 1000.0f);
        ctx = null;
        builder = null;
        float sx = 1.0f;
        float sy = -1.0f;
        int xOffset = x;
        int yOffset = y;
        this.comment("% --- SVG Area");
        this.write("gsave");
        if (w != 0.0f && h != 0.0f) {
            this.write("newpath");
            this.write(String.valueOf(x) + " " + y + " M");
            this.write(String.valueOf((float)x + w) + " " + y + " rlineto");
            this.write(String.valueOf((float)x + w) + " " + ((float)y - h) + " rlineto");
            this.write(String.valueOf(x) + " " + ((float)y - h) + " rlineto");
            this.write("closepath");
            this.write("clippath");
        }
        this.write(String.valueOf(xOffset) + " " + yOffset + " translate");
        this.write(String.valueOf(at.getTranslateX() * 1000.0) + " " + -at.getTranslateY() * 1000.0 + " translate");
        this.write(String.valueOf((double)sx * at.getScaleX()) + " " + (double)sy * at.getScaleY() + " scale");
        PSGraphics2D graphics = new PSGraphics2D(false, fs, this, this.currentFontName, this.currentFontSize, this.currentXPosition, this.currentYPosition);
        graphics.setGraphicContext(new GraphicContext());
        try {
            root.paint(graphics);
        }
        catch (Exception e) {
            this.log.error("svg graphic could not be rendered: " + e.getMessage(), e);
        }
        this.write("grestore");
        this.comment("% --- SVG Area end");
    }

    public void renderWordArea(WordArea area) {
        this.movetoCurrPosition();
        FontState fs = area.getFontState();
        String fontWeight = fs.getFontWeight();
        StringBuffer sb = new StringBuffer();
        String s = area.getText();
        int l = s.length();
        int i = 0;
        while (i < l) {
            char ch = s.charAt(i);
            char mch = fs.mapChar(ch);
            if (mch > '\u007f') {
                sb = sb.append("\\" + Integer.toOctalString(mch));
            } else {
                String escape = "\\()[]{}";
                if ("\\()[]{}".indexOf(mch) >= 0) {
                    sb.append("\\");
                }
                sb = sb.append(mch);
            }
            ++i;
        }
        String psString = null;
        if (area.getFontState().getLetterSpacing() > 0) {
            float f = area.getFontState().getLetterSpacing();
            psString = f + " 0.0 (" + sb.toString() + ") A";
        } else {
            psString = "(" + sb.toString() + ") t";
        }
        this.useFont(fs.getFontName(), fs.getFontSize());
        this.useColor(area.getRed(), area.getGreen(), area.getBlue());
        if (area.getUnderlined() || area.getLineThrough() || area.getOverlined()) {
            this.write("ULS");
        }
        this.write(psString);
        if (area.getUnderlined()) {
            this.write("ULE");
        }
        if (area.getLineThrough()) {
            this.write("SOE");
        }
        if (area.getOverlined()) {
            this.write("OLE");
        }
        this.currentXPosition += area.getContentWidth();
    }

    public void setAutoRotateLandscape(boolean value) {
        this.autoRotateLandscape = value;
    }

    public void setOptions(Map options) {
        this.options = options;
    }

    public void setPSLevel(int level) {
        switch (level) {
            case 2: 
            case 3: {
                this.psLevel = level;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only PostScript Levels 2 and 3 are supported");
            }
        }
    }

    public void setProducer(String producer) {
        this.producer = producer;
    }

    public void setupFontInfo(FontInfo fontInfo) throws FOPException {
        FontSetup.setup(fontInfo);
        this.fontInfo = fontInfo;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.log.debug("rendering areas to PostScript");
        this.pagecount = 0;
        this.out = new PSStream(outputStream);
        this.write("%!PS-Adobe-3.0");
        if (this.producer == null) {
            this.producer = Version.getVersion();
        }
        this.write("%%Creator: " + this.producer);
        this.write("%%Pages: (atend)");
        this.write("%%DocumentProcessColors: Black");
        this.write("%%DocumentSuppliedResources: procset FOPFonts");
        this.write("%%EndComments");
        this.write("%%BeginDefaults");
        this.write("%%EndDefaults");
        this.write("%%BeginProlog");
        this.write("%%EndProlog");
        this.write("%%BeginSetup");
        this.writeProcs();
        this.writeFontDict(this.fontInfo);
        this.write("%%BeginResource: procset EPSprocs");
        this.write("%%Title: EPS encapsulation procs");
        this.write("/BeginEPSF { %def");
        this.write("/b4_Inc_state save def         % Save state for cleanup");
        this.write("/dict_count countdictstack def % Count objects on dict stack");
        this.write("/op_count count 1 sub def      % Count objects on operand stack");
        this.write("userdict begin                 % Push userdict on dict stack");
        this.write("/showpage { } def              % Redefine showpage, { } = null proc");
        this.write("0 setgray 0 setlinecap         % Prepare graphics state");
        this.write("1 setlinewidth 0 setlinejoin");
        this.write("10 setmiterlimit [ ] 0 setdash newpath");
        this.write("/languagelevel where           % If level not equal to 1 then");
        this.write("{pop languagelevel             % set strokeadjust and");
        this.write("1 ne                           % overprint to their defaults.");
        this.write("{false setstrokeadjust false setoverprint");
        this.write("} if");
        this.write("} if");
        this.write("} bind def");
        this.write("/EndEPSF { %def");
        this.write("count op_count sub {pop} repeat            % Clean up stacks");
        this.write("countdictstack dict_count sub {end} repeat");
        this.write("b4_Inc_state restore");
        this.write("} bind def");
        this.write("%%EndResource");
        this.write("FOPprocs begin");
        this.write("FOPFonts begin");
        this.write("%%EndSetup");
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        this.write("%%Trailer");
        this.write("%%Pages: " + this.pagecount);
        this.write("%%EOF");
        this.out.flush();
        this.log.debug("written out PostScript");
    }

    private void useColor(float red, float green, float blue) {
        if (red != this.currRed || green != this.currGreen || blue != this.currBlue) {
            this.write(String.valueOf(red) + " " + green + " " + blue + " setrgbcolor");
            this.currRed = red;
            this.currGreen = green;
            this.currBlue = blue;
        }
    }

    private void useColor(ColorType col) {
        this.useColor(col.red(), col.green(), col.blue());
    }

    public void useFont(String name, int size) {
        if (this.currentFontName != name || this.currentFontSize != size) {
            this.write(String.valueOf(name) + " " + size + " F");
            this.currentFontName = name;
            this.currentFontSize = size;
        }
    }

    protected void write(String cmd) {
        try {
            this.out.write(cmd);
        }
        catch (IOException e) {
            if (!this.ioTrouble) {
                e.printStackTrace();
            }
            this.ioTrouble = true;
        }
    }

    protected void writeFontDict(FontInfo fontInfo) {
        Font fm;
        String key;
        this.write("%%BeginResource: procset FOPFonts");
        this.write("%%Title: Font setup (shortcuts) for this file");
        this.write("/FOPFonts 100 dict dup begin");
        HashMap fonts = fontInfo.getFonts();
        Iterator iterator = fonts.keySet().iterator();
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            fm = (Font)fonts.get(key);
            this.write("/" + key + " /" + fm.fontName() + " def");
        }
        this.write("end def");
        this.write("%%EndResource");
        this.defineWinAnsiEncoding();
        iterator = fonts.keySet().iterator();
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            fm = (Font)fonts.get(key);
            if (fm.encoding() == null) continue;
            if ("WinAnsiEncoding".equals(fm.encoding())) {
                this.write("/" + fm.fontName() + " findfont");
                this.write("dup length dict begin");
                this.write("  {1 index /FID ne {def} {pop pop} ifelse} forall");
                this.write("  /Encoding " + fm.encoding() + " def");
                this.write("  currentdict");
                this.write("end");
                this.write("/" + fm.fontName() + " exch definefont pop");
                continue;
            }
            this.log.warn("Only WinAnsiEncoding is supported. Font '" + fm.fontName() + "' asks for: " + fm.encoding());
        }
    }

    protected void writeProcs() {
        this.write("%%BeginResource: procset FOPprocs");
        this.write("%%Title: Utility procedures");
        this.write("/FOPprocs 20 dict dup begin");
        this.write("/bd{bind def}bind def");
        this.write("/ld{load def}bd");
        this.write("/M/moveto ld");
        this.write("/RM/rmoveto ld");
        this.write("/t/show ld");
        this.write("/A/ashow ld");
        this.write("/cp/closepath ld");
        this.write("/re {4 2 roll M");
        this.write("1 index 0 rlineto");
        this.write("0 exch rlineto");
        this.write("neg 0 rlineto");
        this.write("cp } bd");
        this.write("/ux 0.0 def");
        this.write("/uy 0.0 def");
        this.write("/F {");
        this.write("  /Tp exch def");
        this.write("  /Tf exch def");
        this.write("  Tf findfont Tp scalefont setfont");
        this.write("  /cf Tf def  /cs Tp def  /cw ( ) stringwidth pop def");
        this.write("} bd");
        this.write("/ULS {currentpoint /uy exch def /ux exch def} bd");
        this.write("/ULE {");
        this.write("  /Tcx currentpoint pop def");
        this.write("  gsave");
        this.write("  newpath");
        this.write("  cf findfont cs scalefont dup");
        this.write("  /FontMatrix get 0 get /Ts exch def /FontInfo get dup");
        this.write("  /UnderlinePosition get Ts mul /To exch def");
        this.write("  /UnderlineThickness get Ts mul /Tt exch def");
        this.write("  ux uy To add moveto  Tcx uy To add lineto");
        this.write("  Tt setlinewidth stroke");
        this.write("  grestore");
        this.write("} bd");
        this.write("/OLE {");
        this.write("  /Tcx currentpoint pop def");
        this.write("  gsave");
        this.write("  newpath");
        this.write("  cf findfont cs scalefont dup");
        this.write("  /FontMatrix get 0 get /Ts exch def /FontInfo get dup");
        this.write("  /UnderlinePosition get Ts mul /To exch def");
        this.write("  /UnderlineThickness get Ts mul /Tt exch def");
        this.write("  ux uy To add cs add moveto Tcx uy To add cs add lineto");
        this.write("  Tt setlinewidth stroke");
        this.write("  grestore");
        this.write("} bd");
        this.write("/SOE {");
        this.write("  /Tcx currentpoint pop def");
        this.write("  gsave");
        this.write("  newpath");
        this.write("  cf findfont cs scalefont dup");
        this.write("  /FontMatrix get 0 get /Ts exch def /FontInfo get dup");
        this.write("  /UnderlinePosition get Ts mul /To exch def");
        this.write("  /UnderlineThickness get Ts mul /Tt exch def");
        this.write("  ux uy To add cs 10 mul 26 idiv add moveto Tcx uy To add cs 10 mul 26 idiv add lineto");
        this.write("  Tt setlinewidth stroke");
        this.write("  grestore");
        this.write("} bd");
        this.write("end def");
        this.write("%%EndResource");
    }
}

