/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.tagging;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.binding.vmodl.fault.SystemError;
import com.vmware.vim.query.client.AuthenticationStrategy;
import com.vmware.vim.query.client.Client;
import com.vmware.vim.query.client.ClientFactory;
import com.vmware.vim.query.client.exception.ClientException;
import com.vmware.vim.query.client.impl.ClientFactoryImpl;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.client.exception.TransportProtocolException;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.exception.CertificateValidationException;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.ServiceEndpointType;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vmomi.vc.VcAwareSharedHttpConfigPool;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vsphere.client.tagging.Util;
import com.vmware.vsphere.client.tagging.exception.AuthenticationException;
import com.vmware.vsphere.client.tagging.exception.HostConnectException;
import com.vmware.vsphere.client.tagging.impl.TagServiceImpl;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import org.apache.http.conn.HttpHostConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryClientManager {
    private static final Logger _logger = LoggerFactory.getLogger(QueryClientManager.class);
    private final VcAwareSharedHttpConfigPool _httpConfigPool;
    private final ClientFactory _clientFactory = new ClientFactoryImpl();
    private final SsoService _ssoService;

    public QueryClientManager(SsoService ssoService, VcAwareSharedHttpConfigPool httpConfigPool) {
        this._ssoService = ssoService;
        this._httpConfigPool = httpConfigPool;
    }

    public Client createClient(VcService service) throws HostConnectException, AuthenticationException {
        ServiceEndpointEx serviceEndpoint = this.getInventoryServiceEndpoint(service);
        String searchUrl = this.getSearchUrl((ServiceDirectory.ServiceEndpoint)serviceEndpoint, service);
        SamlToken ssoToken = AuthSessionUtil.getSsoToken((SsoDomain)service.getSsoDomain());
        PrivateKey clientPrivateKey = this._ssoService.getHokPrivateKey();
        Client endpoint = this.createClientWithRetry((ServiceDirectory.ServiceEndpoint)serviceEndpoint, searchUrl, ssoToken, clientPrivateKey);
        return endpoint;
    }

    public void closeClient(Client client, VcService vcService) throws IllegalArgumentException, CompositeException {
        if (client == null || vcService == null) {
            throw new IllegalArgumentException("The passed client or vcService is null");
        }
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        ServiceEndpointEx serviceEndpoint = this.getInventoryServiceEndpoint(vcService);
        try {
            if (client.getAuthenticationManager() != null) {
                client.getAuthenticationManager().logout();
            }
        }
        catch (Exception e) {
            _logger.error("Error logging out of " + (serviceEndpoint == null ? "???" : serviceEndpoint.getUrl()), (Throwable)e);
            exceptionList.add(e);
        }
        try {
            client.close();
        }
        catch (Exception e) {
            _logger.error("Error while trying to close client: ", (Throwable)e);
            exceptionList.add(e);
        }
        try {
            this._httpConfigPool.releaseHttpConfig((ServiceDirectory.ServiceEndpoint)serviceEndpoint, false);
        }
        catch (Exception e) {
            _logger.error("Error releasing the client http configuration ", (Throwable)e);
            exceptionList.add(e);
        }
        if (exceptionList.size() != 0) {
            throw new CompositeException(exceptionList);
        }
    }

    private ServiceEndpointEx getInventoryServiceEndpoint(VcService service) {
        String vcGuid = service.getServiceGuid();
        for (ServiceEndpointEx endpoint : service.getServiceEndPoints()) {
            String endpointVcGuid;
            ServiceEndpointType endpointType = endpoint.getServiceEndpointType();
            if (endpointType != ServiceEndpointType.IS || !vcGuid.equals(endpointVcGuid = endpoint.getVcGuid())) continue;
            return endpoint;
        }
        throw MixedUtil.getRuntimeFault((String)"inventory-service-endpoint-not-found-error");
    }

    private String getSearchUrl(ServiceDirectory.ServiceEndpoint endpoint, VcService vcService) {
        String urlStr = endpoint.getUrl();
        URI qsUri = null;
        try {
            qsUri = new URI(urlStr);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (qsUri == null) {
            return urlStr;
        }
        try {
            InetAddress.getByName(qsUri.getHost());
            return urlStr;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SecurityException e) {
            return urlStr;
        }
        String serviceURL = null;
        if (vcService != null) {
            serviceURL = vcService.getServiceUrl();
        }
        try {
            URI serviceURI = new URI(serviceURL);
            String serviceHost = serviceURI.getHost();
            String qsHost = qsUri.getHost();
            urlStr = urlStr.replaceFirst(qsHost, serviceHost);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return urlStr;
    }

    private Client createClientWithRetry(ServiceDirectory.ServiceEndpoint serviceEndpoint, String searchUrl, SamlToken ssoToken, PrivateKey clientPrivateKey) throws AuthenticationException, HostConnectException {
        try {
            Client client = this.createClientForEndpoint(serviceEndpoint, searchUrl, ssoToken, clientPrivateKey);
            return client;
        }
        catch (CertificateValidationException e) {
            URI uri = URI.create(searchUrl);
            String errMsg = Util.formatLogMessage(uri.toString(), "Query service threw a CertificateValidationException, seems like its thumbprint has changed. New thumbprint: %1$s.", e.getThumbprint());
            _logger.error(errMsg, (Throwable)e);
            try {
                ServiceDirectory.ServiceEndpoint newEndpoint = VcServiceUtil.fetchServiceEndpoint((String)serviceEndpoint.instanceUuid);
                this._httpConfigPool.updateThumbprint(newEndpoint);
                Client client = this.createClientForEndpoint(newEndpoint, searchUrl, ssoToken, clientPrivateKey);
                return client;
            }
            catch (Exception ex) {
                _logger.error("Retrying to create the query client failed: ", (Throwable)ex);
                throw new AuthenticationException("Unable to create query client: ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Client createClientForEndpoint(ServiceDirectory.ServiceEndpoint serviceEndpoint, String searchUrl, SamlToken ssoToken, PrivateKey clientPrivateKey) throws AuthenticationException, HostConnectException, CertificateValidationException {
        if (ssoToken == null) {
            String msg = "No SAML token found. Cannot login to Inventory Service " + searchUrl;
            _logger.error(msg);
            throw new AuthenticationException("The provided SAML token is null.");
        }
        Thread currThread = Thread.currentThread();
        ClassLoader originalClassLoader = currThread.getContextClassLoader();
        currThread.setContextClassLoader(TagServiceImpl.class.getClassLoader());
        try {
            URI uri = URI.create(searchUrl);
            String uriStr = uri.toString();
            HttpConfiguration config = this._httpConfigPool.getHttpConfig(serviceEndpoint);
            HttpClientConfiguration clientConfig = HttpClientConfiguration.Factory.newInstance();
            clientConfig.setHttpConfiguration(config);
            TaggingServiceAutenticationStrategy authStrategy = new TaggingServiceAutenticationStrategy();
            ClientFactoryConfiguration clientFactoryConfig = new ClientFactoryConfiguration(clientConfig, authStrategy);
            String sessionInfo = SessionUtil.getSessionInfo();
            _logger.info("Creating a Query Client... " + searchUrl + " (" + sessionInfo + ")");
            Client client = this._clientFactory.createClient(uri, (ClientFactory.Configuration)clientFactoryConfig);
            try {
                this.loginBySamlToken(searchUrl, ssoToken, clientPrivateKey, client);
                _logger.info(Util.formatLogMessage(uriStr, "Login request succeeded.", new Object[0]));
            }
            catch (ClientException e) {
                client.close();
                this._httpConfigPool.releaseHttpConfig(serviceEndpoint, false);
                this.translateClientException(e, uriStr, ssoToken);
            }
            catch (RuntimeException e) {
                client.close();
                this._httpConfigPool.releaseHttpConfig(serviceEndpoint, false);
                if (e instanceof SystemError) {
                    throw new AuthenticationException("Cannot login to " + uri.toString(), e);
                }
                throw e;
            }
            _logger.info("Done creating the Query Client (" + sessionInfo + ", identity " + Integer.toHexString(System.identityHashCode(client)) + ")");
            Client client2 = client;
            return client2;
        }
        finally {
            currThread.setContextClassLoader(originalClassLoader);
        }
    }

    private void translateClientException(ClientException e, String uri, SamlToken authnToken) throws HostConnectException, CertificateValidationException, AuthenticationException {
        Throwable cause = e.getCause();
        if (cause instanceof ExecutionException && cause.getCause() != null) {
            cause = ((ExecutionException)cause).getCause();
        }
        if (cause instanceof ConnectionException || cause instanceof HttpHostConnectException || cause instanceof SocketException || cause instanceof TransportProtocolException || Util.isServiceUnavailable(cause)) {
            throw new HostConnectException(uri, cause);
        }
        String sessionInfo = "(" + SessionUtil.getSessionInfo() + ")";
        if (cause instanceof SslException || cause instanceof CertificateValidationException) {
            if (cause instanceof SslException && cause.getCause() instanceof CertificateValidationException) {
                cause = cause.getCause();
            }
            if (cause instanceof CertificateValidationException) {
                CertificateValidationException cve = (CertificateValidationException)cause;
                throw cve;
            }
            _logger.error(Util.formatLogMessage(uri, "Invalid certificate. " + sessionInfo, new Object[0]), cause);
            throw new HostConnectException(uri, cause);
        }
        if (cause instanceof SecurityError) {
            _logger.info("[Server: {}] SecurityError in login request {}. Login token: subject = {} ; renewable = {} ; expiration time = {}", new Object[]{uri, sessionInfo, authnToken.getSubject(), authnToken.isRenewable(), authnToken.getExpirationTime()});
        } else {
            _logger.warn(Util.formatLogMessage(uri, "Error in login request. " + sessionInfo, new Object[0]), (Throwable)e);
        }
        throw new AuthenticationException("Cannot login to " + uri, cause);
    }

    private void loginBySamlToken(String searchUrl, SamlToken ssoToken, PrivateKey clientPrivateKey, Client client) throws ClientException {
        if (_logger.isInfoEnabled()) {
            URI uri = URI.create(searchUrl);
            _logger.info(Util.formatLogMessage(uri.toString(), "Logging in using SAML token. Token expiration time: " + ssoToken.getExpirationTime(), new Object[0]));
        }
        try {
            client.getAuthenticationManager().loginBySamlToken(ssoToken, clientPrivateKey);
        }
        catch (TransportProtocolException e) {
            _logger.warn("Unable to login to: " + searchUrl + ", retrying.");
            client.getAuthenticationManager().loginBySamlToken(ssoToken, clientPrivateKey);
        }
    }

    private class TaggingServiceAutenticationStrategy
    implements AuthenticationStrategy {
        private static final int MAX_LOGIN_ATTEMPTS = 3;

        private TaggingServiceAutenticationStrategy() {
        }

        public void login(Client client) {
            try {
                client.getAuthenticationManager().loginBySamlToken(AuthSessionUtil.getSsoToken(), QueryClientManager.this._ssoService.getHokPrivateKey());
            }
            catch (Exception e) {
                _logger.error("The tagging service query client's attempt to re-login was unsuccessful.", (Throwable)e);
            }
        }

        public int getMaxLoginAttempts() {
            return 3;
        }
    }

    private static class ClientFactoryConfiguration
    implements ClientFactory.Configuration {
        private final HttpClientConfiguration _httpClientConfig;
        private final AuthenticationStrategy _authStrategy;

        public ClientFactoryConfiguration(HttpClientConfiguration httpClientConfig, AuthenticationStrategy strategy) {
            ValidationUtil.paramsNotNull((Object[])new Object[]{httpClientConfig});
            this._httpClientConfig = httpClientConfig;
            this._authStrategy = strategy;
        }

        public HttpClientConfiguration getClientConfig() {
            return this._httpClientConfig;
        }

        public Class<?> getVersion() {
            return null;
        }

        public AuthenticationStrategy getAuthenticationStrategy() {
            return this._authStrategy;
        }
    }
}

