/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.tagging.impl;

import com.vmware.vim.binding.dataservice.fault.AlreadyExistsFault;
import com.vmware.vim.binding.dataservice.fault.InvalidTagAssociationFault;
import com.vmware.vim.binding.dataservice.tagging.TagInfo;
import com.vmware.vim.binding.dataservice.tagging.TagManager;
import com.vmware.vim.binding.impl.dataservice.tagging.TagInfoImpl;
import com.vmware.vim.binding.vmodl.DynamicData;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.tagging.TagAttachSpec;
import com.vmware.vsphere.client.tagging.TagCreateSpec;
import com.vmware.vsphere.client.tagging.TagDetachSpec;
import com.vmware.vsphere.client.tagging.TagService;
import com.vmware.vsphere.client.tagging.TagServiceLocator;
import com.vmware.vsphere.client.tagging.Util;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TagMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(TagMutationProvider.class);
    private static final int RETRY_COUNT = 20;
    private static final long RETRY_INTERVAL = 5000L;
    private final DataService _dataService;
    private final TagServiceLocator _tagServiceLocator;
    private final ObjectReferenceService _objRefService;

    public TagMutationProvider(DataService dataService, ObjectReferenceService objRefService, TagServiceLocator tagServiceLocator) {
        this._dataService = dataService;
        this._objRefService = objRefService;
        this._tagServiceLocator = tagServiceLocator;
    }

    public OperationResult add(TagCreateSpec spec) {
        return this.addMulti(new TagCreateSpec[]{spec})[0];
    }

    public OperationResult[] addMulti(TagCreateSpec[] specs) {
        Util.checkNotNull(specs, "specs");
        if (specs.length == 0) {
            return new OperationResult[0];
        }
        LinkedList<OperationResult> results = new LinkedList<OperationResult>();
        List<TagCreateSpec> specsList = Arrays.asList(specs);
        ArrayList<TagCreateSpec> retrySpecs = new ArrayList<TagCreateSpec>();
        int retryCount = 20;
        try {
            while (retryCount-- > 0) {
                for (TagCreateSpec spec : specsList) {
                    OperationResult r;
                    try {
                        TagService service = this._tagServiceLocator.getTagService(null);
                        r = new OperationResult();
                        ManagedObjectReference moRef = this.createTag(service, spec);
                        r.entity = r.result = moRef;
                        results.add(r);
                        if (spec.attachSpec == null) continue;
                        this.apply(moRef, spec.attachSpec);
                        r.effect = new OperationEffect();
                        r.effect.affectedEntites = spec.attachSpec.resources;
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof ManagedObjectNotFound && retryCount > 0) {
                            retrySpecs.add(spec);
                            continue;
                        }
                        _logger.error((Object)"An error occurred while creating tags", (Throwable)e);
                        r = new OperationResult();
                        r.error = e.getCause() instanceof InvalidArgument ? MixedUtil.getRuntimeFault((String)Util.getLocalizedString("error.invalidNameInput")) : (e.getCause() instanceof AlreadyExistsFault ? MixedUtil.getRuntimeFault((String)Util.getLocalizedString("tag.create.form.error.tag.duplicate")) : MixedUtil.getMethodFault((Throwable)e));
                        results.add(r);
                    }
                }
                if (retrySpecs.size() != 0) {
                    specsList = retrySpecs;
                    retrySpecs = new ArrayList();
                    Thread.sleep(5000L);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException ex) {
            _logger.error((Object)ex);
        }
        return results.toArray(new OperationResult[results.size()]);
    }

    public OperationResult apply(ManagedObjectReference moRef, TagCreateSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = moRef;
        try {
            Util.checkNotNull(moRef, "moRef");
            Util.checkNotNull((Object)spec, "spec");
            TagService service = this._tagServiceLocator.getTagService(null);
            TagInfoImpl info = new TagInfoImpl();
            info.setName(spec.tagName);
            info.setDescription(spec.tagDescription);
            service.updateTag(moRef, (TagInfo)info);
        }
        catch (Exception e) {
            _logger.error((Object)"An error occurred while updating tag details", (Throwable)e);
            result.error = e.getCause() instanceof AlreadyExistsFault ? MixedUtil.getRuntimeFault((String)Util.getLocalizedString("tag.create.form.error.tag.duplicate")) : MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference tagRef, TagAttachSpec spec) {
        OperationResult result = new OperationResult();
        int retryCount = 20;
        try {
            Util.checkNotNull(spec, "spec");
            Util.checkNotNull(spec.resources, "spec.resources");
            result.entity = spec.resources[0];
            if (spec.resources.length > 1) {
                result.effect = new OperationEffect();
                result.effect.affectedEntites = Arrays.copyOfRange(spec.resources, 1, spec.resources.length);
            }
            Map<String, List<URI>> objectServerGuidToUri = this.getObjectServerGuidToUriMap(spec.resources);
            HashMap<String, List<URI>> retryObjects = new HashMap<String, List<URI>>();
            ArrayList<Exception> allExceptions = new ArrayList<Exception>();
            while (retryCount-- > 0) {
                for (Map.Entry<String, List<URI>> entry : objectServerGuidToUri.entrySet()) {
                    String serverGuid = entry.getKey();
                    List<URI> uris = entry.getValue();
                    TagService service = this._tagServiceLocator.getTagService(serverGuid);
                    TagManager.AttachTagsResult[] attachResults = service.attachTags(new ManagedObjectReference[]{tagRef}, uris.toArray(new URI[uris.size()]));
                    List<Exception> errors = this.extractErrors((DynamicData[])attachResults);
                    if (retryCount > 0 && TagMutationProvider.failedWithManagedObjectNotFound(errors)) {
                        retryObjects.put(serverGuid, uris);
                        continue;
                    }
                    allExceptions.addAll(errors);
                }
                if (retryObjects.size() == 0) break;
                objectServerGuidToUri = retryObjects;
                retryObjects = new HashMap();
                Thread.sleep(5000L);
            }
            this.setErrors(result, allExceptions);
        }
        catch (Exception e) {
            _logger.error((Object)"An error occurred while attaching tags", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    static boolean failedWithManagedObjectNotFound(List<Exception> errors) {
        for (Exception error : errors) {
            if (!(error instanceof ManagedObjectNotFound)) continue;
            return true;
        }
        return false;
    }

    public OperationResult apply(ManagedObjectReference moRef, TagDetachSpec spec) {
        OperationResult result = new OperationResult();
        try {
            Util.checkNotNull(spec, "spec");
            Util.checkNotNull(spec.resources, "spec.resources");
            result.entity = spec.resources[0];
            if (spec.resources.length > 1) {
                result.effect = new OperationEffect();
                result.effect.affectedEntites = Arrays.copyOfRange(spec.resources, 1, spec.resources.length);
            }
            Map<String, List<URI>> objectServerGuidToUri = this.getObjectServerGuidToUriMap(spec.resources);
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            for (Map.Entry<String, List<URI>> entry : objectServerGuidToUri.entrySet()) {
                String serverGuid = entry.getKey();
                List<URI> uris = entry.getValue();
                TagService service = this._tagServiceLocator.getTagService(serverGuid);
                TagManager.DetachTagsResult[] detachResults = service.detachTags(new ManagedObjectReference[]{moRef}, uris.toArray(new URI[uris.size()]));
                exceptions.addAll(this.extractErrors((DynamicData[])detachResults));
            }
            this.setErrors(result, exceptions);
        }
        catch (Exception e) {
            _logger.error((Object)"An error occurred while detaching tags", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult remove(ManagedObjectReference moRef, TagCreateSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = moRef;
        try {
            Util.checkNotNull(moRef, "moRef");
            TagService service = this._tagServiceLocator.getTagService(null);
            service.deleteTag(moRef);
        }
        catch (Exception e) {
            _logger.error((Object)"An error occurred while deleting a tag", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    private ManagedObjectReference createTag(TagService service, TagCreateSpec spec) throws InterruptedException, ExecutionException {
        TagInfoImpl info = new TagInfoImpl();
        info.setName(spec.tagName);
        info.setDescription(spec.tagDescription);
        return service.createTag(spec.categoryMoRef, (TagInfo)info);
    }

    private List<Exception> extractErrors(DynamicData[] tagResults) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        if (tagResults == null) {
            return exceptions;
        }
        for (int i = 0; i < tagResults.length; ++i) {
            Exception ex = this.getError(tagResults[i]);
            if (ex == null) continue;
            exceptions.add(ex);
        }
        return exceptions;
    }

    private Exception getError(DynamicData result) {
        if (result instanceof TagManager.AttachTagsResult) {
            Exception ex = ((TagManager.AttachTagsResult)result).getError();
            if (ex instanceof InvalidTagAssociationFault) {
                MethodFault fault = new MethodFault();
                fault.setMessage(Util.getLocalizedString("error.unableToAttachTag"));
                ex = fault;
            }
            return ex;
        }
        if (result instanceof TagManager.DetachTagsResult) {
            return ((TagManager.DetachTagsResult)result).getError();
        }
        return null;
    }

    private void setErrors(OperationResult opResult, List<Exception> exceptions) {
        if (!exceptions.isEmpty()) {
            Object error = exceptions.size() == 1 ? exceptions.get(0) : new CompositeException(exceptions);
            opResult.error = MixedUtil.getMethodFault((Throwable)error);
        }
    }

    private Map<String, List<URI>> getObjectServerGuidToUriMap(Object[] resources) throws Exception {
        HashMap<String, List<URI>> urisByGuid = new HashMap<String, List<URI>>();
        for (Object resource : resources) {
            URI uri = Util.toURI(resource);
            String objectServerGuid = this._objRefService.getServerGuid(resource);
            if (StringUtil.isNullOrEmpty((String)objectServerGuid)) {
                _logger.warn((Object)"Assigning tags to objects which are not managed object references is not supported.");
                objectServerGuid = "GLOBAL";
            }
            if (!urisByGuid.containsKey(objectServerGuid)) {
                urisByGuid.put(objectServerGuid, new ArrayList());
            }
            List uriList = (List)urisByGuid.get(objectServerGuid);
            uriList.add(uri);
        }
        return urisByGuid;
    }
}

