/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.tagging.impl;

import com.vmware.vim.binding.dataservice.tagging.Category;
import com.vmware.vim.binding.dataservice.tagging.CategoryInfo;
import com.vmware.vim.binding.dataservice.tagging.Tag;
import com.vmware.vim.binding.dataservice.tagging.TagInfo;
import com.vmware.vim.binding.dataservice.tagging.TagManager;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.query.client.Client;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vise.vim.commons.vmomi.VmomiClientHelper;
import com.vmware.vsphere.client.tagging.TagService;
import java.net.URI;
import java.util.concurrent.ExecutionException;

public class TagServiceImpl
implements TagService {
    private final Client _queryClient;

    TagServiceImpl(Client queryClient) {
        this._queryClient = queryClient;
    }

    @Override
    public ManagedObjectReference createTag(ManagedObjectReference category, TagInfo info) throws InterruptedException, ExecutionException {
        Category cat = this.createStub(Category.class, category);
        BlockingFuture f = new BlockingFuture();
        cat.createTag(info, (Future)f);
        return (ManagedObjectReference)f.get();
    }

    @Override
    public ManagedObjectReference createCategory(CategoryInfo info) throws InterruptedException, ExecutionException {
        BlockingFuture f = new BlockingFuture();
        this.getTagManager().createCategory(info, (Future)f);
        return (ManagedObjectReference)f.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TagManager getTagManager() {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            TagManager tagManager;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            TagManager tagManager2 = tagManager = this._queryClient.getTagManager();
            return tagManager2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public void updateCategory(ManagedObjectReference categoryRef, CategoryInfo info) throws InterruptedException, ExecutionException {
        Category c = this.createStub(Category.class, categoryRef);
        BlockingFuture f = new BlockingFuture();
        c.updateInfo(info, (Future)f);
        f.get();
    }

    @Override
    public TagManager.AttachTagsResult[] attachTags(ManagedObjectReference[] tagRefs, URI[] uris) throws InterruptedException, ExecutionException {
        BlockingFuture f = new BlockingFuture();
        this.getTagManager().bulkAttachTags(uris, tagRefs, (Future)f);
        TagManager.AttachTagsResult[] result = (TagManager.AttachTagsResult[])f.get();
        return result;
    }

    @Override
    public TagManager.DetachTagsResult[] detachTags(ManagedObjectReference[] tagRefs, URI[] uris) throws InterruptedException, ExecutionException {
        BlockingFuture f = new BlockingFuture();
        this.getTagManager().bulkDetachTags(uris, tagRefs, (Future)f);
        TagManager.DetachTagsResult[] result = (TagManager.DetachTagsResult[])f.get();
        return result;
    }

    @Override
    public void updateTag(ManagedObjectReference tagRef, TagInfo info) throws InterruptedException, ExecutionException {
        Tag t = this.createStub(Tag.class, tagRef);
        BlockingFuture f = new BlockingFuture();
        t.updateInfo(info, (Future)f);
        f.get();
    }

    @Override
    public void deleteTag(ManagedObjectReference tagRef) throws InterruptedException, ExecutionException {
        Tag t = this.createStub(Tag.class, tagRef);
        BlockingFuture f = new BlockingFuture();
        t.delete((Future)f);
        f.get();
    }

    @Override
    public void deleteCategory(ManagedObjectReference categoryRef) throws InterruptedException, ExecutionException {
        Category c = this.createStub(Category.class, categoryRef);
        BlockingFuture f = new BlockingFuture();
        c.delete((Future)f);
        f.get();
    }

    private <T extends ManagedObject> T createStub(Class<T> clazz, ManagedObjectReference moRef) {
        ManagedObject t = VmomiClientHelper.createStub((com.vmware.vim.vmomi.client.Client)this._queryClient.getVmomiClient(), clazz, (ManagedObjectReference)moRef, (ClassLoader)this.getClass().getClassLoader());
        return (T)t;
    }
}

