/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.tagging.impl;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.query.client.Client;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vsphere.client.tagging.QueryClientManager;
import com.vmware.vsphere.client.tagging.TagService;
import com.vmware.vsphere.client.tagging.TagServiceLocator;
import com.vmware.vsphere.client.tagging.Util;
import com.vmware.vsphere.client.tagging.exception.AuthenticationException;
import com.vmware.vsphere.client.tagging.exception.HostConnectException;
import com.vmware.vsphere.client.tagging.impl.TagServiceImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TagServiceLocatorImpl
implements TagServiceLocator,
UserSessionListener {
    private static final Log _logger = LogFactory.getLog(TagServiceLocatorImpl.class);
    private static final String QUERY_CLIENT_PER_VC_SERVICE_MAP = "TaggingServiceLocator.queryClientPerVcMap";
    private final QueryClientManager _clientManager;
    private final LookupService _lookupService;
    private volatile String _serverGuidForTagging;

    public TagServiceLocatorImpl(QueryClientManager queryClientFactory, LookupService lookupService) {
        this._clientManager = queryClientFactory;
        this._lookupService = lookupService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagService getTagService(String serviceUuid) throws Exception {
        if (serviceUuid == null || "GLOBAL".equals(serviceUuid)) {
            String serverGuidForTaggingHelper = this._serverGuidForTagging;
            if (serverGuidForTaggingHelper == null) {
                TagServiceLocatorImpl tagServiceLocatorImpl = this;
                synchronized (tagServiceLocatorImpl) {
                    serverGuidForTaggingHelper = this._serverGuidForTagging;
                    if (serverGuidForTaggingHelper == null) {
                        this._serverGuidForTagging = serverGuidForTaggingHelper = this.chooseVcForTaggingOperations();
                    }
                }
            }
            serviceUuid = serverGuidForTaggingHelper;
        }
        if (serviceUuid == null) {
            LinkedVcGroupRegistry registry = VimSessionUtil.getLinkedVcGroupRegistry();
            LinkedVcGroup[] groups = registry.getUtils().getStartupLinkedVcGroups();
            serviceUuid = groups[0].getStartUpVcService().getServiceGuid();
            if (groups.length > 1) {
                for (LinkedVcGroup group : groups) {
                    VcService startupVcService = group.getStartUpVcService();
                    if (!VcServiceUtil.is60VcOrLater((String)startupVcService.getServiceVersion())) continue;
                    serviceUuid = group.getStartUpVcService().getServiceGuid();
                    break;
                }
            }
        }
        TagService tagService = this.getTagServiceInternal(serviceUuid);
        return tagService;
    }

    private TagService getTagServiceInternal(String serviceUuid) throws Exception {
        VcService vcService = Util.getVcServiceByUuid(serviceUuid);
        if (vcService == null) {
            LinkedVcGroupRegistry registry = VimSessionUtil.getLinkedVcGroupRegistry();
            LinkedVcGroup group = registry.getLinkedGroupByServiceUuid(serviceUuid);
            Collection vcServices = group.getVcServices();
            if (vcServices.isEmpty()) {
                VcService startUpService = group.getStartUpVcService();
                String url = startUpService != null ? startUpService.getServiceUrl() : "???";
                throw new IllegalStateException(LinkedVcGroup.class.getSimpleName() + " " + url + " doesn't contain any active VC services. Check the log to find out the reason.");
            }
            vcService = (VcService)vcServices.iterator().next();
        }
        Client client = this.getClient(vcService);
        TagServiceImpl tagService = new TagServiceImpl(client);
        return tagService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Client getClient(VcService vcService) throws AuthenticationException, HostConnectException {
        Client client = null;
        Map queryClientPerVcService = (Map)SessionUtil.getData((String)QUERY_CLIENT_PER_VC_SERVICE_MAP, null, (boolean)true);
        if (queryClientPerVcService == null) {
            _logger.error((Object)"Something went wrong with the user session. The queryClientPerVcService map is null");
            throw new IllegalStateException("The tagging service client could not be retrievedbecause queryClientPerVcMap is null.");
        }
        HttpSession currentSession = SessionUtil.getHttpSession();
        CountDownLatch countDownLatch = SessionUtil.getSessionMonitor((HttpSession)currentSession);
        synchronized (countDownLatch) {
            if (queryClientPerVcService.containsKey(vcService)) {
                client = (Client)queryClientPerVcService.get(vcService);
            } else {
                client = this._clientManager.createClient(vcService);
                queryClientPerVcService.put(vcService, client);
            }
        }
        return client;
    }

    private String chooseVcForTaggingOperations() {
        _logger.debug((Object)"chooseVcForTaggingOperations using LS");
        String hostId = LookupUtil.getLocalHostId((LookupService)this._lookupService);
        if (hostId == null) {
            return null;
        }
        ServiceRegistration.ServiceType vcServiceType = new ServiceRegistration.ServiceType("com.vmware.cis", "vcenterserver");
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setServiceType(vcServiceType);
        ServiceRegistration.Info[] vcServiceInfos = null;
        vcServiceInfos = this._lookupService.getServiceRegistrationInfos(filter);
        if (vcServiceInfos != null) {
            for (ServiceRegistration.Info info : vcServiceInfos) {
                String serviceHostId = LookupUtil.getServiceHostId((ServiceRegistration.Info)info);
                if (!hostId.equals(serviceHostId)) continue;
                return info.getServiceId();
            }
        }
        return null;
    }

    public void sessionStarted(HttpSessionEvent event, Locale locale) throws Exception {
        SessionUtil.setData((String)QUERY_CLIENT_PER_VC_SERVICE_MAP, new HashMap(), (HttpSession)event.getSession());
    }

    public void sessionEnded(HttpSessionEvent event) throws Exception {
        Map queryClientPerVcService = (Map)SessionUtil.getData((String)QUERY_CLIENT_PER_VC_SERVICE_MAP, (HttpSession)event.getSession(), (boolean)true);
        if (queryClientPerVcService == null) {
            _logger.error((Object)"Something went wrong with the user session. The queryClientPerVcService map is null");
            throw new IllegalStateException("The queryClientPerVcMap is null");
        }
        for (Map.Entry entry : queryClientPerVcService.entrySet()) {
            Client client = (Client)entry.getValue();
            VcService vcService = (VcService)entry.getKey();
            this._clientManager.closeClient(client, vcService);
        }
        SessionUtil.removeData((String)QUERY_CLIENT_PER_VC_SERVICE_MAP, (HttpSession)event.getSession());
    }
}

