/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.tagging.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.query.util.ResultUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaggingPropertyProvider
implements PropertyProviderBean {
    private final DataService _dataService;
    private final QuerySpecBuilder _querySpecBuilder;
    private final ObjectReferenceService _objRefervice;
    private static final String ASSOCIABLE_WITH_ALL_ENTITY_TYPES = "associableWithAllEntityTypes";
    private static final String ASSOCIABLE_ENTITY_TYPE_NAME = "associableEntityTypeName";
    private static final String TAG_CATEGORY_PROP = "category";
    private static final String TAG_CATEGORY_TYPE = "inventoryservice:InventoryServiceCategory";
    private static final String TAG_CATEGORY_MULTIPLE_CARDINALITY_PROP = "multipleCardinality";
    private static final String TAG_CATEGORY_CHILD_TAGS_PROP = "childTags";
    private static final String TAG_CATEGORY_ENTITY_PROP = "entity";
    private static final String TAG_TYPE = "inventoryservice:InventoryServiceTag";
    private static final String HOSTSYSTEM = "HostSystem";
    private static final String TYPE_MANAGED_ENTITY = "ManagedEntity";
    private static final String INVENTORY_SERVICE_TAG = "inventoryservice:tag";

    public TaggingPropertyProvider(DataService dataService, QuerySpecBuilder querySpecBuilder, ObjectReferenceService objRefervice) {
        this._dataService = dataService;
        this._querySpecBuilder = querySpecBuilder;
        this._objRefervice = objRefervice;
    }

    @type(value="Folder,Datacenter,HostSystem,ComputeResource,VirtualMachine,ClusterComputeResource,Datastore,DistributedVirtualPortgroup,DistributedVirtualSwitch,OpaqueNetwork,VmwareDistributedVirtualSwitch,ResourcePool,VirtualApp,StoragePod,Network,com.vmware.content.Library,com.vmware.content.library.Item")
    public Object getAssignableTagsForTarget(Object target) {
        String targetType = this._objRefervice.getResourceObjectType(target);
        CompositeConstraint tagConstraint = this._querySpecBuilder.createCompositeConstraint(new Constraint[]{this.associableTagsConstraint(targetType), this.categoryForTagConstraint(target), this.cardinalityForTagsConstraint(target)}, Conjoiner.EXCEPT);
        QuerySpec qSpec1 = this._querySpecBuilder.buildQuerySpec((Constraint)tagConstraint, new String[]{"name", TAG_CATEGORY_PROP, "description"});
        CompositeConstraint compositeConstraint = this._querySpecBuilder.createCompositeConstraint(new Constraint[]{this.associableTagsConstraint(targetType), this.categoryForTagConstraint(target), this.cardinalityForTagsConstraint(target)}, Conjoiner.EXCEPT);
        RelationalConstraint categoryConstraint = this._querySpecBuilder.createRelationalConstraint(TAG_CATEGORY_PROP, (Constraint)compositeConstraint, Boolean.valueOf(true), TAG_CATEGORY_TYPE);
        QuerySpec qSpec2 = this._querySpecBuilder.buildQuerySpec((Constraint)categoryConstraint, new String[]{"name"});
        RequestSpec reqSpec = new RequestSpec();
        reqSpec.querySpec = new QuerySpec[]{qSpec1, qSpec2};
        Response response = this._dataService.getData(reqSpec);
        return this.formatAssociableTagsResultSet(response.resultSet[0], response.resultSet[1]);
    }

    @type(value="Folder,Datacenter,HostSystem,ComputeResource,VirtualMachine,ClusterComputeResource,Datastore,DistributedVirtualPortgroup,DistributedVirtualSwitch,OpaqueNetwork,VmwareDistributedVirtualSwitch,ResourcePool,VirtualApp,StoragePod,Network,com.vmware.content.LibraryModel,com.vmware.content.library.ItemModel")
    public List<Map<String, Object>> getAllTags(ManagedObjectReference target) {
        Constraint tagConstraint = new Constraint();
        tagConstraint.targetType = TAG_TYPE;
        QuerySpec tagQuerySpec = this._querySpecBuilder.buildQuerySpec(tagConstraint, new String[]{"name", "description", "categoryName"});
        RequestSpec reqSpec = new RequestSpec();
        reqSpec.querySpec = new QuerySpec[]{tagQuerySpec};
        Response response = this._dataService.getData(reqSpec);
        return this.formatAllTagsResultSet(response.resultSet[0]);
    }

    @type(value="inventoryservice:InventoryServiceTag")
    public ResultSet getEntityObjects(ManagedObjectReference target) {
        Constraint tagConstraint = this.managedForTagConstraint(target);
        tagConstraint.targetType = INVENTORY_SERVICE_TAG;
        QuerySpec tagQuerySpec = this._querySpecBuilder.buildQuerySpec(tagConstraint, new String[]{"name"});
        RequestSpec reqSpec = new RequestSpec();
        reqSpec.querySpec = new QuerySpec[]{tagQuerySpec};
        Response response = this._dataService.getData(reqSpec);
        return response.resultSet[0];
    }

    private Constraint managedForTagConstraint(ManagedObjectReference target) {
        ObjectIdentityConstraint objectIdentityConstraint = this._querySpecBuilder.createObjectIdentityConstraint((Object)target);
        return this._querySpecBuilder.createRelationalConstraint(INVENTORY_SERVICE_TAG, (Constraint)objectIdentityConstraint, Boolean.valueOf(false), TYPE_MANAGED_ENTITY);
    }

    private Constraint associableTagsConstraint(String targetType) {
        PropertyConstraint propertyConstraint1 = this._querySpecBuilder.createPropertyConstraint(TAG_CATEGORY_TYPE, ASSOCIABLE_WITH_ALL_ENTITY_TYPES, Comparator.EQUALS, (Object)true);
        PropertyConstraint propertyConstraint2 = this._querySpecBuilder.createPropertyConstraint(TAG_CATEGORY_TYPE, ASSOCIABLE_ENTITY_TYPE_NAME, Comparator.EQUALS, (Object)targetType);
        CompositeConstraint nestedCompositeConstraint = this._querySpecBuilder.createCompositeConstraint(new Constraint[]{propertyConstraint1, propertyConstraint2}, Conjoiner.OR);
        RelationalConstraint relationalConstraint = this._querySpecBuilder.createRelationalConstraint(TAG_CATEGORY_PROP, (Constraint)nestedCompositeConstraint, Boolean.valueOf(false), TAG_TYPE);
        return this._querySpecBuilder.createCompositeConstraint(new Constraint[]{relationalConstraint}, Conjoiner.AND);
    }

    private Constraint categoryForTagConstraint(Object target) {
        ObjectIdentityConstraint objectIdentityConstraint = this._querySpecBuilder.createObjectIdentityConstraint(target);
        return this._querySpecBuilder.createRelationalConstraint(TAG_CATEGORY_ENTITY_PROP, (Constraint)objectIdentityConstraint, Boolean.valueOf(false), TAG_TYPE);
    }

    private Constraint cardinalityForTagsConstraint(Object target) {
        ObjectIdentityConstraint objectIdentityConstraint = this._querySpecBuilder.createObjectIdentityConstraint(target);
        RelationalConstraint nestedRelationalConstraint1 = this._querySpecBuilder.createRelationalConstraint(TAG_CATEGORY_ENTITY_PROP, (Constraint)objectIdentityConstraint, Boolean.valueOf(false), TAG_TYPE);
        RelationalConstraint nestedRelationalConstraint2 = this._querySpecBuilder.createRelationalConstraint(TAG_CATEGORY_CHILD_TAGS_PROP, (Constraint)nestedRelationalConstraint1, Boolean.valueOf(false), TAG_CATEGORY_TYPE);
        PropertyConstraint nestedPropertyConstraint = this._querySpecBuilder.createPropertyConstraint(TAG_CATEGORY_TYPE, TAG_CATEGORY_MULTIPLE_CARDINALITY_PROP, Comparator.EQUALS, (Object)false);
        CompositeConstraint compositeConstraint = this._querySpecBuilder.createCompositeConstraint(new Constraint[]{nestedPropertyConstraint, nestedRelationalConstraint2}, Conjoiner.AND);
        return this._querySpecBuilder.createRelationalConstraint(TAG_CATEGORY_PROP, (Constraint)compositeConstraint, Boolean.valueOf(false), TAG_TYPE);
    }

    private List<Map<String, Object>> formatAllTagsResultSet(ResultSet tagResultSet) {
        ArrayList<Map<String, Object>> formattedTags = new ArrayList<Map<String, Object>>();
        for (ResultItem item : tagResultSet.items) {
            HashMap<String, String> itemPropertyMap = new HashMap<String, String>();
            itemPropertyMap.put("name", ResultUtil.getPropertyValue((ResultItem)item, (String)"name").value.toString());
            itemPropertyMap.put("description", ResultUtil.getPropertyValue((ResultItem)item, (String)"description").value.toString());
            itemPropertyMap.put("categoryName", ResultUtil.getPropertyValue((ResultItem)item, (String)"categoryName").value.toString());
            formattedTags.add(itemPropertyMap);
        }
        return formattedTags;
    }

    private List<Map<String, Object>> formatAssociableTagsResultSet(ResultSet tagResultSet, ResultSet categoryResultSet) {
        ArrayList formattedResultSet = null;
        if (tagResultSet != null && categoryResultSet != null) {
            formattedResultSet = new ArrayList();
            for (ResultItem item : tagResultSet.items) {
                HashMap<String, Object> itemPropertyMap = new HashMap<String, Object>();
                itemPropertyMap.put("name", ResultUtil.getPropertyValue((ResultItem)item, (String)"name").value.toString());
                if (ResultUtil.getPropertyValue((ResultItem)item, (String)"description") != null && ResultUtil.getPropertyValue((ResultItem)item, (String)"description").value != null) {
                    itemPropertyMap.put("description", ResultUtil.getPropertyValue((ResultItem)item, (String)"description").value.toString());
                } else {
                    itemPropertyMap.put("description", "");
                }
                String categoryName = this.findCategoryInCategoryList(categoryResultSet, ResultUtil.getPropertyValue((ResultItem)item, (String)TAG_CATEGORY_PROP));
                itemPropertyMap.put("categoryName", categoryName);
                itemPropertyMap.put("resourceObject", item.resourceObject);
                formattedResultSet.add(itemPropertyMap);
            }
        }
        return formattedResultSet;
    }

    private String findCategoryInCategoryList(ResultSet categoryResultSet, PropertyValue resourceObject) {
        for (ResultItem item : categoryResultSet.items) {
            if (!resourceObject.value.equals(item.resourceObject)) continue;
            return ResultUtil.getPropertyValue((ResultItem)item, (String)"name").value.toString();
        }
        return null;
    }
}

