/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.ConfigOption;
import com.vmware.vim.binding.vim.vm.GuestOsDescriptor;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.vm.util.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmListPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final String EFFECTIVE_GUEST_OS_FAMILY = "effectiveGuestOsFamily";
    private static final String NPIV_NODE_WWN = "npivNodeWwnAsStringArray";
    private static final String NPIV_PORT_WWN = "npivPortWwnAsStringArray";
    private static final String IS_VM_PRIMARY_OR_NORMAL = "isVMPrimaryOrNormal";
    private static final String VM_PROPERTY_GUEST_FAMILY = "guest.guestFamily";
    private static final String VM_IS_TEMPLATE = "config.template";
    private static final String VM_PROPERTY_CONFIG_GUEST_ID = "config.guestId";
    private static final String VM_PROPERTY_NPIV_NODE_WWN = "config.npivNodeWorldWideName";
    private static final String VM_PROPERTY_NPIV_PORT_WWN = "config.npivPortWorldWideName";
    private static final String VM_PROPERTY_FTROLE = "config.ftInfo.role";
    private static final Log _logger = LogFactory.getLog(VmListPropertyProviderAdapter.class);

    public VmListPropertyProviderAdapter(DataServiceExtensionRegistry registry) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = VirtualMachine.class.getSimpleName();
        ti.properties = new String[]{EFFECTIVE_GUEST_OS_FAMILY, NPIV_NODE_WWN, NPIV_PORT_WWN, IS_VM_PRIMARY_OR_NORMAL};
        DerivedPropertyInfo effectiveGuestOsFamilyInfo = new DerivedPropertyInfo();
        effectiveGuestOsFamilyInfo.propertyName = EFFECTIVE_GUEST_OS_FAMILY;
        effectiveGuestOsFamilyInfo.sourcePropertyNames = new String[]{VM_PROPERTY_GUEST_FAMILY, VM_IS_TEMPLATE, VM_PROPERTY_CONFIG_GUEST_ID};
        DerivedPropertyInfo npivNodeWwnInfo = new DerivedPropertyInfo();
        npivNodeWwnInfo.propertyName = NPIV_NODE_WWN;
        npivNodeWwnInfo.sourcePropertyNames = new String[]{VM_PROPERTY_NPIV_NODE_WWN};
        DerivedPropertyInfo npivPortWwnInfo = new DerivedPropertyInfo();
        npivPortWwnInfo.propertyName = NPIV_PORT_WWN;
        npivPortWwnInfo.sourcePropertyNames = new String[]{VM_PROPERTY_NPIV_PORT_WWN};
        DerivedPropertyInfo isPrimaryOrNormal = new DerivedPropertyInfo();
        isPrimaryOrNormal.propertyName = IS_VM_PRIMARY_OR_NORMAL;
        isPrimaryOrNormal.sourcePropertyNames = new String[]{VM_PROPERTY_FTROLE};
        ti.derivedProperties = new DerivedPropertyInfo[]{effectiveGuestOsFamilyInfo, npivNodeWwnInfo, npivPortWwnInfo, isPrimaryOrNormal};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        HashSet<String> reqPropSet = new HashSet<String>();
        for (PropertySpec propSpec : properties) {
            for (String propName : propSpec.propertyNames) {
                reqPropSet.add(propName);
            }
        }
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        Map sourcePropertyValues = derivedPropertyData.getSourcePropertyValuesByObject();
        for (Object obj : objects) {
            Map sourcePropertyValuesMap = (Map)sourcePropertyValues.get(obj);
            if (sourcePropertyValuesMap == null) continue;
            ResultItem resItem = new ResultItem();
            resItem.resourceObject = obj;
            PropertyValue[] computedValues = this.computeResultSet(reqPropSet, sourcePropertyValuesMap, resItem.resourceObject);
            resItem.properties = computedValues;
            resultItems.add(resItem);
        }
        resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return resultSet;
    }

    private PropertyValue[] computeResultSet(Set<String> reqProps, Map<String, Object> propertyValuesMap, Object resourceObject) {
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>();
        if (reqProps.contains(EFFECTIVE_GUEST_OS_FAMILY)) {
            this.computeEffectiveGuestOsFamily(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(NPIV_NODE_WWN)) {
            this.computeNpivNodeWwn(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(NPIV_PORT_WWN)) {
            this.computeNpivPortWwn(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(IS_VM_PRIMARY_OR_NORMAL)) {
            this.computeIsPrimaryOrNormal(propertyValuesMap, results, resourceObject);
        }
        return results.toArray(new PropertyValue[0]);
    }

    private void computeIsPrimaryOrNormal(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> results, Object resourceObject) {
        Integer ftRole = (Integer)propertyValuesMap.get(VM_PROPERTY_FTROLE);
        boolean result = ftRole == null ? true : ftRole <= 1;
        results.add(VmListPropertyProviderAdapter.createPropValue(IS_VM_PRIMARY_OR_NORMAL, result, resourceObject));
    }

    private void computeNpivNodeWwn(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        long[] rawNpivNodeWwn = (long[])propertyValuesMap.get(VM_PROPERTY_NPIV_NODE_WWN);
        String[] npivNodeWwn = Util.formatAsHexStringArray(rawNpivNodeWwn);
        propValues.add(VmListPropertyProviderAdapter.createPropValue(NPIV_NODE_WWN, npivNodeWwn, resourceObject));
    }

    private void computeNpivPortWwn(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        long[] rawNpivPortWwn = (long[])propertyValuesMap.get(VM_PROPERTY_NPIV_PORT_WWN);
        String[] npivPortWwn = Util.formatAsHexStringArray(rawNpivPortWwn);
        propValues.add(VmListPropertyProviderAdapter.createPropValue(NPIV_PORT_WWN, npivPortWwn, resourceObject));
    }

    private void computeEffectiveGuestOsFamily(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        String guestFamilyFromGuestInfo = (String)propertyValuesMap.get(VM_PROPERTY_GUEST_FAMILY);
        if (!StringUtil.isNullOrEmpty((String)guestFamilyFromGuestInfo)) {
            propValues.add(VmListPropertyProviderAdapter.createPropValue(EFFECTIVE_GUEST_OS_FAMILY, guestFamilyFromGuestInfo, resourceObject));
            return;
        }
        Boolean isTempalte = (Boolean)propertyValuesMap.get(VM_IS_TEMPLATE);
        if (Boolean.TRUE.equals(isTempalte)) {
            propValues.add(VmListPropertyProviderAdapter.createPropValue(EFFECTIVE_GUEST_OS_FAMILY, null, resourceObject));
            return;
        }
        ConfigOption configOption = null;
        try {
            configOption = Util.getVmConfigOption((ManagedObjectReference)resourceObject);
        }
        catch (Exception e) {
            _logger.error((Object)"Error retrieveing vm config options.", (Throwable)e);
        }
        if (configOption == null) {
            propValues.add(VmListPropertyProviderAdapter.createPropValue(EFFECTIVE_GUEST_OS_FAMILY, null, resourceObject));
            return;
        }
        if (configOption.guestOSDescriptor.length == 1) {
            propValues.add(VmListPropertyProviderAdapter.createPropValue(EFFECTIVE_GUEST_OS_FAMILY, configOption.guestOSDescriptor[0].family, resourceObject));
            return;
        }
        String guestId = (String)propertyValuesMap.get(VM_PROPERTY_CONFIG_GUEST_ID);
        if (StringUtil.isNullOrEmpty((String)guestId)) {
            propValues.add(VmListPropertyProviderAdapter.createPropValue(EFFECTIVE_GUEST_OS_FAMILY, null, resourceObject));
            return;
        }
        GuestOsDescriptor[] guestOsDescriptors = configOption.guestOSDescriptor;
        String guestFamily = VmListPropertyProviderAdapter.getGuestFamilyByGuestId(guestOsDescriptors, guestId);
        propValues.add(VmListPropertyProviderAdapter.createPropValue(EFFECTIVE_GUEST_OS_FAMILY, guestFamily, resourceObject));
    }

    private static PropertyValue createPropValue(String name, Object value, Object provider) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = provider;
        return propValue;
    }

    private static String getGuestFamilyByGuestId(GuestOsDescriptor[] guestOsDescriptors, String guestId) {
        for (GuestOsDescriptor guestOsDescriptor : guestOsDescriptors) {
            if (!guestId.equals(guestOsDescriptor.id)) continue;
            return guestOsDescriptor.family;
        }
        return null;
    }
}

