/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.impl;

import com.vmware.vim.binding.vim.vm.CloneSpec;
import com.vmware.vim.binding.vim.vm.RelocateSpec;
import com.vmware.vim.binding.vim.vm.check.TestType;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.vm.VmCloneSpec;
import com.vmware.vsphere.client.vm.VmProvisioningType;

public class VmCloneSpecBuilder {
    public static Builder newSpec() {
        return new Builder();
    }

    public static class Builder {
        private ManagedObjectReference _vmRef;
        private ManagedObjectReference _poolRef;
        private ManagedObjectReference _hostRef;
        private ManagedObjectReference _folderRef;
        private ManagedObjectReference _datastoreRef;
        private String _vmName;
        private VmProvisioningType _provisioningType = null;

        public Builder vm(ManagedObjectReference vmRef) {
            this._vmRef = vmRef;
            return this;
        }

        public Builder vmName(String vmName) {
            this._vmName = vmName;
            return this;
        }

        public Builder pool(ManagedObjectReference poolRef) {
            this._poolRef = poolRef;
            return this;
        }

        public Builder host(ManagedObjectReference hostRef) {
            this._hostRef = hostRef;
            return this;
        }

        public Builder folder(ManagedObjectReference folderRef) {
            this._folderRef = folderRef;
            return this;
        }

        public Builder datastore(ManagedObjectReference datastoreRef) {
            this._datastoreRef = datastoreRef;
            return this;
        }

        public Builder provisioningType(VmProvisioningType type2) {
            this._provisioningType = type2;
            return this;
        }

        public VmCloneSpec build() {
            VmCloneSpec vmCloneSpec = new VmCloneSpec();
            vmCloneSpec.vm = this._vmRef;
            vmCloneSpec.name = this._vmName;
            vmCloneSpec.cloneSpec = new CloneSpec();
            vmCloneSpec.cloneSpec.template = this.isTemplate();
            vmCloneSpec.cloneSpec.location = new RelocateSpec();
            vmCloneSpec.cloneSpec.location.pool = this._poolRef;
            vmCloneSpec.cloneSpec.location.host = this._hostRef;
            vmCloneSpec.cloneSpec.location.datastore = this._datastoreRef;
            vmCloneSpec.testsToRun = this.getVcTestTypeToRun();
            vmCloneSpec.folder = this._folderRef;
            return vmCloneSpec;
        }

        private boolean isTemplate() {
            return this._provisioningType == VmProvisioningType.cloneTemplateToTemplate || this._provisioningType == VmProvisioningType.cloneTemplateToVm;
        }

        private TestType[] getVcTestTypeToRun() {
            if (this._datastoreRef != null) {
                return new TestType[]{TestType.datastoreTests};
            }
            if (this._provisioningType == VmProvisioningType.cloneTemplateToVm || this._provisioningType == VmProvisioningType.cloneVmToVm) {
                return new TestType[]{TestType.sourceTests, TestType.resourcePoolTests, TestType.hostTests, TestType.networkTests};
            }
            if (this._provisioningType == VmProvisioningType.cloneTemplateToTemplate || this._provisioningType == VmProvisioningType.cloneVmToTemplate) {
                return new TestType[]{TestType.sourceTests, TestType.hostTests, TestType.networkTests};
            }
            return new TestType[0];
        }
    }
}

