/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.EnvironmentBrowser;
import com.vmware.vim.binding.vim.vm.ConfigTarget;
import com.vmware.vim.binding.vim.vm.DatastoreInfo;
import com.vmware.vim.binding.vim.vm.FaultToleranceConfigSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.vm.VmFaultToleranceServiceInternal;
import com.vmware.vsphere.client.vm.ft.VmFtCompatibleDatastores;
import com.vmware.vsphere.client.vm.util.Util;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmFaultToleranceServiceImpl
implements VmFaultToleranceServiceInternal {
    private static final String VM_PROPERTY_CLUSTER = "cluster";
    private static final String VM_PROPERTY_HOST = "host";
    private static final Log _logger = LogFactory.getLog(VmFaultToleranceServiceImpl.class);
    private DataService _dataService;

    public VmFaultToleranceServiceImpl(DataService _dataService) {
        this._dataService = _dataService;
    }

    @Override
    public ClusterComputeResource.FtCompatibilityResult getFaultToleranceCompatibility(ManagedObjectReference vmRef) throws Exception {
        ClusterComputeResource.FtCompatibilityResult result = null;
        ManagedObjectReference clusterRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)vmRef, (String)VM_PROPERTY_CLUSTER);
        if (clusterRef == null) {
            result = this.createVmNotInClusterResult(vmRef);
            return result;
        }
        ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
        result = cluster.queryCompatibilityForFaultTolerance(vmRef);
        return result;
    }

    @Override
    public ClusterComputeResource.FtCompatibleHostResult[] getFtCompatibleHosts(ManagedObjectReference vmRef, FaultToleranceConfigSpec placement) throws Exception {
        ClusterComputeResource.FtCompatibleHostResult[] result;
        ManagedObjectReference clusterRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)vmRef, (String)VM_PROPERTY_CLUSTER);
        if (clusterRef == null) {
            String message = Util.getLocalizedString("error.cannotFindVmCluster");
            throw new IllegalArgumentException(message);
        }
        ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
        for (ClusterComputeResource.FtCompatibleHostResult res : result = cluster.queryFaultToleranceCompatibleHosts(vmRef, placement)) {
            res.errors = VmFaultToleranceServiceImpl.transformFaultArray(res.errors);
            res.warnings = VmFaultToleranceServiceImpl.transformFaultArray(res.warnings);
        }
        return result;
    }

    private static Exception[] transformFaultArray(Exception[] faultArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])faultArray)) {
            return null;
        }
        Exception[] result = new Exception[faultArray.length];
        for (int i = 0; i < faultArray.length; ++i) {
            MethodFault mf;
            Object[] faultMessages;
            if (faultArray[i] instanceof MethodFault && !ArrayUtil.isNullOrEmpty((Object[])(faultMessages = (mf = (MethodFault)faultArray[i]).getFaultMessage()))) {
                MethodFault newMf = new MethodFault();
                String localizedMessage = faultMessages[0].getMessage();
                newMf.setMessage(localizedMessage);
                result[i] = newMf;
                continue;
            }
            result[i] = faultArray[i];
        }
        return result;
    }

    @Override
    public VmFtCompatibleDatastores getFtCompatibleDatastores(ManagedObjectReference vmRef) throws Exception {
        int i;
        ManagedObjectReference clusterRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)vmRef, (String)VM_PROPERTY_CLUSTER);
        ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
        ClusterComputeResource.FtCompatibleDatastoresResult compatibleDatastoreResult = cluster.queryFaultToleranceCompatibleDatastores(vmRef, null);
        Object[] metadataDatastores = compatibleDatastoreResult.compatibleFtMetadataDatastores;
        Object[] secondaryConfigDatastores = compatibleDatastoreResult.compatibleFtSecondaryConfigDatastores;
        Object[] secondaryDiskDatastores = compatibleDatastoreResult.compatibleFtSecondaryDiskDatastores;
        if (ArrayUtil.isNullOrEmpty((Object[])metadataDatastores) || ArrayUtil.isNullOrEmpty((Object[])secondaryConfigDatastores) || ArrayUtil.isNullOrEmpty((Object[])secondaryDiskDatastores)) {
            return null;
        }
        ManagedObjectReference envBrowserRef = cluster.getEnvironmentBrowser();
        EnvironmentBrowser envBrowser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)envBrowserRef);
        ConfigTarget configTarget = envBrowser.queryConfigTarget(null);
        DatastoreInfo[] clusterDsInfos = configTarget.datastore;
        HashMap<String, DatastoreInfo> dsInfoByMorefUid = new HashMap<String, DatastoreInfo>();
        for (DatastoreInfo dsi : clusterDsInfos) {
            dsInfoByMorefUid.put(dsi.datastore.datastore.getValue(), dsi);
        }
        VmFtCompatibleDatastores result = new VmFtCompatibleDatastores();
        ManagedObjectReference primaryHost = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)vmRef, (String)VM_PROPERTY_HOST);
        if (primaryHost == null) {
            _logger.error((Object)("Unable to get host for vm " + ManagedObjectUtil.morefToString((ManagedObjectReference)vmRef)));
            return null;
        }
        result.primaryHost = primaryHost;
        result.metadataDatastores = new DatastoreInfo[metadataDatastores.length];
        for (i = 0; i < metadataDatastores.length; ++i) {
            result.metadataDatastores[i] = (DatastoreInfo)dsInfoByMorefUid.get(metadataDatastores[i].getValue());
        }
        result.secondaryConfigDatastores = new DatastoreInfo[secondaryConfigDatastores.length];
        for (i = 0; i < secondaryConfigDatastores.length; ++i) {
            result.secondaryConfigDatastores[i] = (DatastoreInfo)dsInfoByMorefUid.get(secondaryConfigDatastores[i].getValue());
        }
        result.secondaryDiskDatastores = new DatastoreInfo[secondaryDiskDatastores.length];
        for (i = 0; i < secondaryDiskDatastores.length; ++i) {
            result.secondaryDiskDatastores[i] = (DatastoreInfo)dsInfoByMorefUid.get(secondaryDiskDatastores[i].getValue());
        }
        return result;
    }

    private ClusterComputeResource.FtCompatibilityResult createVmNotInClusterResult(ManagedObjectReference vmRef) throws Exception {
        ClusterComputeResource.FtCompatibilityResult result = new ClusterComputeResource.FtCompatibilityResult();
        String message = Util.getLocalizedString("error.cannotFindVmCluster");
        MethodFault fault = new MethodFault(message);
        fault.setMessage(message);
        result = new ClusterComputeResource.FtCompatibilityResult();
        result.errors = new MethodFault[]{fault};
        return result;
    }
}

