/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.ipaddress;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.net.IpConfigInfo;
import com.vmware.vim.binding.vim.vm.GuestInfo;
import com.vmware.vise.data.query.ComputedPropertyInfo;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class VmIpAddressPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final String VM_IP_ADDRESSES = "vmIpAddressList";
    private static final String VM_GUEST_NIC_INFO = "guest.net";
    private static final String VM_GUEST_IP_ADDRESS = "guest.ipAddress";

    public VmIpAddressPropertyProviderAdapter(DataServiceExtensionRegistry registry, DataService dataService) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = VirtualMachine.class.getSimpleName();
        ti.properties = new String[]{VM_IP_ADDRESSES};
        ComputedPropertyInfo qpi = new ComputedPropertyInfo();
        qpi.propertyName = VM_IP_ADDRESSES;
        qpi.componentProperties = new String[]{VM_GUEST_IP_ADDRESS};
        ti.computedProperties = new ComputedPropertyInfo[]{qpi};
        DerivedPropertyInfo derivedInfo = new DerivedPropertyInfo();
        derivedInfo.propertyName = VM_IP_ADDRESSES;
        derivedInfo.sourcePropertyNames = new String[]{VM_GUEST_NIC_INFO, VM_GUEST_IP_ADDRESS};
        ti.derivedProperties = new DerivedPropertyInfo[]{derivedInfo};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        Map sourcePropertyValues = derivedPropertyData.getSourcePropertyValuesByObject();
        for (Object obj : objects) {
            Map sourcePropertyValuesMap = (Map)sourcePropertyValues.get(obj);
            if (sourcePropertyValuesMap == null) continue;
            ResultItem resItem = new ResultItem();
            resItem.resourceObject = obj;
            String[] ipAddresses = this.getVmIpAddresses(sourcePropertyValuesMap);
            PropertyValue pv = new PropertyValue();
            pv.propertyName = VM_IP_ADDRESSES;
            pv.resourceObject = resItem.resourceObject;
            pv.value = ipAddresses;
            resItem.properties = new PropertyValue[]{pv};
            resultItems.add(resItem);
        }
        resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return resultSet;
    }

    private static <T> T getPropertyValue(Map<String, Object> propertyValuesMap, String propName) {
        return (T)propertyValuesMap.get(propName);
    }

    private String[] getVmIpAddresses(Map<String, Object> sourcePropertyValuesMap) {
        Object[] nicInfos = (GuestInfo.NicInfo[])VmIpAddressPropertyProviderAdapter.getPropertyValue(sourcePropertyValuesMap, VM_GUEST_NIC_INFO);
        String ipAddress = (String)VmIpAddressPropertyProviderAdapter.getPropertyValue(sourcePropertyValuesMap, VM_GUEST_IP_ADDRESS);
        if (ArrayUtil.isNullOrEmpty((Object[])nicInfos)) {
            String[] stringArray;
            if (StringUtil.isNullOrEmpty((String)ipAddress)) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ipAddress;
            }
            return stringArray;
        }
        List<String> vmIpAddresses = VmIpAddressPropertyProviderAdapter.getVmIpAddresses((GuestInfo.NicInfo[])nicInfos);
        return vmIpAddresses.toArray(new String[0]);
    }

    private static List<String> getVmIpAddresses(GuestInfo.NicInfo[] nicInfos) {
        ArrayList<String> ipAddresses = new ArrayList<String>();
        ArrayList<String> ipv6Addresses = new ArrayList<String>();
        for (GuestInfo.NicInfo nicInfo : nicInfos) {
            if (!nicInfo.connected || nicInfo.ipConfig == null || nicInfo.ipConfig.ipAddress == null) continue;
            for (IpConfigInfo.IpAddress ip : nicInfo.ipConfig.ipAddress) {
                String ipAddress = ip.ipAddress;
                VmIpAddressPropertyProviderAdapter.addIpAddress(ipAddress, ipAddresses, ipv6Addresses);
            }
        }
        ipAddresses.addAll(VmIpAddressPropertyProviderAdapter.getReorderedIPv6Addresses(ipv6Addresses));
        return ipAddresses;
    }

    private static void addIpAddress(String ipAddress, List<String> ipAddresses, List<String> ipv6Addresses) {
        if (!StringUtil.isNullOrEmpty((String)ipAddress)) {
            if (ipAddress.contains(".")) {
                ipAddresses.add(ipAddress);
            } else {
                ipv6Addresses.add(ipAddress);
            }
        }
    }

    private static List<String> getReorderedIPv6Addresses(List<String> ipv6Addresses) {
        if (ipv6Addresses == null) {
            return null;
        }
        ArrayList<String> reorderedAddresses = new ArrayList<String>();
        ArrayList<String> linkLocalAddresses = new ArrayList<String>();
        for (String ipv6Address : ipv6Addresses) {
            if (!VmIpAddressPropertyProviderAdapter.isLinkLocalAddress(ipv6Address)) {
                reorderedAddresses.add(ipv6Address);
                continue;
            }
            linkLocalAddresses.add(ipv6Address);
        }
        reorderedAddresses.addAll(linkLocalAddresses);
        return reorderedAddresses;
    }

    private static boolean isLinkLocalAddress(String ipv6Address) {
        return ipv6Address != null && ipv6Address.toUpperCase(Locale.ENGLISH).startsWith("FE80");
    }
}

