/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.migration.impl;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.vm.migration.VmMigrationOptions;
import com.vmware.vsphere.client.vm.migration.VmMigrationService;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmMigrationOptionsPropertyProvider
implements PropertyProviderAdapter {
    public static final String PROPERTY_VM_MIGRATION_OPTIONS = "vmMigrationOptions";
    private static final Log _logger = LogFactory.getLog(VmMigrationOptionsPropertyProvider.class);
    private final VmMigrationService _vmMigrationService;

    public VmMigrationOptionsPropertyProvider(DataServiceExtensionRegistry registry, VmMigrationService vmMigrationService) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._vmMigrationService = vmMigrationService;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = VirtualMachine.class.getSimpleName();
        ti.properties = new String[]{PROPERTY_VM_MIGRATION_OPTIONS};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        if (objects == null || properties == null) {
            _logger.error((Object)"objects or properties argument passed null.");
            return null;
        }
        ManagedObjectReference[] references = (ManagedObjectReference[])Arrays.copyOf(objects, objects.length, ManagedObjectReference[].class);
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> resultItemList = new ArrayList<ResultItem>();
        if (this.vmMigrationOptionsPropertyPresent(properties)) {
            try {
                VmMigrationOptions[] vmMigrationOptions;
                for (VmMigrationOptions vmOption : vmMigrationOptions = this._vmMigrationService.getVmMigrationOptions(references)) {
                    resultItemList.add(this.newResultItem(vmOption));
                }
            }
            catch (Exception ex) {
                _logger.error((Object)"Error fetching vm migration options", (Throwable)ex);
                resultSet.error = MixedUtil.getMethodFault((Throwable)ex);
            }
        }
        resultSet.items = resultItemList.toArray(new ResultItem[0]);
        return resultSet;
    }

    private ResultItem newResultItem(VmMigrationOptions vmOption) {
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = vmOption.vm;
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.propertyName = PROPERTY_VM_MIGRATION_OPTIONS;
        propertyValue.resourceObject = vmOption.vm;
        propertyValue.value = vmOption;
        resultItem.properties = new PropertyValue[]{propertyValue};
        return resultItem;
    }

    private boolean vmMigrationOptionsPropertyPresent(PropertySpec[] propertySpecArray) {
        for (PropertySpec propertySpec : propertySpecArray) {
            for (String property : propertySpec.propertyNames) {
                if (!PROPERTY_VM_MIGRATION_OPTIONS.equals(property)) continue;
                return true;
            }
        }
        return false;
    }
}

