/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.storageDrs.impl;

import com.vmware.vim.binding.vim.storageDrs.StoragePlacementSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.vm.VmCloneSpec;
import com.vmware.vsphere.client.vm.VmConfigSpec;
import com.vmware.vsphere.client.vm.VmCreateSpec;
import com.vmware.vsphere.client.vm.config.impl.ConfigSpecBuilder;

public class StoragePlacementSpecBuilder {
    public static StoragePlacementSpec createSpec(VmCreateSpec vmCreateSpec) throws Exception {
        StoragePlacementSpec spec = new StoragePlacementSpec();
        spec.type = StoragePlacementSpec.PlacementType.create.toString();
        spec.vm = null;
        spec.folder = vmCreateSpec.folder;
        spec.host = vmCreateSpec.host;
        spec.resourcePool = vmCreateSpec.pool;
        spec.configSpec = ConfigSpecBuilder.createSpec(vmCreateSpec.spec);
        spec.podSelectionSpec = vmCreateSpec.podSelectionSpec;
        return spec;
    }

    public static StoragePlacementSpec createSpec(VmCloneSpec vmCloneSpec) throws Exception {
        StoragePlacementSpec spec = new StoragePlacementSpec();
        spec.type = StoragePlacementSpec.PlacementType.clone.toString();
        spec.vm = vmCloneSpec.vm;
        spec.folder = vmCloneSpec.folder;
        if (vmCloneSpec.vmSpec != null) {
            vmCloneSpec.cloneSpec.config = ConfigSpecBuilder.buildSpec(vmCloneSpec.vmSpec);
        }
        spec.cloneName = vmCloneSpec.name;
        spec.cloneSpec = vmCloneSpec.cloneSpec;
        spec.podSelectionSpec = vmCloneSpec.podSelectionSpec;
        return spec;
    }

    public static StoragePlacementSpec createSpec(ManagedObjectReference vm, VmConfigSpec vmConfigSpec) throws Exception {
        StoragePlacementSpec spec = new StoragePlacementSpec();
        spec.type = StoragePlacementSpec.PlacementType.reconfigure.toString();
        spec.vm = vm;
        spec.folder = null;
        spec.host = null;
        spec.resourcePool = null;
        spec.configSpec = ConfigSpecBuilder.buildSpec(vmConfigSpec);
        spec.podSelectionSpec = vmConfigSpec.podSelectionSpec;
        return spec;
    }
}

