/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.tools.impl;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.vm.tools.VmToolsInstallerSpec;
import com.vmware.vsphere.client.vm.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmToolsManager {
    private static final Log _logger = LogFactory.getLog(VmToolsManager.class);

    public static OperationResult apply(ManagedObjectReference vmRef, VmToolsInstallerSpec spec) {
        switch (spec.operation) {
            case mountInstaller: {
                return VmToolsManager.mountTools(vmRef);
            }
            case unmountInstaller: {
                return VmToolsManager.unmountTools(vmRef);
            }
            case upgradeTools: {
                return VmToolsManager.upgradeTools(vmRef, spec.upgradeOptions);
            }
        }
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        result.error = MixedUtil.getMethodFault((Throwable)new IllegalArgumentException(Util.getLocalizedString("error.unrecognizedToolsOp")));
        return result;
    }

    private static OperationResult mountTools(ManagedObjectReference vmRef) {
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        try {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            vm.mountToolsInstaller();
            return result;
        }
        catch (Exception ex) {
            _logger.error((Object)"Could not mount tools installer", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
            return result;
        }
    }

    private static OperationResult unmountTools(ManagedObjectReference vmRef) {
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        try {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            vm.unmountToolsInstaller();
            return result;
        }
        catch (Exception ex) {
            _logger.error((Object)"Could not unmount tools installer", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
            return result;
        }
    }

    private static OperationResult upgradeTools(ManagedObjectReference vmRef, String upgradeOptions) {
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        try {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            ManagedObjectReference taskRef = vm.upgradeTools(upgradeOptions);
            result.task = taskRef;
            return result;
        }
        catch (Exception ex) {
            _logger.error((Object)"Could not start upgrade tools process", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
            return result;
        }
    }
}

