/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.util;

import com.vmware.vim.binding.vim.vm.check.Result;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vsphere.client.vm.impl.CompatibilityResult;

public class ValidationResultFormatter {
    public static CompatibilityResult format(Result result) {
        return ValidationResultFormatter.format(result, false);
    }

    public static CompatibilityResult format(Result result, boolean appendFaultMessages) {
        String localizedMessage;
        CompatibilityResult compatibilityResult = new CompatibilityResult();
        if (result.getError() != null) {
            for (Exception e : result.getError()) {
                localizedMessage = ValidationResultFormatter.buildFaultMessages(e, appendFaultMessages);
                compatibilityResult.addErrorMessage(localizedMessage);
            }
        }
        if (result.getWarning() != null) {
            for (Exception e : result.getWarning()) {
                localizedMessage = ValidationResultFormatter.buildFaultMessages(e, appendFaultMessages);
                compatibilityResult.addWarningMessage(localizedMessage);
            }
        }
        return compatibilityResult;
    }

    private static String buildFaultMessages(Exception e, boolean appendFaultMessages) {
        String faultMessage = e.getLocalizedMessage();
        if (appendFaultMessages) {
            LocalizableMessage[] messages = null;
            if (e instanceof MethodFault) {
                messages = ((MethodFault)e).getFaultMessage();
            } else if (e instanceof RuntimeFault) {
                messages = ((RuntimeFault)e).getFaultMessage();
            }
            if (messages != null) {
                for (LocalizableMessage localizedMessage : messages) {
                    if (localizedMessage == null) continue;
                    faultMessage = faultMessage + "\n" + localizedMessage.getMessage();
                }
            }
        }
        return faultMessage;
    }
}

