/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.rp;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ResourcePoolMoveToPropertyProvider {
    private static final String OWNER_PROPERTY = "owner";
    private final QueryService _queryService;

    public ResourcePoolMoveToPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="ResourcePool/isMoveToAvailable")
    public List<Boolean> getIsMoveToAvailable(Collection<ManagedObjectReference> rpRefs) {
        List<PropertyPredicate> filter = Collections.singletonList(new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, rpRefs));
        ResultSet resultSet = this._queryService.select(new String[]{"@modelKey", OWNER_PROPERTY}).from(new String[]{ResourcePool.class.getSimpleName()}).where(LogicalOperator.AND, filter).fetch();
        boolean areResourcePoolsMoveable = this.areResourcePoolsMoveable(resultSet.getItems());
        return new ArrayList<Boolean>(Collections.nCopies(rpRefs.size(), areResourcePoolsMoveable));
    }

    private boolean areResourcePoolsMoveable(List<ResourceItem> resourceItems) {
        if (!CollectionUtil.isNullOrEmpty(resourceItems)) {
            ManagedObjectReference firstElementOwner = (ManagedObjectReference)resourceItems.get(0).get(OWNER_PROPERTY);
            if (firstElementOwner == null) {
                return false;
            }
            for (int i = 1; i < resourceItems.size(); ++i) {
                ResourceItem current = resourceItems.get(i);
                if (firstElementOwner.equals(current.get(OWNER_PROPERTY))) continue;
                return false;
            }
        }
        return true;
    }
}

