/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.ceip.authentication;

import com.vmware.ph.ceip.authentication.DsHttpServletRequest;
import com.vmware.ph.ceip.authentication.DsHttpSession;
import com.vmware.ph.ceip.authentication.DsSessionSimulator;
import com.vmware.ph.ceip.authentication.ServiceEndpointInfo;
import com.vmware.ph.ceip.authentication.SessionSimulationException;
import com.vmware.ph.ceip.authentication.StsCertificatesManager;
import com.vmware.ph.ceip.authentication.StsCertificatesManagerImpl;
import com.vmware.ph.ceip.authentication.solutionuser.SolutionUserAuthenticationConfig;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.sso.tokenmgmt.TokenEx;
import com.vmware.sso.tokenmgmt.impl.NonAcquiringTokenManager;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.vim.version.internal.versions;
import com.vmware.vim.sso.client.DefaultSecurityTokenServiceFactory;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.exception.SsoException;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ServiceEndpointType;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.extensions.impl.LinkedVcGroupRegistryImpl;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.LoginSpec;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.impl.LinkedVcGroupImpl;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vsphere.client.ceip.util.DsProperties;
import java.net.URI;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsSessionSimulatorImpl
implements DsSessionSimulator {
    private static final long SESSION_TOKEN_LIFETIME = TimeUnit.DAYS.toSeconds(30L);
    private final UserSessionListener userSessionListener;
    private final TokenProvider tokenProvider;
    private final VcGroupsRegistryProvider registryProvider;
    private static final Logger logger = LoggerFactory.getLogger(DsSessionSimulatorImpl.class);

    public DsSessionSimulatorImpl(UserSessionListener queryServiceIndex, KeystoreService keystoreService, SsoService ssoService, LookupService lookupService, ConfigurationService configurationService) {
        this(queryServiceIndex, new TokenProvider(keystoreService, ssoService, new StsCertificatesManagerImpl(ssoService)), new VcGroupsRegistryProvider(lookupService, configurationService));
    }

    DsSessionSimulatorImpl(UserSessionListener queryServiceIndex, TokenProvider tokenProvider, VcGroupsRegistryProvider registryProvider) {
        this.userSessionListener = queryServiceIndex;
        this.tokenProvider = tokenProvider;
        this.registryProvider = registryProvider;
    }

    @Override
    public HttpServletRequest simulate(SolutionUserAuthenticationConfig authConfig, String simulationUserName) throws SessionSimulationException {
        TokenEx tokenEx = this.tokenProvider.createToken(authConfig);
        LinkedVcGroupRegistry registry = this.registryProvider.getLinkedVcGroupRegistry(tokenEx.getToken(), tokenEx.getIssuerSsoDomain(), authConfig, simulationUserName);
        DsHttpSession cisDsSession = this.simulateSession(tokenEx, registry, authConfig, simulationUserName);
        try {
            HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)cisDsSession);
            this.userSessionListener.sessionStarted(httpSessionEvent, Locale.US);
        }
        catch (Exception e) {
            String msg = "Error while simulating session for [" + simulationUserName + "]. The UserSessionListener throwed exception on sessionStarted(). We assume that the UI platform session life-cycle invariants are compromised. As a result we consider this session simulation attempt as failure. For further details see the underlying exception: " + e.getMessage();
            logger.error(msg, (Throwable)e);
            throw new SessionSimulationException(msg, e);
        }
        DsHttpServletRequest request = new DsHttpServletRequest(cisDsSession);
        SessionUtil.setHttpRequest((HttpServletRequest)request);
        return request;
    }

    @Override
    public void close(HttpServletRequest request) {
        if (request == null) {
            logger.debug("Request cannot be closed since it is null. Skipping close().");
            return;
        }
        HttpSession cisDataSession = request.getSession();
        LinkedVcGroupRegistry vcGroupRegistry = (LinkedVcGroupRegistry)SessionUtil.getData((String)"LINKED_VC_GROUP_REGISTRY", (HttpSession)cisDataSession);
        if (vcGroupRegistry != null) {
            LinkedVcGroup[] startupLinkedVcGroups;
            LinkedVcGroupRegistry.StartupGroupUtils utils = vcGroupRegistry.getUtils();
            for (LinkedVcGroup vcGroup : startupLinkedVcGroups = utils.getStartupLinkedVcGroups()) {
                vcGroup.logout();
            }
        } else {
            logger.warn("LinkedVcGroupRegistry not available in SessionUtil. As a result there are no LinkedVcGroups to logout from. We don't consider this an error. We assume that UI Platform has cleared the session correctly.");
        }
        try {
            this.userSessionListener.sessionEnded(new HttpSessionEvent(cisDataSession));
        }
        catch (Exception e) {
            logger.warn("Error invoking UserSessionListener's {} sessionEnded() for Session {}. No more attempts to close this session will be executed. We expect that UI Platform team manages session life-cycle properly even if session is not explicitly closed. For more details see the underlying exception: {}", new Object[]{this.userSessionListener, cisDataSession.getId(), e.getMessage(), e});
        }
        SessionUtil.removeAll((HttpSession)cisDataSession);
        SessionUtil.setHttpRequest(null);
    }

    private DsHttpSession simulateSession(TokenEx tokenEx, LinkedVcGroupRegistry registry, SolutionUserAuthenticationConfig authConfig, String simulationUserName) {
        String sessionId = UUID.randomUUID().toString();
        DsHttpSession cisDsSession = new DsHttpSession(sessionId);
        SessionUtil.generateAndSaveClientId((HttpSession)cisDsSession);
        SessionUtil.setData((String)"USER_NAME", (Object)simulationUserName, (HttpSession)cisDsSession);
        SessionUtil.setData((String)"LINKED_VC_GROUP_REGISTRY", (Object)registry, (HttpSession)cisDsSession);
        SsoDomain isserSsoDomain = tokenEx.getIssuerSsoDomain();
        AuthSessionUtil.setSsoToken((SsoDomain)isserSsoDomain, (SsoDomain)isserSsoDomain, (SamlToken)tokenEx.getToken(), (HttpSession)cisDsSession);
        AuthSessionUtil.setSsoTokenPrivateKey((PrivateKey)authConfig.getSolutionKey(), (HttpSession)cisDsSession);
        return cisDsSession;
    }

    public static class ServiceInitializationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final ServiceEndpointInfo _serviceEndpointInfo;

        public ServiceInitializationException(String message, ServiceEndpointInfo serviceEndpointInfo) {
            super(message);
            this._serviceEndpointInfo = serviceEndpointInfo;
        }

        public ServiceInitializationException(String message, ServiceEndpointInfo serviceEndpointInfo, Throwable cause) {
            super(message, cause);
            this._serviceEndpointInfo = serviceEndpointInfo;
        }

        public ServiceEndpointInfo getServiceEndpointInfo() {
            return this._serviceEndpointInfo;
        }
    }

    static class VcGroupsRegistryProvider {
        private final ServiceEndpointLocator serviceEndpointLocator;
        private final LinkedVcGroupFactory linkedVcGroupFactory;
        private final HomeLduFactory homeLduFactory;
        private final ConfigurationService configurationService;

        public VcGroupsRegistryProvider(LookupService lookupService, ConfigurationService configurationService) {
            this(new ServiceEndpointLocator(lookupService), new LinkedVcGroupFactory(), new HomeLduFactory(), configurationService);
        }

        VcGroupsRegistryProvider(ServiceEndpointLocator serviceEndpointLocator, LinkedVcGroupFactory linkedVcGroupFactory, HomeLduFactory homeLduFactory, ConfigurationService configurationService) {
            this.serviceEndpointLocator = serviceEndpointLocator;
            this.linkedVcGroupFactory = linkedVcGroupFactory;
            this.homeLduFactory = homeLduFactory;
            this.configurationService = configurationService;
        }

        public LinkedVcGroupRegistry getLinkedVcGroupRegistry(SamlToken token, SsoDomain domainWhichIssuedTheToken, SolutionUserAuthenticationConfig authConfig, String userName) {
            logger.debug("findTargetVcService for " + authConfig.getSolutionKeystoreName() + " solutionUser on behalf of userName = " + userName);
            String serviceHomeLdu = this.homeLduFactory.getHomeLdu();
            PrivateKey privateKey = authConfig.getSolutionKey();
            ServiceEndpointInfo vcEndpoint = this.findVcServiceEndpoint(serviceHomeLdu);
            ServiceEndpointInfo invEndpoint = this.findISServiceEndpoint(serviceHomeLdu);
            LoginSpec loginSpec = this.buildLoginSpec(serviceHomeLdu, vcEndpoint, invEndpoint, userName, token, domainWhichIssuedTheToken, privateKey, Locale.US);
            try {
                logger.debug("creating LinkedVcGroupImpl");
                LinkedVcGroup linkedVcGroup = this.linkedVcGroupFactory.create(loginSpec);
                logger.debug("LinkedVcGroupImpl created. Logging in.");
                linkedVcGroup.login();
                logger.debug("LinkedVcGroupImpl successfully logged in. Adding it to LinkedVcGroupRegistry.");
                LinkedVcGroupRegistryImpl registry = new LinkedVcGroupRegistryImpl();
                LinkedVcGroupRegistry.StartupGroupUtils utils = registry.getUtils();
                utils.addStartupLinkedVcGroup(linkedVcGroup);
                return registry;
            }
            catch (Exception e) {
                String message = "Exception occurred while locating TargetVCService " + vcEndpoint.toString() + " As a result session cannot be simulated, since there is no VC to work with. For more details see the underlying exception: " + e.getMessage();
                logger.error(message, (Throwable)e);
                throw new ServiceInitializationException(message, vcEndpoint, e);
            }
        }

        private ServiceEndpointInfo findISServiceEndpoint(String serviceHomeLdu) {
            ServiceEndpointInfo invEndpoint = null;
            String errorMsg = "No InventoryService records found in LDU " + serviceHomeLdu + ". Continue to work without InventoryService source. This may result in inability of DataService to collect certain types of data.";
            try {
                invEndpoint = this.serviceEndpointLocator.findServiceEndpointInfo(ServiceEndpointType.IS, serviceHomeLdu);
                if (invEndpoint == null) {
                    logger.warn(errorMsg);
                }
            }
            catch (Exception e) {
                logger.warn(errorMsg + " For further details see the underlying exception: " + e.getMessage(), (Throwable)e);
            }
            return invEndpoint;
        }

        private ServiceEndpointInfo findVcServiceEndpoint(String serviceHomeLdu) {
            ServiceEndpointInfo vcEndpoint = this.serviceEndpointLocator.findServiceEndpointInfo(ServiceEndpointType.VC, serviceHomeLdu);
            if (vcEndpoint == null) {
                throw new RuntimeException("No VC records found in LDU=" + serviceHomeLdu + " As a result a DataService session with logged-in VcService object in it cannot be simulated. Please file a SR for issue with the Customer Experience Improvement Program (CEIP)");
            }
            return vcEndpoint;
        }

        private LoginSpec buildLoginSpec(String homeLdu, ServiceEndpointInfo vcInfo, ServiceEndpointInfo invSvcInfo, String userName, SamlToken token, SsoDomain domainWhichIssuedTheToken, PrivateKey privateKey, Locale locale) {
            ServiceEndpointEx[] serviceEndpointExArray;
            ServiceEndpointEx invSvcEndpoint;
            SsoDomain vcSsoDomain = vcInfo.getSsoDomain();
            if (invSvcInfo != null) {
                Validate.isTrue((boolean)invSvcInfo.getSsoDomain().equals((Object)vcSsoDomain), (String)("VC domain: " + vcSsoDomain + ", IS domanin: " + invSvcInfo.getSsoDomain()));
            }
            LoginSpec loginSpec = new LoginSpec();
            loginSpec.ssoDomain = vcInfo.getSsoDomain();
            loginSpec.userName = userName;
            loginSpec.tokenProvider = new NonAcquiringTokenManager(vcSsoDomain, domainWhichIssuedTheToken, token);
            loginSpec.privateKey = privateKey;
            loginSpec.locale = locale.toString();
            loginSpec.serviceUrl = vcInfo.getServiceUrl().toString();
            loginSpec.serviceGuid = vcInfo.getServiceGuid();
            loginSpec.vmodlVersion = this.vmodlVersion();
            ServiceEndpointEx vcEndpoint = ServiceEndpointEx.buildVcServiceEndpoint((SsoDomain)vcSsoDomain, (String)homeLdu, (String)loginSpec.serviceGuid, (String)vcInfo.getInstanceName(), (String)loginSpec.serviceUrl, (String)vcInfo.getCertificate());
            ServiceEndpointEx serviceEndpointEx = invSvcEndpoint = invSvcInfo == null ? null : ServiceEndpointEx.buildInventoryServiceEndpoint((SsoDomain)vcSsoDomain, (String)homeLdu, (String)vcInfo.getServiceGuid(), (String)invSvcInfo.getServiceGuid(), (String)invSvcInfo.getServiceUrl().toString(), (String)invSvcInfo.getCertificate());
            if (invSvcEndpoint == null) {
                ServiceEndpointEx[] serviceEndpointExArray2 = new ServiceEndpointEx[1];
                serviceEndpointExArray = serviceEndpointExArray2;
                serviceEndpointExArray2[0] = vcEndpoint;
            } else {
                ServiceEndpointEx[] serviceEndpointExArray3 = new ServiceEndpointEx[2];
                serviceEndpointExArray3[0] = vcEndpoint;
                serviceEndpointExArray = serviceEndpointExArray3;
                serviceEndpointExArray3[1] = invSvcEndpoint;
            }
            loginSpec.endpoints = serviceEndpointExArray;
            return loginSpec;
        }

        private Class<?> vmodlVersion() {
            String rawValue = this.configurationService.getProperty("use.unstable.vmodl");
            boolean useUnstableVmodl = StringUtil.parseBoolean((String)rawValue, (boolean)false);
            if (useUnstableVmodl) {
                return versions.VIM_VERSION_NEWEST;
            }
            return versions.VIM_VERSION_STABLE;
        }

        static class HomeLduFactory {
            HomeLduFactory() {
            }

            public String getHomeLdu() {
                return DsProperties.getInstance().getHomeLdu();
            }
        }

        static class LinkedVcGroupFactory {
            LinkedVcGroupFactory() {
            }

            public LinkedVcGroup create(LoginSpec loginSpec) throws Exception {
                return new LinkedVcGroupImpl(loginSpec);
            }
        }

        static class ServiceEndpointLocator {
            private final LookupService lookupService;

            public ServiceEndpointLocator(LookupService lookupService) {
                this.lookupService = lookupService;
            }

            public ServiceEndpointInfo findServiceEndpointInfo(ServiceEndpointType serviceType, String serviceLdu) {
                ServiceEndpointInfo endpointInfo;
                String endpointType;
                ServiceRegistration.ServiceType serviceTypeDesc;
                logger.debug("findServiceEndpointInfo for serviceType={} and serviceLdu={}", (Object)serviceType.name(), (Object)serviceLdu);
                switch (serviceType) {
                    case VC: {
                        serviceTypeDesc = new ServiceRegistration.ServiceType("com.vmware.cis", "vcenterserver");
                        endpointType = "com.vmware.vim";
                        break;
                    }
                    case IS: {
                        serviceTypeDesc = new ServiceRegistration.ServiceType("com.vmware.cis", "cs.inventory");
                        endpointType = "com.vmware.cis.inventory";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("BUG: findServiceEndpointInfo() for unsupported type: " + serviceType);
                    }
                }
                ServiceRegistration.Info svcInfo = this.findServiceInLdu(serviceTypeDesc, serviceLdu);
                if (svcInfo != null) {
                    ServiceRegistration.Endpoint svcEndpoint = ServiceEndpointLocator.findEndpoint(svcInfo, endpointType);
                    SsoDomain ssoDomain = (SsoDomain)LookupUtil.getSsoDomain((ServiceRegistration.Info)svcInfo).orElse((Object)SsoDomain.getLocal());
                    String instanceName = ServiceEndpointLocator.getServiceAttr(svcInfo, "com.vmware.vim.vcenter.instanceName");
                    endpointInfo = new ServiceEndpointInfo(ssoDomain, serviceType, svcInfo.getServiceId(), instanceName, svcEndpoint.getUrl(), null);
                } else {
                    endpointInfo = null;
                }
                return endpointInfo;
            }

            private ServiceRegistration.Info findServiceInLdu(ServiceRegistration.ServiceType serviceType, String lduGuid) {
                ServiceRegistration.Filter filterCriteria = new ServiceRegistration.Filter();
                filterCriteria.setServiceType(serviceType);
                filterCriteria.setNodeId(lduGuid);
                filterCriteria.setSearchAllSsoDomains(Boolean.valueOf(true));
                ServiceRegistration.Info[] foundServices = this.lookupService.getServiceRegistrationInfos(filterCriteria);
                foundServices = foundServices == null ? new ServiceRegistration.Info[]{} : foundServices;
                logger.debug("LookupService returned {} services for filterCriteria={}", (Object)foundServices.length, (Object)filterCriteria);
                ServiceRegistration.Info result = null;
                if (foundServices.length == 0) {
                    logger.warn("No services found while searching for service {}:{} - LookupService returned empty list. For further details look in LookupService logs.", (Object)serviceType.getProduct(), (Object)serviceType.getType());
                } else {
                    result = foundServices[0];
                    logger.debug("Found service with nodeId={} that matches lduGuid={}.", (Object)result.getNodeId(), (Object)lduGuid);
                }
                return result;
            }

            private static ServiceRegistration.Endpoint findEndpoint(ServiceRegistration.Info serviceInfo, String soughtEndpointTypeId) {
                ServiceRegistration.Endpoint[] endpoints = serviceInfo.getServiceEndpoints();
                if (endpoints != null) {
                    for (ServiceRegistration.Endpoint endpoint : endpoints) {
                        String currentEndpointTypeId = endpoint.getEndpointType().getType();
                        if (!soughtEndpointTypeId.equals(currentEndpointTypeId)) continue;
                        return endpoint;
                    }
                }
                throw new RuntimeException("Can't find endpoint type '" + soughtEndpointTypeId + "' in " + serviceInfo.getClass().getSimpleName() + " " + serviceInfo.getServiceId());
            }

            static String getServiceAttr(ServiceRegistration.Info info, String key) {
                if (info != null && info.getServiceAttributes() != null) {
                    for (ServiceRegistration.Attribute serviceAttribute : info.getServiceAttributes()) {
                        if (!key.equals(serviceAttribute.getKey()) || serviceAttribute.getValue() == null) continue;
                        return serviceAttribute.getValue();
                    }
                }
                return null;
            }
        }
    }

    static class TokenProvider {
        private final KeystoreService keystoreService;
        private final SsoService ssoService;
        private final StsCertificatesManager stsCertManager;
        private final STSFactory stsFactrory;

        public TokenProvider(KeystoreService keystoreService, SsoService ssoService, StsCertificatesManager stsCertManager) {
            this(keystoreService, ssoService, stsCertManager, new STSFactory());
        }

        TokenProvider(KeystoreService keystoreService, SsoService ssoService, StsCertificatesManager stsCertManager, STSFactory stsFactory) {
            this.keystoreService = keystoreService;
            this.ssoService = ssoService;
            this.stsCertManager = stsCertManager;
            this.stsFactrory = stsFactory;
        }

        public TokenEx createToken(SolutionUserAuthenticationConfig authConfig) {
            ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader thisClassLoader = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(thisClassLoader);
            try {
                logger.debug("createToken after switching classloaders.");
                TokenSpec tokenSpec = new TokenSpec.Builder(SESSION_TOKEN_LIFETIME).delegationSpec(new TokenSpec.DelegationSpec(true)).createTokenSpec();
                SecurityTokenService sts = this.createLocalSolutionStsClient(authConfig);
                try {
                    logger.debug("createToken finished successfully.");
                    TokenEx tokenEx = new TokenEx(sts.acquireTokenByCertificate(tokenSpec), SsoDomain.getLocal());
                    return tokenEx;
                }
                catch (SsoException e) {
                    throw new RuntimeException("Cannot acquire SamlToken because SsoException was thrown.", e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalLoader);
            }
        }

        private SecurityTokenService createLocalSolutionStsClient(SolutionUserAuthenticationConfig authConfig) {
            SecurityTokenServiceConfig.ConnectionConfig connCfg;
            try {
                X509Certificate[] systemWideTrustedCerts = this.keystoreService.getSslTrustCertificates();
                SsoServerInfo ssoInfo = SsoUtil.getSsoServerInfo((Map)this.ssoService.getServerInfos(), (SsoDomain)SsoDomain.getLocal());
                connCfg = new SecurityTokenServiceConfig.ConnectionConfig(URI.create(ssoInfo.getStsUrl()).toURL(), systemWideTrustedCerts, null);
            }
            catch (Exception e) {
                String msg = "There was an error while getting SSO Server information and we cannot access the SSO Server. As a result no token can be acquired for solution user: " + authConfig.getSolutionKeystoreName() + " For more information see the SsoService logs and the underlying exception: " + e.getMessage();
                logger.error(msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
            SecurityTokenServiceConfig.HolderOfKeyConfig solutionHokCfg = new SecurityTokenServiceConfig.HolderOfKeyConfig((Key)authConfig.getSolutionKey(), authConfig.getSolutionCertificate(), null);
            List<X509Certificate> signingCerts = this.stsCertManager.getStsCertificates();
            SecurityTokenServiceConfig stsCfg = new SecurityTokenServiceConfig(connCfg, signingCerts.toArray(new X509Certificate[signingCerts.size()]), null, solutionHokCfg);
            return this.stsFactrory.getSecurityTokenService(stsCfg);
        }

        static class STSFactory {
            STSFactory() {
            }

            public SecurityTokenService getSecurityTokenService(SecurityTokenServiceConfig stsCfg) {
                return DefaultSecurityTokenServiceFactory.getSecurityTokenService((SecurityTokenServiceConfig)stsCfg);
            }
        }
    }
}

