/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.ceip.authentication.keystore;

import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VecsKeyStoreProvider {
    private static final Logger _logger = LoggerFactory.getLogger(VecsKeyStoreProvider.class);
    static String VECS_LOAD_PARAMETER_CLASSNAME = "com.vmware.provider.VecsLoadStoreParameter";
    private final KeyStoreInstantiator keyStoreInstantiator = new KeyStoreInstantiator();
    private final LoadStoreParameterLoader lspLoader = new LoadStoreParameterLoader();

    public KeyStore loadKeyStore(String storeName) throws KeyStoreException {
        KeyStore keyStore;
        try {
            _logger.debug("loadSystemWideKeyStore for storeName = " + storeName);
            keyStore = this.keyStoreInstantiator.getInstance("VKS2");
            KeyStore.LoadStoreParameter loadParam = this.lspLoader.loadParam(VECS_LOAD_PARAMETER_CLASSNAME, storeName);
            _logger.debug("SystemWideKeyStore loaded successfully for storeName = " + storeName);
            keyStore.load(loadParam);
        }
        catch (KeyStoreException e) {
            _logger.debug("The VKS provider is not available. We're most likely running in development mode. Let the exception through so the caller can know to fall back to a file-based key store.");
            throw e;
        }
        catch (ClassNotFoundException e) {
            _logger.debug("Should not be possible to happen.  if the VECS provider is available, so should be the VecsLoadStoreParameter");
            throw new KeyStoreException(String.format("VECS LoadStoreParameter type %s not available on java.ext classpath.", VECS_LOAD_PARAMETER_CLASSNAME), e);
        }
        catch (Exception e) {
            String message = "Failed to load system-wide VECS key store: " + e.getMessage();
            _logger.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        return keyStore;
    }

    static class LoadStoreParameterLoader {
        LoadStoreParameterLoader() {
        }

        public KeyStore.LoadStoreParameter loadParam(String className, String storeName) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
            Class<?> c = Class.forName(className);
            KeyStore.LoadStoreParameter loadParam = (KeyStore.LoadStoreParameter)c.getConstructor(String.class).newInstance(storeName);
            return loadParam;
        }
    }

    static class KeyStoreInstantiator {
        KeyStoreInstantiator() {
        }

        public KeyStore getInstance(String type) throws KeyStoreException {
            return KeyStore.getInstance(type);
        }
    }
}

