/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.support.client.api.impl;

import com.vmware.ph.common.net.ProxySettings;
import com.vmware.ph.exceptions.Bug;
import com.vmware.ph.support.client.api.SrUploader;
import com.vmware.ph.support.client.api.impl.SrUploaderImpl;
import com.vmware.ph.support.upload.impl.UploaderFactory;
import com.vmware.ph.upload.UploaderAbstractFactory;
import com.vmware.ph.upload.service.UploadService;
import com.vmware.ph.upload.service.UploadServiceBuilder;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.UUID;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SrUploaderFactory {
    private static final Logger log = LoggerFactory.getLogger(SrUploaderFactory.class);
    private static final int MAX_RETRIES_DEFAULT = 3;
    private static final int maxConnectionsTotal = 30;
    private static final int maxConnectionsPerRoute = 10;
    private static final int CONNECTION_TIMEOUT_DEFAULT = 3600000;

    private SrUploaderFactory() {
    }

    public static SrUploader getSrUploader() {
        return SrUploaderFactory.getSrUploader(null, UploadServiceBuilder.Environment.TESTING, null);
    }

    public static SrUploader getSrUploader(ProxySettings proxySettings, UploadServiceBuilder.Environment env) {
        UploaderFactory uploaderFactory = new UploaderFactory();
        UploadServiceBuilder uploadServiceBuilder = UploadServiceBuilder.create((UploadServiceBuilder.Environment)env, (UploaderAbstractFactory)uploaderFactory);
        return SrUploaderFactory.getSrUploader(uploadServiceBuilder, proxySettings, null, 3, 3600000);
    }

    public static SrUploader getSrUploader(ProxySettings proxySettings, UploadServiceBuilder.Environment env, int maxRetries, int connectionTimeout) {
        UploaderFactory uploaderFactory = new UploaderFactory();
        UploadServiceBuilder uploadServiceBuilder = UploadServiceBuilder.create((UploadServiceBuilder.Environment)env, (UploaderAbstractFactory)uploaderFactory);
        return SrUploaderFactory.getSrUploader(uploadServiceBuilder, proxySettings, null, maxRetries, connectionTimeout);
    }

    public static SrUploader getSrUploader(ProxySettings proxySettings, UploadServiceBuilder.Environment env, X509Certificate[] trustedCertificates) {
        UploaderFactory uploaderFactory = new UploaderFactory();
        UploadServiceBuilder uploadServiceBuilder = UploadServiceBuilder.create((UploadServiceBuilder.Environment)env, (UploaderAbstractFactory)uploaderFactory);
        return SrUploaderFactory.getSrUploader(uploadServiceBuilder, proxySettings, trustedCertificates, 3, 3600000);
    }

    public static SrUploader getSrUploader(ProxySettings proxySettings, UploadServiceBuilder.Environment env, X509Certificate[] trustedCertificates, int maxRetries, int connectionTimeout) {
        UploaderFactory uploaderFactory = new UploaderFactory();
        UploadServiceBuilder uploadServiceBuilder = UploadServiceBuilder.create((UploadServiceBuilder.Environment)env, (UploaderAbstractFactory)uploaderFactory);
        return SrUploaderFactory.getSrUploader(uploadServiceBuilder, proxySettings, trustedCertificates, maxRetries, connectionTimeout);
    }

    public static SrUploader getSrUploaderForCustomerServer(ProxySettings proxySettings, String serverUrl, X509Certificate[] trustedCertificates) {
        UploaderFactory uploaderFactory = new UploaderFactory();
        UploadServiceBuilder uploadServiceBuilder = UploadServiceBuilder.createForCustomServer((String)serverUrl, (UploaderAbstractFactory)uploaderFactory);
        return SrUploaderFactory.getSrUploader(uploadServiceBuilder, proxySettings, trustedCertificates, 3, 3600000);
    }

    public static SrUploader getSrUploaderForCustomerServer(ProxySettings proxySettings, String serverUrl, X509Certificate[] trustedCertificates, int maxRetries, int connectionTimeout) {
        UploaderFactory uploaderFactory = new UploaderFactory();
        UploadServiceBuilder uploadServiceBuilder = UploadServiceBuilder.createForCustomServer((String)serverUrl, (UploaderAbstractFactory)uploaderFactory);
        return SrUploaderFactory.getSrUploader(uploadServiceBuilder, proxySettings, trustedCertificates, maxRetries, connectionTimeout);
    }

    private static SrUploader getSrUploader(UploadServiceBuilder uploadServiceBuilder, ProxySettings proxySettings, X509Certificate[] trusteCertificates, int maxRetries, int connectionTimeout) {
        if (proxySettings != null) {
            uploadServiceBuilder.withProxySettings(proxySettings);
        }
        log.debug("Creating SrUploader with trustedCertificates = " + Arrays.toString(trusteCertificates));
        if (trusteCertificates != null) {
            TrustManager[] trustManagers = SrUploaderFactory.createTrustedManagersFromCertificates(trusteCertificates);
            uploadServiceBuilder.withTrustManagers(trustManagers);
        }
        UploadService uploadService = uploadServiceBuilder.withConnectionTimeout(connectionTimeout).withMaxConnectionsPerRoute(10).withMaxConnectionsTotal(30).withMaxRetries(maxRetries).build();
        return new SrUploaderImpl(uploadService);
    }

    private static TrustManager[] createTrustedManagersFromCertificates(X509Certificate[] certs) {
        Validate.notEmpty((Object[])certs);
        Validate.noNullElements((Object[])certs);
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null, null);
            for (X509Certificate cert : certs) {
                ks.setCertificateEntry(cert.getSubjectDN().getName() + "_" + UUID.randomUUID().toString(), cert);
            }
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init(ks);
            TrustManager[] trustManagers = factory.getTrustManagers();
            return trustManagers;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new Bug(e.getMessage(), (Throwable)e);
        }
    }
}

