/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.support.upload.impl;

import com.vmware.ph.common.net.HttpConnectionConfig;
import com.vmware.ph.common.net.ProxySettings;
import com.vmware.ph.exceptions.Bug;
import com.vmware.ph.support.upload.impl.ftp.UploaderImpl;
import com.vmware.ph.upload.AbstractUploader;
import com.vmware.ph.upload.TransferProgressListener;
import com.vmware.ph.upload.Uploader;
import com.vmware.ph.upload.UploaderAbstractFactory;
import com.vmware.ph.upload.model.UploadAlgorithm;
import com.vmware.ph.upload.model.UploadServerInfo;
import org.apache.http.auth.UsernamePasswordCredentials;

public class UploaderFactory
implements UploaderAbstractFactory {
    public Uploader buildUploader(UploadServerInfo serverInfo, ProxySettings proxySettings, TransferProgressListener progressListener, int maxResumesBeforeFailure, HttpConnectionConfig connectionConfig) {
        AbstractUploader u;
        UploadAlgorithm alg = serverInfo.algorithm;
        UsernamePasswordCredentials creds = this.getCredentials(serverInfo);
        switch (alg) {
            case JSCAPE_REST_v8: {
                u = this.createJs8Uploader(serverInfo, proxySettings, progressListener, maxResumesBeforeFailure, connectionConfig, creds);
                break;
            }
            case JSCAPE_REST_v7: {
                u = this.createJs7Uploader(serverInfo, proxySettings, progressListener, maxResumesBeforeFailure, connectionConfig, creds);
                break;
            }
            case FTP_CLIENT_IN_PASSIVE_MODE: {
                u = this.createFTPUploader(serverInfo, proxySettings, progressListener, maxResumesBeforeFailure, connectionConfig, creds);
                break;
            }
            default: {
                throw new Bug("Algorithm " + alg + " is not implemented.");
            }
        }
        return u;
    }

    UsernamePasswordCredentials getCredentials(UploadServerInfo serverInfo) {
        return new UsernamePasswordCredentials(serverInfo.credentials);
    }

    AbstractUploader createJs7Uploader(UploadServerInfo serverInfo, ProxySettings proxySettings, TransferProgressListener progressListener, int maxResumesBeforeFailure, HttpConnectionConfig connectionConfig, UsernamePasswordCredentials creds) {
        return new com.vmware.ph.support.upload.impl.http.js7.UploaderImpl(serverInfo.urlProtocol, serverInfo.urlHost, serverInfo.urlPort, creds.getUserName(), creds.getPassword(), serverInfo.chunkSize, proxySettings, progressListener, maxResumesBeforeFailure, connectionConfig);
    }

    AbstractUploader createJs8Uploader(UploadServerInfo serverInfo, ProxySettings proxySettings, TransferProgressListener progressListener, int maxResumesBeforeFailure, HttpConnectionConfig connectionConfig, UsernamePasswordCredentials creds) {
        return new com.vmware.ph.client.upload.impl.http.js8.UploaderImpl(serverInfo.urlProtocol, serverInfo.urlHost, serverInfo.urlPort, creds.getUserName(), creds.getPassword(), serverInfo.chunkSize, proxySettings, "", progressListener, maxResumesBeforeFailure, connectionConfig);
    }

    AbstractUploader createFTPUploader(UploadServerInfo serverInfo, ProxySettings proxySettings, TransferProgressListener progressListener, int maxResumesBeforeFailure, HttpConnectionConfig connectionConfig, UsernamePasswordCredentials creds) {
        return new UploaderImpl(serverInfo.urlProtocol, serverInfo.urlHost, serverInfo.urlPort, creds.getUserName(), creds.getPassword(), serverInfo.chunkSize, proxySettings, progressListener, maxResumesBeforeFailure, connectionConfig);
    }
}

